/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsutilstest.h"
#include "rdstest.h"
#include <RdsSid>
#include <RdsShareManager>

REGISTER_TEST(RdsUtilsTest);

RdsUtilsTest::RdsUtilsTest(QObject *parent)
		: QObject(parent)
{
}


RdsUtilsTest::~RdsUtilsTest()
{
}

void RdsUtilsTest::testDomainFunctions()
{
	///TODO set these up with a proper test environment
	QString tmp;

	tmp = RdsUtils::domain();
	QVERIFY(tmp == "RESARA");
	tmp = RdsUtils::realm();
	QVERIFY(tmp == "RESARA.LOCAL");
	tmp = RdsUtils::baseDN();
	QVERIFY(tmp == "DC=resara,DC=local");
}

void RdsUtilsTest::testSidFunctions()
{
	ReturnValue ret, ___ret;
	ret = TEST_FUNCTION(RdsUtils::getSidOfObject("CN=Administrator,CN=Users,DC=resara,DC=local"));
	RdsSid sid = ret.value<RdsSid>();
	QVERIFY(sid.rid() == 500);

	ret = TEST_FUNCTION(RdsUtils::getObjectBySid(sid));
	QVERIFY(ret.toString() == "CN=Administrator,CN=Users,DC=resara,DC=local");

	TEST_FUNCTION_ERROR(RdsUtils::getSidOfObject("BROKEN"));
	TEST_FUNCTION_ERROR(RdsUtils::getObjectBySid(RdsSid()));
}

void RdsUtilsTest::testPathFunctions()
{
	ReturnValue ret, ___ret;

	QVERIFY(RdsUtils::normalizePath("///bleh/one//two////three///") == "/bleh/one/two/three");
	QVERIFY(RdsUtils::normalizePath("!asdfasdf\\../.././///as dfasdfa\\") == "/!asdfasdf\\../as dfasdfa\\");

	QVERIFY(RdsUtils::pathType("asdfa|!@/asdf") == RdsUtils::System);
	QVERIFY(RdsUtils::pathType("/etc/fstab") == RdsUtils::System);
	QVERIFY(RdsUtils::pathType("@SHARE/MyShare/etc/fstab") == RdsUtils::Share);
	QVERIFY(RdsUtils::pathType("@VOLUME/MyVolume/etc/fstab") == RdsUtils::Volume);

	QVERIFY(RdsUtils::getRelativePath("asdfa|!@/asdf") == "asdfa|!@/asdf");
	QVERIFY(RdsUtils::getRelativePath("/etc/fstab") == "/etc/fstab");
	QVERIFY(RdsUtils::getRelativePath("@SHARE/MyShare/etc/fstab") == "/etc/fstab");
	QVERIFY(RdsUtils::getRelativePath("@VOLUME/MyVolume/etc/fstab") == "/etc/fstab");
	QVERIFY(RdsUtils::getRelativePath("@VOLUME/MyVolume/") == "/");
	TEST_FUNCTION_ERROR(RdsUtils::getRelativePath("@VOLUME/MyVolume"));

	TEST_FUNCTION_ERROR(RdsUtils::getShareName("/etc/fstab"));
	TEST_FUNCTION_ERROR(RdsUtils::getVolumeName("/etc/fstab"));
	TEST_FUNCTION_ERROR(RdsUtils::getShareName("@SHARE/MyShare"));
	TEST_FUNCTION_ERROR(RdsUtils::getVolumeName("@VOLUME/MyVolume"));
	QVERIFY(RdsUtils::getShareName("@SHARE/MyShare/etc/fstab") == "MyShare");
	QVERIFY(RdsUtils::getVolumeName("@VOLUME/MyVolume/etc/fstab") == "MyVolume");
	QVERIFY(RdsUtils::getShareName("@SHARE/MyShare/") == "MyShare");
	QVERIFY(RdsUtils::getVolumeName("@VOLUME/MyVolume/") == "MyVolume");

	QVERIFY(RdsUtils::getSystemPath("asdfa|!@/asdf") == RdsUtils::normalizePath("asdfa|!@/asdf"));
	QVERIFY(RdsUtils::getSystemPath("/etc/fstab") == "/etc/fstab");
	QVERIFY(RdsUtils::getSystemPath("@SHARE/sysvol/resara.local/scripts/") == "/usr/local/samba/var/locks/sysvol/resara.local/scripts");
	TEST_FUNCTION_ERROR(RdsUtils::getSystemPath("@SHARE/sysvol2/resara.local/scripts/"));
	TEST_FUNCTION_ERROR(RdsUtils::getSystemPath("@SHARE/"));
	QVERIFY(RdsUtils::getSystemPath("@VOLUME/data/share1/files/") == "/volumes/data/share1/files");
	TEST_FUNCTION_ERROR(RdsUtils::getSystemPath("@VOLUME/"));
	QVERIFY(RdsUtils::getSharePath("/usr/local/samba/var/locks/sysvol/resara.local/scripts") == QStringList() <<
	        "@SHARE/netlogon/" <<
	        "@SHARE/sysvol/resara.local/scripts/");
	QVERIFY(RdsUtils::getSharePath("/tmp/dontshareme").toStringList() == QStringList());
	QVERIFY(RdsUtils::getVolumePath("/volumes/data/share1/files") == "@VOLUME/data/share1/files");
	TEST_FUNCTION_ERROR(RdsUtils::getVolumePath("/tmp/notavolume"));
}

void RdsUtilsTest::testFileFunctions()
{
	ReturnValue ret, ___ret;
	RdsUtils::remove("/tmp/testdir", true);

	TEST_FUNCTION(RdsUtils::createDirectory("/tmp/testdir"));
	TEST_FUNCTION(RdsUtils::remove("/tmp/testdir"));
	TEST_FUNCTION_ERROR(RdsUtils::remove("/tmp/testdir"));
	TEST_FUNCTION_ERROR(RdsUtils::createDirectory("/tmp/testdir/one/two/three"));
	TEST_FUNCTION(RdsUtils::createDirectory("/tmp/testdir/one/two/three", true));
	TEST_FUNCTION_ERROR(RdsUtils::remove("/tmp/testdir/"));
	TEST_FUNCTION(RdsUtils::remove("/tmp/testdir/", true));

	QString contents = "ONE\nTWO\nTHREE\n";
	TEST_FUNCTION(RdsUtils::setFileContents("/tmp/testfile", qPrintable(contents)));
	TEST_FUNCTION(RdsUtils::rename("/tmp/testfile", "testfile2"));
	TEST_FUNCTION(RdsUtils::createDirectory("/tmp/testdir"));
	TEST_FUNCTION(RdsUtils::move("/tmp/testfile2", "/tmp/testdir/testfile3"));
	ret = TEST_FUNCTION(RdsUtils::fileContents("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == contents);
}

void RdsUtilsTest::testPermissionFunctions()
{
	ReturnValue ret, ___ret;

	ret = TEST_FUNCTION(RdsUtils::unixPermissions("/tmp/testdir/testfile3"));
	QVERIFY(ret.toInt() == 0644);
	TEST_FUNCTION(RdsUtils::setUnixPermissions("/tmp/testdir/testfile3", 0600));
	ret = TEST_FUNCTION(RdsUtils::unixPermissions("/tmp/testdir/testfile3"));
	QVERIFY(ret.toInt() == 0600);

	ret = TEST_FUNCTION(RdsUtils::owner("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == "root");
	ret = TEST_FUNCTION(RdsUtils::group("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == "root");

	TEST_FUNCTION(RdsUtils::setOwner("/tmp/testdir/testfile3", "administrator"));
	TEST_FUNCTION(RdsUtils::setGroup("/tmp/testdir/testfile3", "admin"));

	ret = TEST_FUNCTION(RdsUtils::owner("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == "administrator");
	ret = TEST_FUNCTION(RdsUtils::group("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == "admin");

	TEST_FUNCTION(RdsUtils::setOwner("/tmp/testdir/testfile3", 1));
	TEST_FUNCTION(RdsUtils::setGroup("/tmp/testdir/testfile3", 2));

	ret = TEST_FUNCTION(RdsUtils::owner("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == "daemon");
	ret = TEST_FUNCTION(RdsUtils::group("/tmp/testdir/testfile3"));
	QVERIFY(ret.toString() == "bin");

	TEST_FUNCTION(RdsUtils::setOwner("/tmp/testdir/testfile3", 10012));
	TEST_FUNCTION(RdsUtils::setGroup("/tmp/testdir/testfile3", 20021));

	ret = TEST_FUNCTION(RdsUtils::owner("/tmp/testdir/testfile3"));
	QVERIFY(ret.toInt() == 10012);
	ret = TEST_FUNCTION(RdsUtils::group("/tmp/testdir/testfile3"));
	QVERIFY(ret.toInt() == 20021);

	TEST_FUNCTION_ERROR(RdsUtils::setUnixPermissions("/tmp/testdir/testfile3asdfasfdasf", 0600));
	TEST_FUNCTION_ERROR(RdsUtils::unixPermissions("/tmp/testdir/testfile3dfsdadfsdf"));
	TEST_FUNCTION_ERROR(RdsUtils::setOwner("/tmp/testdir/testfile3", "asdfad!asdfas"));
	TEST_FUNCTION_ERROR(RdsUtils::setGroup("/tmp/testdir/testfile3", "aerasdfasdf#23asdf"));
	TEST_FUNCTION_ERROR(RdsUtils::setOwner("/tmp/testdir/testfileasdasdf", 1));
	TEST_FUNCTION_ERROR(RdsUtils::setGroup("/tmp/testdir/testfileasdfasdf", 2));
	TEST_FUNCTION_ERROR(RdsUtils::owner("/tmp/testdir/testfileasdfafssdf"));
	TEST_FUNCTION_ERROR(RdsUtils::group("/tmp/testdir/testfileasdfafssdf"));
}

