package org.red5.io.object;

/*
 * RED5 Open Source Flash Server - http://www.osflash.org/red5
 * 
 * Copyright (c) 2006-2009 by respective authors (see below). All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU Lesser General Public License as published by the Free Software 
 * Foundation; either version 2.1 of the License, or (at your option) any later 
 * version. 
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along 
 * with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Result of pageable request, one page of data.
 *
 * @author The Red5 Project (red5@osflash.org)
 * @author Joachim Bauch (jojo@struktur.de)
 * @see <a href="http://www.osflash.org/amf/recordset">osflash.org documentation</a>
 */
public class RecordSetPage {
    /**
     * Recordset cursor
     */
	private int cursor;
    /**
     * Data as List
     */
	private List<List<Object>> data;

    /**
     * Creates recordset page from Input object
     * @param input       Input object to use as source for data that has to be deserialized
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
	public RecordSetPage(Input input) {
		Deserializer deserizalizer = new Deserializer();
		Map mapResult = deserizalizer.deserialize(input, Map.class);

		cursor = (Integer) mapResult.get("Cursor");
		data = (List<List<Object>>) mapResult.get("Page");
	}

	/**
     * Getter for recordset cursor
     *
     * @return  Recordset cursor
     */
    protected int getCursor() {
		return cursor;
	}

	/**
     * Getter for page data
     *
     * @return Page data as unmodifiable list
     */
    protected List<List<Object>> getData() {
		return Collections.unmodifiableList(data);
	}

}
