/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  backend.h - header file for backend.c
  markus@mhoenicka.de 6-20-00

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


#ifndef backend_included
#define backend_included 1

#include "authorinfo.h"
#include "outformats.h"

struct REPRINT {
  char reprint[13]; /*  the reprint string: IN FILE etc. */
  char date[12]; /* the ON REQUEST date or NULL if [NOT] IN FILE */
  char avail[256]; /*  the availability string */
};

struct bibinfo {
  char* format_string; /* additional output format information */
  char* sort_string; /* specifies how to sort */
  char* xreflabel; /* label for sgml output */
  const char* encoding; /* character encoding of output */
  const char* entry_id; /* id in sgml document */
  int is_subseq; /* 1 if this is a subsequent reference of the same authors */
  unsigned long long n_refdb_id; /* id of the reference in the original database */
  unsigned long long n_startnumber; /* numeric citations start with number */
  const char* year_unique_suffix; /* optional suffix after the year */
};

struct renderinfo {
  char** ptr_ref;  /*  ptr to a ptr to a buffer created with malloc which
		       will receive the output. The calling function must
		       allocate the buffer with at least one byte. This
		       function will reallocate the buffer as needed.
		       *ptr will be updated whenever a realloc is necessary.
		       The calling function is responsible for freeing the
		       memory again. */
  size_t* ptr_ref_len; /*  ptr to a variable holding the allocated length
			   of ref. This variable will be updated if a
			   realloc is necessary. */
  dbi_result dbires;

  char* database; /* name of the database from which the data were pulled */
  char* dbname; /* ptr to string with ID database prefix */
  char* username; /*  ptr to string with the current username */
  char* pdfroot; /*  ptr to string with the pdf root path */
  char* cgi_url; /* ptr to string with URL for CSS file */
  struct bibinfo* ptr_biblio_info;  /*  ptr to struct containing the info
					which fields to print etc. */
  struct CLIENT_REQUEST* ptr_clrequest; /* ptr to struct with the client
					   request info */
  int ref_format; /*  the output format; possible values are defined as REFXX */
  unsigned long long nref_counter; /*  number of current dataset */
  int nuse_citestyle; /* 1 if citestyle-based formatting is requested,
			 0 if not */
  int javascript; /* select the javascript to insert into html/xhmtl output; use 0 if a script is not required */
  int frequency; /* if 1, include frequency information */
};


char* add_root_to_link(const char* link, const char* pdfroot);
unsigned long long get_reference_count(dbi_conn conn, unsigned long long* ptr_max_id, int n_istemp);
unsigned long long get_notes_count(dbi_conn conn, unsigned long long* ptr_max_id, int n_istemp);
int calculate_relative_frequency(unsigned long long frequency, unsigned long long refcount);
char* get_refdb_note_id(dbi_result dbires, char* id);
const char* get_refdb_note_key(dbi_result dbires);
char* get_refdb_note_date(dbi_result dbires, char* date, int mode);
short int get_refdb_note_share(dbi_result dbires);
const char* get_refdb_note_user_name(dbi_result dbires);
char* get_refdb_note_title_copy(dbi_result dbires);
char* get_refdb_note_content_copy(dbi_result dbires);
const char* get_refdb_note_content_type(dbi_result dbires);
const char* get_refdb_note_content_xmllang(dbi_result dbires);
dbi_result request_notes_by_ref(dbi_conn conn, unsigned long long n_id, int mode, const char* user, int share, int include_lists);
int free_request_notes_by_ref(dbi_conn conn);
dbi_result request_links(dbi_conn conn, unsigned long long n_id, int mode);
const char* get_link(dbi_result dbires, int *ptr_mode);
char* get_refdb_id(dbi_result dbires, char* id);
const char* get_refdb_citekey(dbi_result dbires);
const char* get_refdb_type(dbi_result dbires);
char* get_refdb_pubyear(dbi_result dbires, char* year);
const char* get_refdb_startpage(dbi_result dbires);
const char* get_refdb_endpage(dbi_result dbires);
char* get_refdb_abstract_copy(dbi_result dbires);
char* get_refdb_title_copy(dbi_result dbires);
const char* get_refdb_volume(dbi_result dbires);
const char* get_refdb_issue(dbi_result dbires);
char* get_refdb_booktitle_copy(dbi_result dbires);
const char* get_refdb_city(dbi_result dbires);
const char* get_refdb_publisher(dbi_result dbires);
char* get_refdb_title_series_copy(dbi_result dbires);
char* get_refdb_address_copy(dbi_result dbires);
/* char* get_refdb_url_copy(dbi_result dbires); */
const char* get_refdb_issn(dbi_result dbires);
const char* get_refdb_pyother_info(dbi_result dbires);
char* get_refdb_secyear(dbi_result dbires, char* year);
const char* get_refdb_secother_info(dbi_result dbires);
const char* get_refdb_user(dbi_result dbires, int n_fieldno);
const char* get_refdb_user1(dbi_result dbires);
const char* get_refdb_user2(dbi_result dbires);
const char* get_refdb_user3(dbi_result dbires);
const char* get_refdb_user4(dbi_result dbires);
const char* get_refdb_user5(dbi_result dbires);
const char* get_refdb_typeofwork(dbi_result dbires);
const char* get_refdb_area(dbi_result dbires);
const char* get_refdb_ostype(dbi_result dbires);
const char* get_refdb_degree(dbi_result dbires);
const char* get_refdb_runningtime(dbi_result dbires);
const char* get_refdb_classcodeintl(dbi_result dbires);
const char* get_refdb_classcodeus(dbi_result dbires);
const char* get_refdb_senderemail(dbi_result dbires);
const char* get_refdb_recipientemail(dbi_result dbires);
const char* get_refdb_mediatype(dbi_result dbires);
const char* get_refdb_numvolumes(dbi_result dbires);
const char* get_refdb_edition(dbi_result dbires);
const char* get_refdb_computer(dbi_result dbires);
const char* get_refdb_conferencelocation(dbi_result dbires);
const char* get_refdb_registrynum(dbi_result dbires);
const char* get_refdb_classification(dbi_result dbires);
const char* get_refdb_section(dbi_result dbires);
const char* get_refdb_pamphletnum(dbi_result dbires);
const char* get_refdb_chapternum(dbi_result dbires);
const char* get_refdb_doi(dbi_result dbires);
char* get_notes_copy(dbi_result dbires, char* username);
struct REPRINT* get_reprint(dbi_result dbires, struct REPRINT* ptr_reprint, char* username, int yeardigits);
char* get_periodical(dbi_conn conn, char* periodical, const char* db, int type, int* errcode, int is_temp, unsigned long long id, unsigned long long* ptr_frequency);
dbi_result request_authors(dbi_conn conn, int type, const char* role, const char* db, int is_temp, unsigned long long n_id);
unsigned long long get_num_authors(dbi_result dbires);
const char* get_author(dbi_result dbires);
struct AUTHOR_INFO* get_author_parts(dbi_result dbires, struct AUTHOR_INFO* ptr_ainfo);
const char* get_extended_author(dbi_result dbires, int is_temp, unsigned long long* ptr_frequency);
struct AUTHOR_INFO* get_extended_author_parts(dbi_result dbires, struct AUTHOR_INFO* ptr_ainfo, int is_temp, unsigned long long* ptr_frequency);
dbi_result request_users(dbi_conn conn, const char* db, int is_temp, unsigned long long n_id);
const char* get_user(dbi_result dbires);
dbi_result request_keywords(dbi_conn conn, unsigned long long n_id, int mode, int is_temp);
const char* get_keyword(dbi_result dbires);
const char* get_extended_keyword(dbi_result dbires, int is_temp, unsigned long long* ptr_frequency);
unsigned long long get_num_keywords(dbi_result dbires);
dbi_result request_ulinks(dbi_conn conn, unsigned long long n_id, int mode, int type, int is_temp, const char* username);
const char* get_ulink(dbi_result dbires);
void clean_request(dbi_result dbires);
char* my_dbi_result_get_binary_copy(dbi_result Result, const char* fieldname);
const char* my_dbi_result_get_string(dbi_result Result, const char* fieldname);
const char* my_dbi_result_get_string_idx(dbi_result Result, unsigned int idx);
char* my_dbi_result_get_string_copy(dbi_result dbires, const char* fieldname);
char* my_dbi_result_get_string_copy_idx(dbi_result dbires, unsigned int idx);
const char* get_author_type_string(dbi_driver driver, int type);
int is_in_list(dbi_result dbires, char* username);
char* assemble_header(struct renderinfo* ptr_rendinfo);
int has_part_data(const char* type);
int has_set_data(const char* type);
int has_periodical_data(const char* type);
int has_chapter_data(const char* type);

dbi_result load_style(const char* pubtype, unsigned int citstyle_id, dbi_conn conn);
void unload_style(void);

/* libdbi _idx functions use a 1-based index */
enum refdb_col {ID = 1, AUTHORLISTSTYLE, EDITORLISTSTYLE, SEDITORLISTSTYLE, ALLALISTSTYLE, AUTHORLISTALTERNATESTYLE, EDITORLISTALTERNATESTYLE, SEDITORLISTALTERNATESTYLE, ALLALISTALTERNATESTYLE, AUTHORLISTALTERNATETEXT, EDITORLISTALTERNATETEXT, SEDITORLISTALTERNATETEXT, ALLALISTALTERNATETEXT, AUTHORLISTABBREVIATEFIRST, EDITORLISTABBREVIATEFIRST, SEDITORLISTABBREVIATEFIRST, ALLALISTABBREVIATEFIRST, AUTHORLISTABBREVIATESUBSEQ, EDITORLISTABBREVIATESUBSEQ, SEDITORLISTABBREVIATESUBSEQ, ALLALISTABBREVIATESUBSEQ, AUTHORLISTABBREVIATEFIRSTMAXAUTHOR, EDITORLISTABBREVIATEFIRSTMAXAUTHOR, SEDITORLISTABBREVIATEFIRSTMAXAUTHOR, ALLALISTABBREVIATEFIRSTMAXAUTHOR, AUTHORLISTABBREVIATESUBSEQMAXAUTHOR, EDITORLISTABBREVIATESUBSEQMAXAUTHOR, SEDITORLISTABBREVIATESUBSEQMAXAUTHOR, ALLALISTABBREVIATESUBSEQMAXAUTHOR, AUTHORLISTABBREVIATEFIRSTDISPLAYAUTHOR, EDITORLISTABBREVIATEFIRSTDISPLAYAUTHOR, SEDITORLISTABBREVIATEFIRSTDISPLAYAUTHOR, ALLALISTABBREVIATEFIRSTDISPLAYAUTHOR, AUTHORLISTABBREVIATESUBSEQDISPLAYAUTHOR, EDITORLISTABBREVIATESUBSEQDISPLAYAUTHOR, SEDITORLISTABBREVIATESUBSEQDISPLAYAUTHOR, ALLALISTABBREVIATESUBSEQDISPLAYAUTHOR, AUTHORLISTAEMPTY, EDITORLISTAEMPTY, SEDITORLISTAEMPTY, ALLALISTAEMPTY, AUTHORLISTASAME, EDITORLISTASAME, SEDITORLISTASAME, ALLALISTASAME, AUTHORLISTPRECEEDING, EDITORLISTPRECEEDING, SEDITORLISTPRECEEDING, ALLALISTPRECEEDING, AUTHORLISTFOLLOWING, EDITORLISTFOLLOWING, SEDITORLISTFOLLOWING, ALLALISTFOLLOWING, AUTHORLISTAUTHORSEPSTWOSEPS, EDITORLISTAUTHORSEPSTWOSEPS, SEDITORLISTAUTHORSEPSTWOSEPS, ALLALISTAUTHORSEPSTWOSEPS, AUTHORLISTAUTHORSEPSTHREESEPSTHREESEPSEACH, EDITORLISTAUTHORSEPSTHREESEPSTHREESEPSEACH, SEDITORLISTAUTHORSEPSTHREESEPSTHREESEPSEACH, ALLALISTAUTHORSEPSTHREESEPSTHREESEPSEACH, AUTHORLISTAUTHORSEPSTHREESEPSTHREESEPSLAST, EDITORLISTAUTHORSEPSTHREESEPSTHREESEPSLAST, SEDITORLISTAUTHORSEPSTHREESEPSTHREESEPSLAST, ALLALISTAUTHORSEPSTHREESEPSTHREESEPSLAST, AUTHORLISTAUTHORNAMESNAMEFIRSTNAMEORDER, EDITORLISTAUTHORNAMESNAMEFIRSTNAMEORDER, SEDITORLISTAUTHORNAMESNAMEFIRSTNAMEORDER, ALLALISTAUTHORNAMESNAMEFIRSTNAMEORDER, AUTHORLISTAUTHORNAMESNAMEFIRSTINITIALSTYLE, EDITORLISTAUTHORNAMESNAMEFIRSTINITIALSTYLE, SEDITORLISTAUTHORNAMESNAMEFIRSTINITIALSTYLE, ALLALISTAUTHORNAMESNAMEFIRSTINITIALSTYLE, AUTHORLISTAUTHORNAMESNAMEFIRSTUPPERCASE, EDITORLISTAUTHORNAMESNAMEFIRSTUPPERCASE, SEDITORLISTAUTHORNAMESNAMEFIRSTUPPERCASE, ALLALISTAUTHORNAMESNAMEFIRSTUPPERCASE, AUTHORLISTAUTHORNAMESNAMEOTHERNAMEORDER, EDITORLISTAUTHORNAMESNAMEOTHERNAMEORDER, SEDITORLISTAUTHORNAMESNAMEOTHERNAMEORDER, ALLALISTAUTHORNAMESNAMEOTHERNAMEORDER, AUTHORLISTAUTHORNAMESNAMEOTHERINITIALSTYLE, EDITORLISTAUTHORNAMESNAMEOTHERINITIALSTYLE, SEDITORLISTAUTHORNAMESNAMEOTHERINITIALSTYLE, ALLALISTAUTHORNAMESNAMEOTHERINITIALSTYLE, AUTHORLISTAUTHORNAMESNAMEOTHERUPPERCASE, EDITORLISTAUTHORNAMESNAMEOTHERUPPERCASE, SEDITORLISTAUTHORNAMESNAMEOTHERUPPERCASE, ALLALISTAUTHORNAMESNAMEOTHERUPPERCASE, AUTHORLISTTEXTTEXTSINGLEPRECEEDING, EDITORLISTTEXTTEXTSINGLEPRECEEDING, SEDITORLISTTEXTTEXTSINGLEPRECEEDING, ALLALISTTEXTTEXTSINGLEPRECEEDING, AUTHORLISTTEXTTEXTSINGLEFOLLOWING, EDITORLISTTEXTTEXTSINGLEFOLLOWING, SEDITORLISTTEXTTEXTSINGLEFOLLOWING, ALLALISTTEXTTEXTSINGLEFOLLOWING, AUTHORLISTTEXTTEXTMULTIPLEPRECEEDING, EDITORLISTTEXTTEXTMULTIPLEPRECEEDING, SEDITORLISTTEXTTEXTMULTIPLEPRECEEDING, ALLALISTTEXTTEXTMULTIPLEPRECEEDING, AUTHORLISTTEXTTEXTMULTIPLEFOLLOWING, EDITORLISTTEXTTEXTMULTIPLEFOLLOWING, SEDITORLISTTEXTTEXTMULTIPLEFOLLOWING, ALLALISTTEXTTEXTMULTIPLEFOLLOWING, AUTHORLISTTEXTEDTEXTSINGLEPRECEEDING, EDITORLISTTEXTEDTEXTSINGLEPRECEEDING, SEDITORLISTTEXTEDTEXTSINGLEPRECEEDING, ALLALISTTEXTEDTEXTSINGLEPRECEEDING, AUTHORLISTTEXTEDTEXTSINGLEFOLLOWING, EDITORLISTTEXTEDTEXTSINGLEFOLLOWING, SEDITORLISTTEXTEDTEXTSINGLEFOLLOWING, ALLALISTTEXTEDTEXTSINGLEFOLLOWING, AUTHORLISTTEXTEDTEXTMULTIPLEPRECEEDING, EDITORLISTTEXTEDTEXTMULTIPLEPRECEEDING, SEDITORLISTTEXTEDTEXTMULTIPLEPRECEEDING, ALLALISTTEXTEDTEXTMULTIPLEPRECEEDING, AUTHORLISTTEXTEDTEXTMULTIPLEFOLLOWING, EDITORLISTTEXTEDTEXTMULTIPLEFOLLOWING, SEDITORLISTTEXTEDTEXTMULTIPLEFOLLOWING, ALLALISTTEXTEDTEXTMULTIPLEFOLLOWING, PUBDATEPRECEEDING, PUBDATEFOLLOWING, PUBDATEFORMAT, PUBDATESEQUENCE, PUBDATEMONTHFORMAT, PUBDATEDAYFORMAT, PUBDATEYEARFORMAT, PUBDATEPADLEADINGZERO, PUBDATESTYLE, PUBDATESECPRECEEDING, PUBDATESECFOLLOWING, PUBDATESECFORMAT, PUBDATESECSEQUENCE, PUBDATESECMONTHFORMAT, PUBDATESECDAYFORMAT, PUBDATESECYEARFORMAT, PUBDATESECPADLEADINGZERO, PUBDATESECSTYLE, PUBDATEALLPRECEEDING, PUBDATEALLFOLLOWING, PUBDATEALLFORMAT, PUBDATEALLSEQUENCE, PUBDATEALLMONTHFORMAT, PUBDATEALLDAYFORMAT, PUBDATEALLYEARFORMAT, PUBDATEALLPADLEADINGZERO, PUBDATEALLSTYLE, TITLEPRECEEDING, TITLEFOLLOWING, TITLECASE, TITLESTYLE, BOOKTITLEPRECEEDING, BOOKTITLEFOLLOWING, BOOKTITLECASE, BOOKTITLESTYLE, SERIESTITLEPRECEEDING, SERIESTITLEFOLLOWING, SERIESTITLECASE, SERIESTITLESTYLE, ALLTITLEPRECEEDING, ALLTITLEFOLLOWING, ALLTITLECASE, ALLTITLESTYLE, JOURNALNAMEPRECEEDING, JOURNALNAMEFOLLOWING, JOURNALNAMECASE, JOURNALNAMEDEFAULTTEXT, JOURNALNAMEALTERNATETEXT, JOURNALNAMEPUNCTUATION, JOURNALNAMESTYLE, VOLUMEPRECEEDING, VOLUMEFOLLOWING, VOLUMESTYLE, ISSUEPRECEEDING, ISSUEFOLLOWING, ISSUESTYLE, PAGESSTYLE, PAGESSINGLEPAGEPRECEEDING, PAGESSINGLEPAGEFOLLOWING, PAGESPAGERANGEPRECEEDING, PAGESPAGERANGEFOLLOWING, PAGESPAGERANGETYPE, PUBLISHERPRECEEDING, PUBLISHERFOLLOWING, PUBLISHERSTYLE, PUBPLACEPRECEEDING, PUBPLACEFOLLOWING, PUBPLACESTYLE, PAGESPRECEEDING, PAGESFOLLOWING, REFNUMBERPRECEEDING, REFNUMBERFOLLOWING, REFNUMBERSTYLE, PUBDATEFIRSTSEP, PUBDATESECONDSEP, PUBDATESECFIRSTSEP, PUBDATESECSECONDSEP, PUBDATEALLFIRSTSEP, PUBDATEALLSECONDSEP, PAGESPAGERANGERANGESEPARATOR, SERIALPRECEEDING, SERIALFOLLOWING, SERIALSTYLE, ADDRESSPRECEEDING, ADDRESSFOLLOWING, ADDRESSSTYLE, USERDEF1PRECEEDING, USERDEF1FOLLOWING, USERDEF1STYLE, USERDEF2PRECEEDING, USERDEF2FOLLOWING, USERDEF2STYLE, USERDEF3PRECEEDING, USERDEF3FOLLOWING, USERDEF3STYLE, USERDEF4PRECEEDING, USERDEF4FOLLOWING, USERDEF4STYLE, USERDEF5PRECEEDING, USERDEF5FOLLOWING, USERDEF5STYLE, NOTESPRECEEDING, NOTESFOLLOWING, NOTESSTYLE, ABSTRACTPRECEEDING, ABSTRACTFOLLOWING, ABSTRACTSTYLE, TYPEOFWORKPRECEEDING, TYPEOFWORKFOLLOWING, TYPEOFWORKSTYLE, AREAPRECEEDING, AREAFOLLOWING, AREASTYLE, OSTYPEPRECEEDING, OSTYPEFOLLOWING, OSTYPESTYLE, DEGREEPRECEEDING, DEGREEFOLLOWING, DEGREESTYLE, RUNNINGTIMEPRECEEDING, RUNNINGTIMEFOLLOWING, RUNNINGTIMESTYLE, CLASSCODEINTLPRECEEDING, CLASSCODEINTLFOLLOWING, CLASSCODEINTLSTYLE, CLASSCODEUSPRECEEDING, CLASSCODEUSFOLLOWING, CLASSCODEUSSTYLE, SENDEREMAILPRECEEDING, SENDEREMAILFOLLOWING, SENDEREMAILSTYLE, RECIPIENTEMAILPRECEEDING, RECIPIENTEMAILFOLLOWING, RECIPIENTEMAILSTYLE, MEDIATYPEPRECEEDING, MEDIATYPEFOLLOWING, MEDIATYPESTYLE, NUMVOLUMESPRECEEDING, NUMVOLUMESFOLLOWING, NUMVOLUMESSTYLE, EDITIONPRECEEDING, EDITIONFOLLOWING, EDITIONSTYLE, COMPUTERPRECEEDING, COMPUTERFOLLOWING, COMPUTERSTYLE, CONFERENCELOCATIONPRECEEDING, CONFERENCELOCATIONFOLLOWING, CONFERENCELOCATIONSTYLE, REGISTRYNUMPRECEEDING, REGISTRYNUMFOLLOWING, REGISTRYNUMSTYLE, CLASSIFICATIONPRECEEDING, CLASSIFICATIONFOLLOWING, CLASSIFICATIONSTYLE, SECTIONPRECEEDING, SECTIONFOLLOWING, SECTIONSTYLE, PAMPHLETNUMPRECEEDING, PAMPHLETNUMFOLLOWING, PAMPHLETNUMSTYLE, CHAPTERNUMPRECEEDING, CHAPTERNUMFOLLOWING, CHAPTERNUMSTYLE, LINK0PRECEEDING, LINK0FOLLOWING, LINK0STYLE, LINK1PRECEEDING, LINK1FOLLOWING, LINK1STYLE, LINK2PRECEEDING, LINK2FOLLOWING, LINK2STYLE, LINK3PRECEEDING, LINK3FOLLOWING, LINK3STYLE, LINK4PRECEEDING, LINK4FOLLOWING, LINK4STYLE, CITEKEYPRECEEDING, CITEKEYFOLLOWING, CITEKEYSTYLE};

enum citestyle_col {CITID = 1, CITSEPARATOR, FOLLOWING, PRECEEDING, RANGESEPARATOR, INTEXTSEQUENCE, STYLE, JANFULL, FEBFULL, MARFULL, APRFULL, MAYFULL, JUNFULL, JULFULL, AUGFULL, SEPFULL, OCTFULL, NOVFULL, DECFULL, JANABBREV, FEBABBREV, MARABBREV, APRABBREV, MAYABBREV, JUNABBREV, JULABBREV, AUGABBREV, SEPABBREV, OCTABBREV, NOVABBREV, DECABBREV, JANTHREELET, FEBTHREELET, MARTHREELET, APRTHREELET, MAYTHREELET, JUNTHREELET, JULTHREELET, AUGTHREELET, SEPTHREELET, OCTTHREELET, NOVTHREELET, DECTHREELET};

enum refdbref_col {REFDB_ID = 1, REFDB_TYPE, REFDB_PUBYEAR, REFDB_STARTPAGE, REFDB_ENDPAGE, REFDB_ABSTRACT, REFDB_TITLE, REFDB_VOLUME, REFDB_ISSUE, REFDB_BOOKTITLE, REFDB_CITY, REFDB_PUBLISHER, REFDB_TITLE_SERIES, REFDB_ADDRESS, REFDB_ISSN, REFDB_PERIODICAL_ID, REFDB_PYOTHER_INFO, REFDB_SECYEAR, REFDB_SECOTHER_INFO, REFDB_USER1, REFDB_USER2, REFDB_USER3, REFDB_USER4, REFDB_USER5, REFDB_TYPEOFWORK, REFDB_AREA, REFDB_OSTYPE, REFDB_DEGREE, REFDB_RUNNINGTIME, REFDB_CLASSCODEINTL, REFDB_CLASSCODEUS, REFDB_SENDEREMAIL, REFDB_RECIPIENTEMAIL, REFDB_MEDIATYPE, REFDB_NUMVOLUMES, REFDB_EDITION, REFDB_COMPUTER, REFDB_CONFERENCELOCATION, REFDB_REGISTRYNUM, REFDB_CLASSIFICATION, REFDB_SECTION, REFDB_PAMPHLETNUM, REFDB_CHAPTERNUM, REFDB_CITEKEY};

#endif /* ifndef backend_included */
