/* risdata.h header file for risdata.c */
/* markus@mhoenicka.de 2003-10-06 */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* risdata defines an object to collect data for the t_refdb table */

#ifndef risdata_included
#define risdata_included 1

/* this structure holds the name components */
struct RISDATA {
  unsigned long long n_id;
  int n_pubyear;
  int n_secyear;
  char pyother_info[256];
  char secother_info[256];
  char citekey[256];
  char user1[256];
  char user2[256];
  char user3[256];
  char user4[256];
  char user5[256];
  char typeofwork[256];
  char area[256];
  char ostype[256];
  char degree[256];
  char runningtime[256];
  char classcodeintl[256];
  char classcodeus[256];
  char senderemail[256];
  char recipientemail[256];
  char mediatype[256];
  char numvolumes[256];
  char edition[256];
  char computer[256];
  char conferencelocation[256];
  char registrynum[256];
  char classification[256];
  char section[256];
  char pamphletnum[256];
  char chapternum[256];
  char issn[256];
  char issue[256];
  char publisher[256];
  char city[256];
  char volume[256];
  char endpage[256];
  char startpage[256];
  char type[256];
  char* abstract;
  char* title_series;
  char* booktitle;
  char* title;
  char* address;
};

struct RISDATA* new_risdata(void);
void free_risdata(struct RISDATA* ptr_risdata);
void reset_risdata(struct RISDATA* ptr_risdata);
int set_risdata_field(struct RISDATA* ptr_risdata, const char* fieldname, const char* fieldvalue, dbi_driver dbidrv);
int set_risdata_dateinfo(struct RISDATA* ptr_risdata, int date_type, int year, const char* otherinfo, dbi_driver driver);
int commit_risdata_fields(struct RISDATA* ptr_risdata, dbi_conn conn, int replace_ref);

#endif
