/* writenote.c: functions to write notes */
/* markus@mhoenicka.de 2003-10-12 */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <dbi/dbi.h>

#include "backend.h"
#include "backendn-scrn.h"
#include "backendn-notex.h"
#include "backendn-html.h"
#include "writenote.h"


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  render_note(): formats the result of a note query

  int render_note returns 0 if successful, >0 if failed

  struct renderinfo* ptr_rendinfo ptr to a structure with the info
                             how the reference should be rendered

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int render_note(struct renderinfo* ptr_rendinfo) {
  int retval;

  if (ptr_rendinfo->ref_format == XNOTE) {
    retval = render_note_xnote(ptr_rendinfo);
  }
  else if (ptr_rendinfo->ref_format == REFHTML
	   || ptr_rendinfo->ref_format == REFXHTML) {
    retval = render_note_html(ptr_rendinfo);
  }
  else {
    retval = render_note_scrn(ptr_rendinfo);
  }

  return retval;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  prepare_render_note(): writes a header for the output of a note query

  int prepare_render returns 0 if successful, >0 if failed

  struct renderinfo* ptr_rendinfo ptr to a structure with the info
                             how the reference should be rendered

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int prepare_render_note(struct renderinfo* ptr_rendinfo) {
  int retval;

  if (ptr_rendinfo->ref_format == XNOTE) {
    retval = prepare_render_note_xnote(ptr_rendinfo);
  }
  else if (ptr_rendinfo->ref_format == REFHTML
	   || ptr_rendinfo->ref_format == REFXHTML) {
    retval = prepare_render_note_html(ptr_rendinfo);
  }
  else {
    retval = prepare_render_note_scrn(ptr_rendinfo);
  }
  
  return retval;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  finish_render_note(): writes a footer for the output of a note query

  int finish_render_note returns 0 if successful, >0 if failed

  struct renderinfo* ptr_rendinfo ptr to a structure with the info
                             how the reference should be rendered

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int finish_render_note(struct renderinfo* ptr_rendinfo) {
  int retval;
  
  if (ptr_rendinfo->ref_format == XNOTE) {
    retval = finish_render_note_xnote(ptr_rendinfo);
  }
  else if (ptr_rendinfo->ref_format == REFHTML
	   || ptr_rendinfo->ref_format == REFXHTML) {
    retval = finish_render_note_html(ptr_rendinfo);
  }
  else {
    retval = finish_render_note_scrn(ptr_rendinfo);
  }
  
  return retval;
}
