/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  rtfhelper.h header file for rtfhelper.c
  markus@mhoenicka.de 2008-01-27

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
   
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
   
  You should have received a copy of the GNU General Public License
  along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#define CTRLWORDLEN 32 /* the maximum length of a RTF control word, as
			  per the M$ RTF spec */

#define NOPARAM LONG_MAX /* in theory this is the highest allowed
			    value of a numerical parameter of a
			    control word. We'll rely on the fact that
			    this value is orders of magnitude less
			    likely than 0 in order to denote that a
			    control word does not take a parameter
			    (this obviates the need to maintain and
			    check a list of control words that do use
			    a parameter */

char* print_rtf_control_word(const char* ctrlword, char** ptr_buffer, size_t* ptr_buflen, long param, int start_group);
char* print_rtf_control_symbol(const char symbol, char** ptr_buffer, size_t* ptr_buflen, int start_group);
char* print_rtf_start_group(char** ptr_buffer, size_t* ptr_buflen);
char* print_rtf_end_group(char** ptr_buffer, size_t* ptr_buflen);
char* print_rtf_header(char** ptr_buffer, size_t* ptr_buflen);
char* print_rtf_string(const char* src, char** ptr_buffer, size_t* ptr_buflen);
char* rtf_escape_string(const char* src);
char* print_rtf_bmstart(const char* label, char** ptr_buffer, size_t* ptr_buflen);
char* print_rtf_bmend(const char* label, char** ptr_buffer, size_t* ptr_buflen);
