
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Python Interface                                                      *
 *                                                                        *
 *  Copyright (c) 1999-2022, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,       *
 *  MA 02110-1301, USA.                                                   *
 *                                                                        *
 **************************************************************************/

#include "triangulation-bindings.h"
#include "boundarycomponent-bindings.h"
#include "component-bindings.h"
#include "isosig-bindings.h"
#include "simplex-bindings.h"

void addTriangulations8(pybind11::module_& m) {
    addTriangulation<8>(m, "Triangulation8");
    addComponent<8>(m, "Component8");
    addBoundaryComponent<8>(m, "BoundaryComponent8");
    addSimplex<8>(m, "Simplex8");

    addIsoSigClassic<8>(m, "IsoSigClassic8");
    addIsoSigEdgeDegrees<8>(m, "IsoSigEdgeDegrees8");
    addIsoSigRidgeDegrees<8>(m, "IsoSigRidgeDegrees8");
    addIsoSigPrintable<8>(m, "IsoSigPrintable8");

    m.attr("Face8_8") = m.attr("Simplex8");
}

