/***************************************************************************
    file	         : kb_pgadvanced.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>
#include	<qcheckbox.h>
#include	<qlineedit.h>
#include	<qspinbox.h>
#include	<qlabel.h>
#include	<qpushbutton.h>
#include	<qdialog.h>

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dom.h"



/*  KBPgGrantsDlg							*/
/*  -------------							*/
/*  The advanced options contain grant settings. These in turn contain	*/
/*  an option to show a dialog each time a table is created; this is	*/
/*  said dialog.							*/

class	KBPgGrantsDlg : public QDialog
{
	Q_OBJECT

	QCheckBox	m_cbGrantSelect		;
	QCheckBox	m_cbGrantInsert		;
	QCheckBox	m_cbGrantUpdate		;
	QCheckBox	m_cbGrantDelete		;
	QLabel		m_to			;
	QLineEdit	m_leGrantTo		;

	QPushButton	m_bOK			;
	QPushButton	m_bSkip			;
	QPushButton	m_bCancel		;

	bool		m_mapExpressions	;

protected slots :

	void		clickOK		()	;
	void		clickSkip	()	;
	void		clickCancel	()	;

public	:

	KBPgGrantsDlg	(bool, bool, bool, bool, const QString &, bool) ;

	QString		grantText	()	;
}	;


/*  ------------------------------------------------------------------  */

/*  KBPgAdvanced							*/
/*  ------------							*/
/*  This is the advanced options dialog for PostgreSQL. It has the	*/
/*  following server-specific pages					*/
/*									*/
/*	* General options						*/
/*	* Grant settings						*/

class	KBPgAdvanced : public KBDBAdvanced
{
	Q_OBJECT

	bool		m_primaryIsSerial	;
	bool		m_ignoreUser		;
	bool		m_showPgSQLObjects	;
	bool		m_logInternal		;
	bool		m_requireSSL		;
	bool		m_caseInsensitive	;
	bool		m_mapExpressions	;
	bool		m_useTimeouts		;
	int		m_stmtTimeout		;
	int		m_lockTimeout		;

	QCheckBox	*m_cbPrimaryIsSerial	;
	QCheckBox	*m_cbIgnoreUser		;
	QCheckBox	*m_cbShowPgSQLObjects	;
	QCheckBox	*m_cbLogInternal	;
	QCheckBox	*m_cbRequireSSL		;
	QCheckBox	*m_cbCaseInsensitive	;
	QCheckBox	*m_cbMapExpressions	;

	QCheckBox	*m_cbUseTimeouts	;
	QSpinBox	*m_spStmtTimeout	;
	QSpinBox	*m_spLockTimeout	;

	bool		m_grants		;
	bool		m_grantSelect		;
	bool		m_grantInsert		;
	bool		m_grantUpdate		;
	bool		m_grantDelete		;
	QString		m_grantTo		;
	bool		m_grantPopup		;

	QCheckBox	*m_cbGrants		;
	QCheckBox	*m_cbGrantSelect	;
	QCheckBox	*m_cbGrantInsert	;
	QCheckBox	*m_cbGrantUpdate	;
	QCheckBox	*m_cbGrantDelete	;
	QLineEdit	*m_leGrantTo		;
	QCheckBox	*m_cbGrantPopup		;


private slots :

	void		slotGrantsChanged	() ;
	void		slotUseTimeoutChanged	() ;

public	:

	KBPgAdvanced	()	;
virtual~KBPgAdvanced	()	;

	virtual	void		load		(const QDomElement &) ;
	virtual	void		save		(QDomElement	   &) ;
	virtual	void		setupDialog	(QTabWidget	   *) ;
	virtual	void		saveDialog	() ;
	virtual	KBDBAdvanced	*copy		() ;

	friend	class	KBPgSQL	;
}	;
