/***************************************************************************
    file	         : kb_rtbuild.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qregexp.h>

#include	"kb_classes.h"
#include	"tk_messagebox.h"
#include	"tk_filedialog.h"

#ifndef		_WIN32
#include	"kb_rtbuild.moc"
#else
#include	"kb_rtbuild.h"
#endif


/*  KBRTBuild								*/
/*  KBRTBuild	: Constructor for runtime packager dialog		*/
/*  dir		: const QString & : Database directory			*/
/*  name	: const QString & : Database name			*/
/*  (returns)	: KBRTBuild	  :					*/

KBRTBuild::KBRTBuild
	(	const QString	&dir,
		const QString	&name
	)
	:
	_KBDialog	(TR("Build DB Package"), true),
	m_dir		(dir),
	m_name		(name),
	m_type		(this),
	m_release	(this),
	m_maintainer	(this),
	m_target	(this),
	m_status	(this),
	m_bBrowse	(this),
	m_bOK		(this),
	m_bCancel	(this)
{
	QVBoxLayout	*layMain	= new QVBoxLayout (this) ;
	QGridLayout	*layData 	= new QGridLayout (layMain) ;

	QLabel		*lType	 	= new QLabel	  (this) ;
	QLabel		*lRelease 	= new QLabel	  (this) ;
	QLabel		*lMaintainer	= new QLabel	  (this) ;
	QLabel		*lDir		= new QLabel	  (this) ;

	lType		->setText (TR("Type"	  )) ;
	lRelease	->setText (TR("Release"   )) ;
	lMaintainer	->setText (TR("Maintainer")) ;
	lDir		->setText (TR("Directory" )) ;

	layData->addMultiCellWidget (lType,	    0, 0, 0, 0	) ;
	layData->addMultiCellWidget (&m_type,	    0, 0, 1, 2	) ;
	layData->addMultiCellWidget (lRelease,	    1, 1, 0, 0	) ;
	layData->addMultiCellWidget (&m_release,    1, 1, 1, 2	) ;
	layData->addMultiCellWidget (lMaintainer,   2, 2, 0, 0	) ;
	layData->addMultiCellWidget (&m_maintainer, 2, 2, 1, 2	) ;
	layData->addMultiCellWidget (lDir,	    3, 3, 0, 0	) ;
	layData->addMultiCellWidget (&m_target,	    3, 3, 1, 1	) ;
	layData->addMultiCellWidget (&m_bBrowse,    3, 3, 2, 2	) ;

	layMain->addWidget (&m_status)	;

	m_type   .insertItem (TR("RunTime")) ;
	m_type   .insertItem (TR("Full"   )) ;

	m_bBrowse.setText    (TR("Browse" )) ;
	m_bOK    .setText    (TR("Package")) ;
	m_bCancel.setText    (TR("Cancel" )) ;

	connect	(&m_bBrowse, SIGNAL(clicked()), SLOT(slotClickBrowse())) ;
	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(slotClickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(slotClickCancel())) ;

	QHBoxLayout	*layButt	= new QHBoxLayout (layMain) ;
	layButt->addStretch () ;
	layButt->addWidget  (&m_bOK    ) ;
	layButt->addWidget  (&m_bCancel) ;

	m_process	= 0 ;

#if	__KB_EMBEDDED
	m_showMaxed = true  ;
#else
	m_release.setMinimumWidth  (240) ;
#endif
}

/*  KBRTBuild								*/
/*  ~KBRTBuild	: Destructor for runtime packager dialog		*/
/*  (returns)	:		:					*/

KBRTBuild::~KBRTBuild ()
{
	if (m_process != 0) delete m_process ;
}

/*  KBRTBuild								*/
/*  slotClickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	KBRTBuild::slotClickOK ()
{
	TKMessageBox::information
	(	0,
		TR("Building database package: this make take a few moments"),
		TR("Database packaging")
	)	;

	m_process = new QProcess(this) ;

	m_process->addArgument	("rtbuild.sh") ;
	m_process->addArgument	(m_type.currentItem() == 0 ? "rt" : "full") ;
	m_process->addArgument	(m_dir ) ;
	m_process->addArgument	(m_name) ;
	m_process->addArgument	(m_release   .text()) ;
	m_process->addArgument	(m_maintainer.text()) ;
	m_process->addArgument	(m_target    .text()) ;

	connect	(m_process, SIGNAL(readyReadStdout()), SLOT(slotReadStdout())) ;
	connect	(m_process, SIGNAL(readyReadStderr()), SLOT(slotReadStderr())) ;
	connect	(m_process, SIGNAL(processExited  ()), SLOT(slotProcExited())) ;

	if (!m_process->start ())
	{
		TKMessageBox::sorry
		(	0,
			TR("Failed to start packager"),
			TR("Database packaging")
		)	;
		return	;
	}

	m_statusText	= "" ;

	/* The package button is disabled now that the packaging is	*/
	/* under way.							*/
	m_bOK.setEnabled  (false) ;
}

/*  KBRTBuild								*/
/*  slotClickBrowse							*/
/*		: User clicks browse					*/
/*  (returns)	: void		:					*/

void	KBRTBuild::slotClickBrowse ()
{
	QString	dir	= KBFileDialog::getExistingDirectory
			  (	m_target.text(),
				TR("Destination directory")
			  )	;

	if (!dir.isEmpty()) m_target.setText (dir) ;
}

/*  KBRTBuild								*/
/*  slotClickCancel							*/
/*		: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	KBRTBuild::slotClickCancel ()
{
	done	(0) ;
}

/*  KBRTBuild								*/
/*  addText	: Add text to progress output				*/
/*  text	: const QString & : Text				*/
/*  (returns)	: void		  :					*/

void	KBRTBuild::addText
	(	const QString	&text
	)
{
	m_statusText += QString(text).replace(QRegExp(" "), "&nbsp;") ;

	QStringList s = QStringList::split ("\n", m_statusText) ;
	QString	    v = s.join ("<br/>") ;
	m_status.setText ("<qt>" + v + "<//qt>") ;
}

/*  KBRTBuild								*/
/*  slotReadStdout							*/
/*		: Data available from process stdout			*/
/*  (returns)	: void		  :					*/

void	KBRTBuild::slotReadStdout ()
{
	addText (m_process->readStdout()) ;
}

/*  KBRTBuild								*/
/*  slotReadStdout							*/
/*		: Data available from process stderr			*/
/*  (returns)	: void		  :					*/

void	KBRTBuild::slotReadStderr ()
{
	addText (m_process->readStderr()) ;
}

/*  KBRTBuild								*/
/*  slotProcExited							*/
/*		: Process has exited					*/
/*  (returns)	: void		  :					*/

void	KBRTBuild::slotProcExited ()
{
	/* If the packager exited abnormally then warn the user and	*/
	/* re-enable the package button ....				*/
	if (!m_process->normalExit())
	{
		TKMessageBox::sorry
		(	0,
			TR("Packager terminated abnormally"),
			TR("Database packaging")
		)	;
		m_bOK.setEnabled  (true) ;
		return	;
	}

	/* ... and similarly for if it exited with a non-zero exit	*/
	/* code.							*/
	if (m_process->exitStatus () != 0)
	{
		TKMessageBox::sorry
		(	0,
			TR("Packager failed"),
			TR("Database packaging")
		)	;
		m_bOK.setEnabled  (true) ;
		return	;
	}

	/* Completed successfully. Notify the user and then convert the	*/
	/* cancel button to a finish button.				*/
	TKMessageBox::information
	(	0,
		TR("Packaging completed successfully"),
		TR("Database packaging")
	)	;

	m_bCancel.setText (TR("Finish")) ;
}
