/***************************************************************************
    file	         : kb_wizconnect.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_dbinfo.h"
#include	"kb_serverinfo.h"
#include	"kb_location.h"
#include	"kb_wizconnect.h"

#include	"kb_locator.h"


KBWizardConnect::KBWizardConnect
	(	KBDBInfo	*dbInfo,
		const QString	&server
	)
	:
	KBWizard (dbInfo, server)
{
}

int	KBWizardConnect::exec ()
{
	QString	wizXML = locateFile ("appdata", "wizards/wizConnect.wiz") ;
	if (wizXML.isNull())
	{
		KBError::EError
		(	QString(TR("Cannot locate wizard specification")),
			"wizConnect.wiz",
			__ERRLOCN
		)	;
		return	0 ;
	}

	if (!init (wizXML))
	{	lastError().DISPLAY() ;
		return	0 ;
	}

	return	KBWizard::exec () ;
}

QString	KBWizardConnect::create ()
{
	QString	dbDir	= ctrlValue	("directory", "dbDir"   ) ;
	QString	dbName	= ctrlValue	("directory", "dbName"  ) ;
	QString	dbType	= ctrlValue	("type",      "dbType"  ) ;
	QString	host	= ctrlValue	("host",      "host"    ) ;
	QString	port	= ctrlValue	("host",      "port"    ) ;
	QString	database= ctrlValue	("database",  "dbList"  ) ;
	QString	user	= ctrlValue	("user",      "username") ;
	QString	pwd	= ctrlValue	("user",      "password") ;
	QString	xbDir	= ctrlValue	("xbase",     "xbDir"   ) ;
	bool	where	= ctrlAttribute ("fileordb",  "asfile", "index").toBool() ;	

	fprintf
	(	stderr,
		"KBWizardConnect::create:\n"
		"	dbDir	: %s\n"
		"	dbName	: %s\n"
		"	dbType	: %s\n"
		"	host	: %s\n"
		"	port	: %s\n"
		"	database: %s\n"
		"	user	: %s\n"
		"	pwd	: %s\n"
		"	where	: %d\n",
		(cchar *)dbDir,
		(cchar *)dbName,
		(cchar *)dbType,
		(cchar *)host,
		(cchar *)port,
		(cchar *)database,
		(cchar *)user,
		(cchar *)pwd,
		where
	)	;

	QString		dbPath	= dbDir + "/" + dbName + ".rkl" ;

	KBDBInfo 	dbInfo
			(	dbPath
			)	;

	KBServerInfo	*svInfo	= new KBServerInfo
			(	&dbInfo,
				where == 0 ? dbName : QString(KBLocation::m_pFile),
				dbType,
				host,
				dbType == "xbase" ? xbDir : database,
				user,
				pwd
			)	;

	if (!port.isEmpty()) svInfo->setPort (port) ;


	dbInfo.insert	(svInfo);

	if (!dbInfo.save (dbPath))
		return	QString::null	;

	return	dbPath	;
}

		
