/***************************************************************************
    file	         : kb_notifier.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_NOTIFIER_H
#define	_KB_NOTIFIER_H

#include	"libcommon_exports.h"
#include	"kb_location.h"

#include	<qobject.h>

/*  KBNotifier								*/
/*  ----------								*/
/*  There are several places where changes at one place in KBase need	*/
/*  to be communicated somewhere else, for instance changes to the	*/
/*  details for a server need to be notified to the table list. Rather	*/
/*  than ensure that object pointers are passed around everywhere,	*/
/*  such information is passed through a central notifier object.	*/

class	LIBCOMMON_API	KBNotifier : public QObject
{
	Q_OBJECT

signals :

	void	sServerChanged (const KBLocation &) ;
	void	sTablesChanged (const KBLocation &) ;
	void	sObjectChanged (const KBLocation &) ;

public	:

	KBNotifier () ;

	/* The following methods are called by various components to	*/
	/* notify changes. Each method simply emits the corresponding	*/
	/* signal; any component which needs to receive a notification	*/
	/* can connect to the signal.					*/
	void	nServerChanged (const KBLocation &) ;
	void	nTablesChanged (const KBLocation &) ;
	void	nObjectChanged (const KBLocation &) ;

	static	KBNotifier *self() ;
}	;


#endif	// _KB_NOTIFIER_H
