/***************************************************************************
    file	         : elc.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#define		MAINDEF
#include 	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<time.h>
#include	<string.h>
#include	<setjmp.h>
#include	<errno.h>
#include	<std.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"

#define	USAGE	\
	errorE ("usage: elc [-p] [-ooutput] [-Idir] [-Dsym] [-Usym] [-Ssrce] [srce]\n")

GFUNC	void	el_define   (const char *) ;
GFUNC	void	el_undefine (const char *) ;
GFUNC	void	el_addhdr   (const char *) ;
GFUNC	void	_el_print   () ;


/*G main	: Standard entry routine				*/
/*  argc	: int		: Number of arguments			*/
/*  argv	: char *[]	: Vector of arguments			*/
/*  (returns)	: int		: Exit code				*/

GFUNC	int	main
	(	int	argc,
		char	*argv[]
	)
{
	char	*srce	= NULL	;	/* For program source file name	*/
	char	*dest	= NULL	;	/* For output destination name	*/
	char	*errf	= NULL	;	/* For error output name	*/
	char	*sstr	= NULL	;	/* Source as string		*/

	int	print	= 0	;	/* Flag to print parsed program	*/
	FILE	*ifd		;	/* Input file descriptor	*/

	argc -= 1 ;
	argv += 1 ;

	while ((argc > 0) && (argv[0][0] == '-'))
	{
		char	*opts	= *argv++ ;

		argc	-= 1	;
		opts	+= 1	;

		while (*opts) switch ((int)*opts++)
		{
			case 'p' :
				print	= 1 ;
				break	;

			case 'e' :
				errf	= opts	;
				opts	= ""	;
				break	;

			case 'o' :
				dest	= opts	;
				opts	= ""	;
				break	;

			case 'D' :
				el_define (opts) ;
				opts	= ""	 ;
				break	;

			case 'U' :
				el_undefine (opts) ;
				opts	= ""	   ;
				break	;

			case 'I' :
				el_addhdr (opts) ;
				opts	= ""	 ;
				break	;

			case 'S' :
				sstr	= opts	 ;
				opts	= ""	 ;
				break	;

			default  :
				USAGE ;
		}
	}

	if	(argc == 1) srce = *argv ;
	else if (argc != 0) USAGE ;

	if ((srce != NULL) && (sstr != NULL))
		USAGE	;

	if (errf != NULL)
		freopen	(errf, "w", stderr) ;

	if (srce != NULL)
	{
		/* Source file name given. Check if it ends with the	*/
		/* postfix ".el" and, if not, then add it.		*/
		if (strcmp (&srce[strlen(srce) - 3], ".el") != 0)
		{	char *tmp = (char *)malloc (strlen(srce) + 4) ;
			sprintf	(tmp, "%s.el", srce) ;
			srce = tmp ;
		}

		/* If no destination is specified then use the source	*/
		/* name with ".el" replaced with ".elc". If one is	*/
		/* given then append ".elc" if it does not have that	*/
		/* postfix already.					*/
		if (dest == NULL)
		{	dest = (char *)malloc (strlen(srce) + 2) ;
			strcpy (dest, srce) ;
			strcpy (&dest[strlen(srce) - 3], ".elc") ;
		}
		else if (strcmp (&dest[strlen(dest) - 4], ".elc") != 0)
		{	char *tmp = (char *)malloc (strlen(dest) + 5) ;
			sprintf (tmp, "%s.elc", dest) ;
			dest = tmp ;
		}
	}
	else if (sstr != 0)
	{
		if (dest == NULL) dest = "text.elc" ;
	}
	else
	{	/* Program input is standard input so if an output	*/
		/* name is not given then make one up. The default	*/
		/* module name is then based on the destination name.	*/
		if (dest == NULL) dest = "stdin.elc" ;
	}


	/* If the input is other than the standard input attempt to	*/
	/* open it, and complain if this fails.				*/
	if (srce != NULL) 
	{	if ((ifd = fopen (srce, "r")) == NULL)
		{	fprintf	(stderr,
				 "elc: unable to open \"%s\": %s\n",
				 srce, strerror(errno)) ;
			exit	(1) ;
		}
	}
	else	ifd	= stdin ;

	if (el_compile (srce, dest, ifd, sstr, stderr) == 0) exit (1) ;
	if (ifd != stdin) fclose (ifd) ;

#if	1
	if (srce != NULL) 
	{	if ((ifd = fopen (srce, "r")) == NULL)
		{	fprintf	(stderr,
				 "elc: unable to open \"%s\": %s\n",
				 srce, strerror(errno)) ;
			exit	(1) ;
		}
	}
	else	ifd	= stdin ;

	if (el_compile (srce, dest, ifd, sstr, stderr) == 0) exit (1) ;
	if (ifd != stdin) fclose (ifd) ;
#endif

	/* Print the parsed program if requested.			*/
	if (print) _el_print () ;

	return	0 ;
}
