/***************************************************************************
    file	         : kb_button.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_BUTTON_H
#define	_KB_BUTTON_H

#include 	"libkbase_exports.h"

#include	"kb_object.h"
#include	"kb_qtbutton.h"

/*  KBButton								*/
/*  ------------							*/
/*  This class is used for XML parse tree elements corresponding to	*/
/*  simple push-buttons.						*/

class LIBKBASE_API	KBButton : public KBObject
{
	Q_OBJECT

	KBAttrStr	fgcolor	    ;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	    ;	/* Background colour		*/
	KBAttrStr	font	    ;	/* Font				*/
	KBAttrStr	text	    ;
	KBAttrUInt	tabOrd      ;	/* Tab ordering			*/
	KBEvent		onClick	    ;
	KBControl	*button	    ;

	bool		disable	    ;
	KBScriptCode	*code	    ;

protected :

#if	! __KB_RUNTIME
	virtual	bool	propertyDlg  (cchar *) ;
#endif

private slots :

	void	clicked ()	;

public	:

	KBButton	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBButton	(KBNode  *, KBButton *) ;
virtual~KBButton	() ;

	virtual	void	updateProps	() 	;
	virtual	void	buildCtrls	(uint, int, int ) ;
	virtual	KBNode	*replicate	(KBNode   *) ;
	virtual	void	showAs		(KB::ShowAs) ;

	virtual	bool	keyStroke	(QKeyEvent *) ;
	virtual	void	setTabOrder	(int )	;
	virtual	int	getTabOrder	()     	;

	inline	void	setText
		(	const QString	&text
		)
	{
		button->setValue (KBValue (text, &_kbString)) ;
	}
}	;

#endif	// _KB_BUTTON_H
