/***************************************************************************
    file	         : kb_formdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FORMDLG_H
#define	_KB_FORMDLG_H

#if	! __KB_RUNTIME

#include	"libkbase_exports.h"
#ifdef		_WIN32
#include 	"libtkkde_exports.h"
#endif

#include	"kb_propdlg.h"
#include	"kb_paramdlg.h"
#include	"kb_script.h"
#include	"kb_import.h"



/*  KBFormPropDlg							*/
/*  -------------							*/
/*  Properties dialog for form top-level object, that is, those parts	*/
/*  of KBForm which are specific to KBForm and not contained in the	*/
/*  KBBlock base class.							*/

class	LIBKBASE_API	KBFormPropDlg : public KBPropDlg
{
	Q_OBJECT

	KBScriptDlg	scriptDlg ;
	KBImportDlg	importDlg ;
	KBParamDlg	paramDlg  ;

	KBForm		*root	  ;
	QString		ibtype	  ;

protected :

	virtual	bool	showProperty (KBAttrItem *) ;
	virtual	bool	saveProperty (KBAttrItem *) ;
	virtual	bool	hideProperty (KBAttr *) ;
	virtual	void	preExec	     () ;

protected slots :

	virtual	void	clickOK	     () ;

public	:

	KBFormPropDlg (KBForm *, cchar *, QList<KBAttr  > &,
					  QList<KBModule> &,
					  QList<KBModule> &,
					  QList<KBParam > &,
					  cchar	* = 0) ;
       ~KBFormPropDlg () ;
}	;

#endif
#endif	// _KB_FORMDLG_H
