/***************************************************************************
    file	         : kb_mask.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qstring.h>

#include	"kb_classes.h"

#ifndef 	_WIN32
#include	"kb_mask.moc"
#else
#include	"kb_mask.h"
#endif

static	QChar MCHAR_ANY  (_MCHAR_ANY  );
static	QChar MCHAR_DIGIT(_MCHAR_DIGIT);
static	QChar MCHAR_ALPHA(_MCHAR_ALPHA);
static	QChar MCHAR_UPPER(_MCHAR_UPPER);


/*  KBMaskedInput							*/
/*  KBMaskedInput: Constructor for masked input class			*/
/*  lineEdit	 : TKLineEdit *	 : Line edit being masked		*/
/*  (returns)	 : KBMaskedInput :					*/

KBMaskedInput::KBMaskedInput
	(	TKLineEdit	*lineEdit
	)
	:
	m_lineEdit (lineEdit)
{
	connect
	(	m_lineEdit,
		SIGNAL(textChanged(const QString &)),
		SLOT  (textChanged(const QString &))
	)	;
	m_enabled = true ;
}

/*  KBMaskedInput							*/
/*  setEnabled	: Enable or disable masking				*/
/*  enabled	: bool		: Enabled (or disabled)			*/
/*  (returns)	: void		   :					*/

void	KBMaskedInput::setEnabled
	(	bool	enabled
	)
{
	m_enabled = enabled ;
}

/*  KBMaskedInput							*/
/*  setInputMask: Set the input mask					*/
/*  mask	: const QString & : New mask				*/
/*  (returns)	: void		  :					*/

void	KBMaskedInput::setInputMask
	(	const QString	&mask
	)
{
	m_mask	= mask	;
}

/*  KBMaskedInput							*/
/*  textChanged	 : Mask text after change				*/
/*  text	 : const QString & : Current text in line edit		*/
/*  (returns)	 : void		   :					*/

void	KBMaskedInput::textChanged
	(	const QString	&text
	)
{
	/* If not enabled or enabled but the mask is empty then just	*/
	/* return the text as-is.					*/
	if (!m_enabled || m_mask.isEmpty())
	{	m_text	= text	;
		emit textChangedTo (m_text) ;
		return	;
	}

	/* We work by taking the current text and processing it against	*/
	/* the mask to get a valid, possibly shorted, string.		*/
	uint	_coff	= m_lineEdit->cursorPosition () ;
	uint	toff	= 0 ;
	uint	moff	= 0 ;
	uint	coff	= 0 ;

	/* If the line edit text matches the text we have here		*/
	/* (typically, we have just changed it) then it can be left	*/
	/* alone.							*/
	if (text == m_text)
	{	emit textChangedTo (m_text) ;
		return	;
	}

	/* Clear our version of the text and then scan through the	*/
	/* current text and mask to validate the current text ...	*/
	m_text	= ""	;

	while ((toff < text.length()) && (moff < m_mask.length()))
	{

		/* If the next mask character allows any input then	*/
		/* we can append the next input character as-is and	*/
		/* advance both the mask and input pointers.		*/
		if	(m_mask.at(moff) == MCHAR_ANY)
		{	m_text.append (text.at(toff)) ;
			moff	+= 1 ;
			toff	+= 1 ;
		}
		/* If the mask allows just digits then allow the next	*/
		/* text character if it is a digit (and advance the	*/
		/* mask), and advance the text offset in either case.	*/
		else if (m_mask.at(moff) == MCHAR_DIGIT)
		{
			if (text.at(toff).isDigit())
			{	m_text.append (text.at(toff)) ;
				moff	+= 1 ;
			}

			toff	+= 1 ;
		}
		/* Similarly for alphabetic characters ...		*/
		else if (m_mask.at(moff) == MCHAR_ALPHA)
		{
			if (text.at(toff).isLetter())
			{	m_text.append (text.at(toff)) ;
				moff	+= 1 ;
			}

			toff	+= 1 ;
		}
		/* The next case is similar to the above, except that	*/
		/* lower-case characters are converted to upper-case.	*/
		else if (m_mask.at(moff) == MCHAR_UPPER)
		{
			if (text.at(toff).isLetter())
			{	m_text.append (text.at(toff).upper()) ;
				moff	+= 1 ;
			}

			toff	+= 1 ;
		}
		/* Last case to check is that if the mask character	*/
		/* matches the text, in which case we have the required	*/
		/* character, and can just append it.			*/
		else if (m_mask.at(moff) == text.at(toff))
		{	m_text.append (text.at(toff)) ;
			moff	+= 1 ;
			toff	+= 1 ;
		}
		/* If we get here then we must be missing an explicit	*/
		/* mask character, in which case append it (and move	*/
		/* the mask offset on) but leave the text offset.	*/
		else
		{
			m_text.append (m_mask.at(moff)) ;
			moff	+= 1 ;
		}

		if (toff <= _coff) coff = m_text.length() ;
	}

	/* If control drops out and there is superfluous text, then it	*/
	/* is ignored, however the next fixed character, if any, is	*/
	/* appended.							*/
	// if ((moff < m_mask.length()) && (coff >= m_text.length()))
	// {
	// 	QChar	nm	= m_mask.at(moff) ;
	// 
	//	if ( (nm != MCHAR_ANY  ) &&
	//	     (nm != MCHAR_DIGIT) &&
	//	     (nm != MCHAR_ALPHA) &&
	//	     (nm != MCHAR_UPPER) )
	//	{
	//		m_text.append (nm) ;
	//		coff += 1	   ;
	//	}
	// }
	/* Commented out on account of deletion problems ....		*/

	m_lineEdit->setText	      (m_text)	;
	m_lineEdit->setCursorPosition (coff)	;

	emit textChangedTo (m_text) ;
}
