/***************************************************************************
    file	         : kb_qrytable.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_queryset.h"
#include	"kb_qrylevel.h"

#ifndef		_WIN32
#include	"kb_qrytable.moc"
#else
#include	"kb_qrytable.h"
#endif

#include	"kb_item.h"
#include	"kb_table.h"
#include	"kb_nodereg.h"


/*  KBQryTable								*/
/*  KBQryTable	: Constructor for form query node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*		: bool *	:					*/
/*  (returns)	: KBQryTable	:					*/

KBQryTable::KBQryTable
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBQryData	(parent, aList,		"KBQryTable"),
	m_server	(this,	 "server",	aList, KF_REQD),
	m_table		(this,   "table",	aList, KF_REQD),
	m_primary	(this,   "primary",	aList),
	m_ptype		(this,   "ptype",	aList),
	m_pexpr		(this,   "pexpr",	aList),
	m_where		(this,   "where",	aList),
	m_order		(this,   "order",	aList),
	m_distinct	(this,	 "distinct",	aList),
	m_limit		(this,	 "limit",	aList)
{
	m_tabPtr	= 0 ;
}

/*  KBQryTable								*/
/*  KBQryTable	: Constructor for form query node			*/
/*  parent	: KBForm *	: Parent node				*/
/*  (returns)	: KBQryTable	:					*/

KBQryTable::KBQryTable
	(	KBNode	*parent
	)
	:
	KBQryData	(parent, "KBQryTable"  ),
	m_server	(this,	 "server",	"", KF_REQD),
	m_table		(this,   "table",	"", KF_REQD),
	m_primary	(this,   "primary",	""),
	m_ptype		(this,   "ptype",	KBTable::Auto),
	m_pexpr		(this,   "pexpr",	""),
	m_where		(this,   "where",	""),
	m_order		(this,   "order",	""),
	m_distinct	(this,	 "distinct",	false),
	m_limit		(this,	 "limit",	(uint)0)
{
	m_tabPtr	= 0 ;
}

/*  KBQryTable								*/
/*  KBQryTable	: Constructor for form query node			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _query	: KBQryTable *	: Extant form query			*/
/*  (returns)	: KBQryTable	:					*/

KBQryTable::KBQryTable
	(	KBNode		*_parent,
		KBQryTable	*_query
	)
	:
	KBQryData	(_parent, _query),
	m_server	(this,    "server",     _query, KF_REQD),
	m_table		(this,    "table",      _query, KF_REQD),
	m_primary	(this,    "primary",    _query),
	m_ptype		(this,    "ptype",      _query),
	m_pexpr		(this,    "pexpr",      _query),
	m_where		(this,    "where",      _query),
	m_order		(this,    "order",      _query),
	m_distinct	(this,	  "distinct",	_query),
	m_limit		(this,	 "limit",	_query)
{
	m_tabPtr	= 0 ;
}

/*  KBQryTable								*/
/*  ~KBQryTable	: Destructor for form query node			*/
/*  (returns)	:		:					*/

KBQryTable::~KBQryTable ()
{
	DELOBJ	(m_tabPtr) ;
}

/*  KBQryTable								*/
/*  replicate	: Replicate this table query				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New table query node			*/

KBNode	*KBQryTable::replicate
	(	KBNode	*_parent
	)
{
	return	new KBQryTable (_parent, this) ;
}

/*  KBQryTable								*/
/*  loadQuery	: Load query 						*/
/*  (returns)	: bool		: Success				*/

bool	KBQryTable::loadQuery ()
{
	tabList   .clear () ;
	qryLevels.clear  () ;
	DELOBJ	 (m_tabPtr) ;

	m_tabPtr = new KBTable
		   (	this, m_table  .getValue(), 
			      "",
			      m_primary.getValue(),
			      m_ptype  .getValue(),
			      m_pexpr  .getValue(),
			      "",
			      "",
			      m_where  .getValue(),
			      m_order  .getValue()
		   ) ;

	KBQryLevel *qlvl = new KBQryLevel (getParent(), 0, dbLink, 0, m_tabPtr) ;
	qlvl->setDistinct (m_distinct.getBoolValue()) ;
	qlvl->setLimit	  (m_limit   .getIntValue ()) ;

	qryLevels.append (qlvl) ;

	svrName	= m_server.getValue () ;
	return	linkServer (svrName) ;
}

/*  KBQryTable								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBQryTable::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
	{	qryLevels.clear () ;
		DELOBJ  (m_tabPtr) ;
	}
#endif
	KBNode::showAs (mode) ;
}

/*  KBQryTable								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBQryTable::printNode
	(	QString		&text,
		int		indent
	)
{
	QString		nodeText ;

	/* We override this method since we don't want to print a child	*/
	/* KBTable node, which does exist in the document.		*/
	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;

	for (uint idx = 0 ; idx < attribs.count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;

	if (!nodeText.isEmpty())
	{
		text	+= ">\n" ;
		text	+= nodeText ;
		text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
	}
	else	text	+= "/>\n" ;
}

/*  KBQryTable								*/
/*  getComment	: Get brief descriptive comment				*/
/*  qryLvl	: uint		: Query level				*/
/*  (returns)	: QString	: Comment				*/

QString	KBQryTable::getComment
	(	uint
	)
{
	return	QString("Table: %1").arg(m_table.getValue()) ;
}

#if	! __KB_RUNTIME
/*  KBQryTable								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBQryTable::propertyDlg ()
{
	extern	bool	queryTablePropDlg (KBQryTable *, cchar *, QList<KBAttr> &) ;
	
	if (!queryTablePropDlg (this, TR("Query"), attribs))
		return false ;

	qryLevels.clear  () ;
	dropServer 	 () ;

	return true   ;
}
#endif


NEWNODE(QryTable, (cchar *)0, KF_FORM|KF_REPORT)
