/***************************************************************************
    file	         : kb_slotdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>
#include	<qlistbox.h>


#ifndef		_WIN32
#include	"kb_slotdlg.moc"
#else
#include	"kb_slotdlg.h"
#endif

#include	"kb_object.h"
#include	"kb_docroot.h"
#include	"kb_script.h"
#include	"kb_options.h"
#include	"kb_font.h"
#include	"kb_noobjdlg.h"

#include	"tk_messagebox.h"
#include	"tk_icons.h"



/*  KBSlotLinkItem							*/
/*  --------------							*/
/*  This class is used for entries in the slot dialog's link list. It	*/
/*  contains copies of the link information.				*/

class	KBSlotLinkItem : public QListBoxText
{
	QString		m_name		;
	QString		m_target	;
	QString		m_event		;
	bool		m_enabled	;

public	:

	KBSlotLinkItem
	(	QListBox	*,
		const QString	&,
		const QString	&,
		const QString	&,
		bool
	)	;

	KBSlotLinkItem
	(	QListBox	*,
		KBSlotLink	&link
	)	;

	friend	class	KBSlotDlg	;
}	;


/*  KBSlotItem								*/
/*  ----------								*/
/*  This class is used for entries in the slot list dialogs list of	*/
/*  slots, and embeds a pointer at the slot.				*/

class	KBSlotItem : public QListBoxText
{
	KBSlot		*m_slot	;

public	:

	KBSlotItem	(QListBox *, KBSlot *) ;

	friend	class	KBSlotListDlg	;
}	;



/*  ------------------------------------------------------------------  */

/*  KBSlotLinkItem							*/
/*  KBSlotLinkItem							*/
/*		: Constructor for slot dialog list element		*/
/*  listBox	: QListBox *	  : Parent list box			*/
/*  name	: const QString & : Link name				*/
/*  target	: const QString & : Target object name			*/
/*  event	: const QString & : Event name				*/
/*  enabled	: bool		  : Link is enabled			*/
/*  (returns)	: KBSlotLinkItem  :					*/

KBSlotLinkItem::KBSlotLinkItem
	(	QListBox	*listBox,
		const QString	&name,
		const QString	&target,
		const QString	&event,
		bool		enabled
	)
	:
	QListBoxText	(listBox, name),
	m_name		(name   ),
	m_target	(target ),
	m_event		(event  ),
	m_enabled	(enabled)
{
}

/*  KBSlotLinkItem							*/
/*  KBSlotLinkItem							*/
/*		: Constructor for slot dialog list element		*/
/*  listBox	: QListBox *	  : Parent list box			*/
/*  link	: KBSlotLink &	  : Extant slot link			*/
/*  (returns)	: KBSlotLinkItem  :					*/

KBSlotLinkItem::KBSlotLinkItem
	(	QListBox	*listBox,
		KBSlotLink	&link
	)
	:
	QListBoxText	(listBox, link.name()),
	m_name		(link.name   ()),
	m_target	(link.target ()),
	m_event		(link.event  ()),
	m_enabled	(link.enabled())
{
}


/*  ------------------------------------------------------------------  */

/*  KBSlotItem								*/
/*  KBSlotItem	: Constructor for list-of-slots dialog list entry	*/
/*  listBox	: QListBox *	  : Parent list box			*/
/*  slot	: KBSlot *	  : Slot				*/
/*  (returns)	: KBSlotItem	  :					*/

KBSlotItem::KBSlotItem
	(	QListBox	*listBox,
		KBSlot		*slot
	)
	:
	QListBoxText	(listBox, slot->name())
{
	m_slot	= slot	;
}


/*  ------------------------------------------------------------------  */

/*  KBSlotDlg								*/
/*  KBSlotDlg	: Constructor for slot dialog				*/
/*  slot	: KBSlot *	: Slot to be edited			*/
/*  parent	: KBObject *	: Parent object				*/
/*  (returns)	: KBSlotDlg	:					*/

KBSlotDlg::KBSlotDlg
	(	KBSlot		*slot,
		KBObject	*parent
	)
	:
	_KBDialog	(TR("Slots"), true),
	m_slot		(slot),
	m_parent	(parent),
	m_lSlotName	(this),
	m_lLinkPicker	(this),
	m_lLinkName	(this),
	m_lLinkTarget	(this),
	m_lLinkEvent	(this),
	m_lLinkEnabled	(this),
	m_eSlotName	(this),
	m_cLinkPicker	(this),
	m_eLinkName	(this),
	m_eLinkTarget	(this),
	m_eLinkEvent	(this),
	m_cLinkEnabled	(this),
	m_bFind		(this),
	m_bAddLink	(this),
	m_bEditLink	(this),
	m_bDismissLink	(this),
	m_bSaveLink	(this),
	m_bDropLink	(this),
	m_tkEditor	(new TKTextDocument (getTextManager(KBOptions::getScriptFont())), this),
	m_mapper	(&m_tkEditor),
	m_bVerify	(this),
	m_bOK		(this),
	m_bCancel	(this)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this)    ;

	QGridLayout	*layInfo = new QGridLayout (layMain) ;

	layInfo->addWidget (&m_lSlotName,    0, 0) ;
	layInfo->addWidget (&m_lLinkPicker,  1, 0) ;
	layInfo->addWidget (&m_lLinkName,    2, 0) ;
	layInfo->addWidget (&m_lLinkTarget,  3, 0) ;
	layInfo->addWidget (&m_lLinkEvent,   4, 0) ;
	layInfo->addWidget (&m_lLinkEnabled, 5, 0) ;
	layInfo->addWidget (&m_eSlotName,    0, 1) ;
	layInfo->addWidget (&m_cLinkPicker,  1, 1) ;
	layInfo->addWidget (&m_eLinkName,    2, 1) ;
	layInfo->addWidget (&m_eLinkTarget,  3, 1) ;
	layInfo->addWidget (&m_eLinkEvent,   4, 1) ;
	layInfo->addWidget (&m_bFind,        4, 2) ;
	layInfo->addWidget (&m_cLinkEnabled, 5, 1) ;

	QHBoxLayout	*layActs = new QHBoxLayout (layMain)   ;

	layActs->addStretch() ;
	layActs->addWidget (&m_bAddLink    ) ;
	layActs->addWidget (&m_bEditLink   ) ;
	layActs->addWidget (&m_bDismissLink) ;
	layActs->addWidget (&m_bSaveLink   ) ;
	layActs->addWidget (&m_bDropLink   ) ;

	layMain->addWidget (&m_tkEditor) ;

	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;
	layButt->addWidget (&m_bVerify  ) ;
	layButt->addStretch()		  ;
	layButt->addWidget (&m_bOK      ) ;
	layButt->addWidget (&m_bCancel  ) ;

	m_bFind.setPixmap (getSmallIcon("browse")) ;

	m_bAddLink    .setText (TR("Add"    )) ;
	m_bEditLink   .setText (TR("Edit"   )) ;
	m_bSaveLink   .setText (TR("Save"   )) ;
	m_bDismissLink.setText (TR("Dismiss")) ;
	m_bDropLink   .setText (TR("Drop"   )) ;
	m_bVerify     .setText (TR("Verify" )) ;
	m_bOK	      .setText (TR("OK"     )) ;
	m_bCancel     .setText (TR("Cancel" )) ;

	m_lSlotName   .setText (TR("Slot name")) ;
	m_lLinkPicker .setText (TR("Link"     )) ;
	m_lLinkName   .setText (TR("Link name")) ;
	m_lLinkTarget .setText (TR("Object"   )) ;
	m_lLinkEvent  .setText (TR("Event"    )) ;
	m_lLinkEnabled.setText (TR("Enabled"  )) ;

	connect	(&m_bFind,	 SIGNAL(clicked()), SLOT(clickFind   ())) ;
	connect	(&m_bAddLink,	 SIGNAL(clicked()), SLOT(clickAdd    ())) ;
	connect	(&m_bEditLink,	 SIGNAL(clicked()), SLOT(clickEdit   ())) ;
	connect	(&m_bSaveLink,	 SIGNAL(clicked()), SLOT(clickSave   ())) ;
	connect	(&m_bDismissLink,SIGNAL(clicked()), SLOT(clickDismiss())) ;
	connect	(&m_bDropLink,	 SIGNAL(clicked()), SLOT(clickDrop   ())) ;
	connect	(&m_bVerify, 	 SIGNAL(clicked()), SLOT(clickVerify ())) ;
	connect	(&m_bOK, 	 SIGNAL(clicked()), SLOT(clickOK     ())) ;
	connect	(&m_bCancel,	 SIGNAL(clicked()), SLOT(clickCancel ())) ;

	connect
	(	&m_cLinkPicker,
		SIGNAL(activated   (int)),
		SLOT  (linkSelected(int))
	)	;

	for (uint idx = 0 ; idx < m_slot->m_linkage.count() ; idx += 1)
		new KBSlotLinkItem
		(	m_cLinkPicker.listBox(),
			m_slot->m_linkage[idx]
		)	;

	m_tkEditor    .setHighlight("Python") ;
	m_eSlotName   .setText	   (m_slot->m_name) ;
	m_tkEditor    .setText	   (m_slot->m_code) ;

	m_bOK.setDefault (true) ;

	m_currentItem = 0     ;
	m_changed     = false ;

//	if (m_slot->m_linkage.count() == 0)
//		clickAdd     () ;
//	else	clickDismiss ()	;

	clickDismiss ()	;

#if	__KB_EMBEDDED
	showMaximized () ;
#else
	m_tkEditor.setMinimumSize (500, 220) ;
#endif
}

/*  KBSlotDlg								*/
/*  linkSelected: A particular link is selected				*/
/*  index	: int		:					*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::linkSelected
	(	int		index
	)
{
	KBSlotLinkItem *item = (KBSlotLinkItem *)m_cLinkPicker.listBox()->item(index) ;
	if (item != 0)
	{
		m_eLinkName   .setText    (item->m_name   ) ;
		m_eLinkTarget .setText    (item->m_target ) ;
		m_eLinkEvent  .setText    (item->m_event  ) ;
		m_cLinkEnabled.setChecked (item->m_enabled) ;
	}
}

/*  KBSlotDlg								*/
/*  clickFind	: User asks to find an object and event			*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickFind ()
{
	KBObject *curobj = m_parent->getNamedObject (m_eLinkTarget.text()) ;

	KBSlotFindDlg	sfDlg
			(	m_parent,
				curobj == 0 ? m_parent : curobj,
				m_eLinkEvent.text()
			)	;

	if (!sfDlg.exec ()) return	 ;

	QString	 event   ;
	KBObject *target = sfDlg.selectedObj (event) ;

	/* We need to find the common ancestor for the object which	*/
	/* owns the slots and the selected target object. Do this by	*/
	/* generating a list of ancestors for the owning object, then	*/
	/* search for each ancestor of the target.			*/
	QList<KBObject>	stack	;
	KBObject	*climb	= m_parent ;

	while (climb != 0)
	{
		stack.append (climb) ;

		if (climb->getParent() != 0)
			climb	= climb->getParent()->isObject() ;
		else	climb	= 0 ;
	}

	KBObject	*common	= target ;
	QString		dpath	;

	while (common != 0)
	{
		if (stack.findRef (common) >= 0)
			break	;

		if (dpath.isEmpty())
			dpath	= common->getName() ;
		else	dpath	= common->getName() + "/" + dpath ;

		if (common->getParent() != 0)
			common	= common->getParent()->isObject() ;
		else	common	= 0 ;
	}

	/* There should *always* be a common ancestor, even if it the	*/
	/* root node ...						*/
	if (common == 0)
	{
		KBError::EError
		(	TR("Failed to find common ancestor"),
			QString	(TR("Source '%1', target '%2'"))
				.arg(m_parent->getName())
				.arg(target  ->getName()),
			__ERRLOCN
		)	;
		return	;
	}

	/* We can now build the path from the owner to the target	*/
	climb	= m_parent ;
	while ((climb != 0) && (climb != common))
	{
		if (dpath.isEmpty())
			dpath	= ".."  ;
		else	dpath	= "../" + dpath ;

		if (climb->getParent() != 0)
			climb	= climb->getParent()->isObject () ;
		else	climb	= 0 ;
	}

	if (dpath.isEmpty()) dpath = "." ;

	m_eLinkTarget.setText (dpath) ;
	m_eLinkEvent .setText (event) ;
}

/*  KBSlotDlg								*/
/*  clickAdd	: User ask to add a new link				*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickAdd ()
{
	m_eLinkName   .clear	  () ;
	m_eLinkTarget .clear	  () ;
	m_eLinkEvent  .clear	  () ;

	m_eLinkName   .setEnabled (true ) ;
	m_eLinkTarget .setEnabled (true ) ;
	m_eLinkEvent  .setEnabled (true ) ;
	m_cLinkEnabled.setEnabled (true ) ;
	m_cLinkEnabled.setChecked (true ) ;

	m_bFind	      .setEnabled (true ) ;

	m_bAddLink    .setEnabled (false) ;
	m_bEditLink   .setEnabled (false) ;
	m_bSaveLink   .setEnabled (true ) ;
	m_bDismissLink.setEnabled (true ) ;
	m_bDropLink   .setEnabled (false) ;

	m_cLinkPicker .setEnabled (false) ;

	m_bOK	      .setEnabled (false) ;
	m_bCancel     .setEnabled (false) ;
}

/*  KBSlotDlg								*/
/*  clickEdit	: User requests to edit selected link			*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickEdit ()
{
	m_currentItem = (KBSlotLinkItem *)m_cLinkPicker.listBox()->item(m_cLinkPicker.currentItem()) ;
	if (m_currentItem == 0) return ;

	m_eLinkName   .setText	  (m_currentItem->m_name   ) ;
	m_eLinkTarget .setText	  (m_currentItem->m_target ) ;
	m_eLinkEvent  .setText	  (m_currentItem->m_event  ) ;
	m_cLinkEnabled.setChecked (m_currentItem->m_enabled) ;

	m_eLinkName   .setEnabled (true ) ;
	m_eLinkTarget .setEnabled (true ) ;
	m_eLinkEvent  .setEnabled (true ) ;
	m_cLinkEnabled.setEnabled (true ) ;

	m_bFind	      .setEnabled (true ) ;

	m_bAddLink    .setEnabled (false) ;
	m_bEditLink   .setEnabled (false) ;
	m_bSaveLink   .setEnabled (true ) ;
	m_bDismissLink.setEnabled (true ) ;
	m_bDropLink   .setEnabled (false) ;

	m_cLinkPicker .setEnabled (false) ;

	m_bOK	      .setEnabled (false) ;
	m_bCancel     .setEnabled (false) ;
}

/*  KBSlotDlg								*/
/*  clickEdit	: User requests to save current link			*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickSave ()
{
	QString	name   = m_eLinkName   .text() ;
	QString	target = m_eLinkTarget .text() ;
	QString	event  = m_eLinkEvent  .text() ;

	if (name.isEmpty() || target.isEmpty() || event.isEmpty())
	{
		if (TKMessageBox::questionYesNo
			(	0,
				TR("Name, object or event not set: save anyway?"),
				TR("Values not set")
			)
			!= TKMessageBox::Yes
		   )
			return	;
	}

	if (m_currentItem == 0)
	{
		m_currentItem = new KBSlotLinkItem
				(	m_cLinkPicker .listBox	  (),
					name,
					target,
					event,
					m_cLinkEnabled.isChecked  ()
				)	;
	}
	else
	{
		m_currentItem->m_name   = name   ;
		m_currentItem->m_target = target ;
		m_currentItem->m_event  = event  ;
		m_currentItem->m_enabled= m_cLinkEnabled.isChecked() ;
	}

	m_currentItem->setText (name) ;
	m_cLinkPicker .update  () ;

	m_changed = true ;
	clickDismiss ()  ;
}

/*  KBSlotDlg								*/
/*  clickDismiss: User requests to dismiss current link			*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickDismiss ()
{
	m_eLinkName   .setText	  ("") ;
	m_eLinkTarget .setText	  ("") ;
	m_eLinkEvent  .setText	  ("") ;
	m_cLinkEnabled.setChecked (false) ;

	m_eLinkName   .setEnabled (false) ;
	m_eLinkTarget .setEnabled (false) ;
	m_eLinkEvent  .setEnabled (false) ;
	m_cLinkEnabled.setEnabled (false) ;

	m_bFind	      .setEnabled (false) ;

	m_bAddLink    .setEnabled (true ) ;
	m_bEditLink   .setEnabled (m_cLinkPicker.count() > 0) ;
	m_bDropLink   .setEnabled (m_cLinkPicker.count() > 0) ;
	m_bSaveLink   .setEnabled (false) ;
	m_bDismissLink.setEnabled (false) ;

	m_cLinkPicker .setEnabled (true ) ;

	m_bOK	      .setEnabled (true ) ;
	m_bCancel     .setEnabled (true ) ;

	m_currentItem = 0 ;
	if (m_cLinkPicker.count() > 0) linkSelected (0) ;
}

/*  KBSlotDlg								*/
/*  clickDrop	: User asks to drop the selected link			*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickDrop ()
{
	m_currentItem = (KBSlotLinkItem *)m_cLinkPicker.listBox()->item(m_cLinkPicker.currentItem()) ;
	if (m_currentItem == 0) return ;

	DELOBJ(m_currentItem) ;
	m_cLinkPicker .update  () ;

	m_bEditLink   .setEnabled (m_cLinkPicker.count() > 0) ;
	m_bDropLink   .setEnabled (m_cLinkPicker.count() > 0) ;

	m_changed = true ;
}

/*  KBSlotDlg								*/
/*  clickVerify	: User asks to verify code				*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickVerify ()
{
	extern	bool	checkCompile (KBObject *, QString, cchar *) ;

	QString	text	= m_tkEditor.text() ;
	if (!text.stripWhiteSpace().isEmpty())
		if (checkCompile (m_parent, text.stripWhiteSpace() + "\n", "slotFunc"))
			TKMessageBox::information (0, TR("Slot compiles OK")) ;
}


/*  KBSlotDlg								*/
/*  clickOK	: Used OK's changes					*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickOK ()
{
	extern	bool	checkCompile (KBObject *, QString, cchar *) ;

	QString	text	= m_tkEditor.text() ;
	if (!text.stripWhiteSpace().isEmpty())
		if (!checkCompile (m_parent, text.stripWhiteSpace() + "\n", "slotFunc"))
			if (TKMessageBox::questionYesNo
			   	(	0,
					TR("Code does not compile: save anyway?"),
					TR("Save slot")
				)
				== TKMessageBox::No) return ;


	if (m_cLinkPicker.count() == 0)
		if (TKMessageBox::questionYesNo
		   	(	0,
				TR("No links: save anyway?"),
				TR("Save slot")
			)
			== TKMessageBox::No) return ;

	QString	code	= m_tkEditor.text().stripWhiteSpace() ;
	if (code.isEmpty())
		if (TKMessageBox::questionYesNo
		   	(	0,
				TR("No slot code: save anyway?"),
				TR("Save slot")
			)
			== TKMessageBox::No) return ;
	code	+= "\n" ;

	/* Update the slot code, then clear whatever linkage there was	*/
	/* and store the current version.				*/
	m_slot->m_name	= m_eSlotName.text() ;
	m_slot->m_code	= code	  ;
	m_slot->m_linkage.clear() ;

	for (int idx = 0 ; idx < m_cLinkPicker.count() ; idx += 1)
	{
		KBSlotLinkItem *link = (KBSlotLinkItem *)m_cLinkPicker.listBox()->item(idx) ;
		m_slot->addLinkage
		(	link->m_name,
			link->m_target,
			link->m_event,
			link->m_enabled
		)	;
	}

	done	(1) ;
}


/*  KBSlotDlg								*/
/*  clickCancel	: Used cancels changes					*/
/*  (returns)	: void		:					*/

void	KBSlotDlg::clickCancel ()
{
	if (m_changed || (m_eSlotName.text() != m_slot->m_name))
		if (TKMessageBox::questionYesNo
		   	(	0,
				TR("The slot has been changed: cancel anyway?"),
				TR("Slots changed")
			)
			== TKMessageBox::No) return ;
	done	(0) ;
}


/*  ------------------------------------------------------------------  */

/*  KBSlotListDlg							*/
/*  KBSlotListDlg: Constructor for slot list dialog			*/
/*  parent	 : QWidget *	   : Parent widget			*/
/*  slotList	 : QList<KBSlot> & : List of slots			*/
/*  object	 : KBObject *	   : Parent object			*/
/*  (returns)	 : KBSlotListDlg   :					*/

KBSlotListDlg::KBSlotListDlg
	(	QWidget		*parent,
		QList<KBSlot>	&slotList,
		KBObject	*object
	)
	:
	QWidget		(parent),
	m_object	(object),
	m_lbSlotList	(this),
	m_bAddSlot	(this),
	m_bEditSlot	(this),
	m_bDropSlot	(this)
{
	QHBoxLayout	*layMain = new QHBoxLayout (this) ;

	layMain->addWidget (&m_lbSlotList) ;

	QVBoxLayout	*layButt = new QVBoxLayout (layMain) ;
	layButt->addWidget  (&m_bAddSlot ) ;
	layButt->addWidget  (&m_bEditSlot) ;
	layButt->addWidget  (&m_bDropSlot) ;
	layButt->addStretch () ;

	connect
	(	&m_lbSlotList,
		SIGNAL(highlighted(int)),
		SLOT  (highlighted())
	)	;
	connect
	(	&m_lbSlotList,
		SIGNAL(doubleClicked(QListBoxItem *)),
		SLOT  (clickEditSlot())
	)	;
	connect
	(	&m_lbSlotList,
		SIGNAL(returnPressed(QListBoxItem *)),
		SLOT  (clickEditSlot())
	)	;

	connect	(&m_bAddSlot,   SIGNAL(clicked()), SLOT(clickAddSlot ())) ;
	connect	(&m_bEditSlot,  SIGNAL(clicked()), SLOT(clickEditSlot())) ;
	connect	(&m_bDropSlot,  SIGNAL(clicked()), SLOT(clickDropSlot())) ;

	m_bAddSlot .setText (TR("Add" )) ;
	m_bEditSlot.setText (TR("Edit")) ;
	m_bDropSlot.setText (TR("Drop")) ;

	/* Add an entry to the list box for each slot, storing the	*/
	/* slot pointer into it.					*/
	LITER
	(	KBSlot,
		slotList,
		slot,
		new KBSlotItem (&m_lbSlotList, slot)
	)

	m_bEditSlot.setEnabled (m_lbSlotList.currentItem() >= 0) ;
	m_bDropSlot.setEnabled (m_lbSlotList.currentItem() >= 0) ;

	_KBDialog::setupLayout (layMain, -1, -1) ;
}

/*  KBSlotListDlg							*/
/*  addSlot	 : Add a new slot					*/
/*  (returns)	 : void		:					*/

void	KBSlotListDlg::clickAddSlot ()
{
	/* Create a new slot and run the slot dialog. If this is OK'd	*/
	/* then add the slot to the slot list (as stored in the list	*/
	/* box), otherwise delete it.					*/
	KBSlot	  *slot	= new KBSlot (0, "UnnamedSlot") ;
	KBSlotDlg slotDlg (slot, m_object) ;

	if (slotDlg.exec())
	{
		new KBSlotItem (&m_lbSlotList, slot) ;
		m_lbSlotList.update     () ;
		m_bEditSlot .setEnabled (true) ;
		m_bDropSlot .setEnabled (true) ;
		return	;
	}

	delete	slot ;
}

/*  KBSlotListDlg							*/
/*  editSlot	 : Edit the current slot if any				*/
/*  (returns)	 : void		:					*/

void	KBSlotListDlg::clickEditSlot ()
{
	int idx = m_lbSlotList.currentItem() ;
	if (idx < 0) return ;

	KBSlotItem *slot = (KBSlotItem *)m_lbSlotList.item(idx) ;
	KBSlotDlg  sDlg  (slot->m_slot, m_object) ;

	if (sDlg.exec())
	{
		slot->setText (slot->m_slot->m_name) ;
		m_lbSlotList.update  () ;
	}
}

/*  KBSlotListDlg							*/
/*  dropSlot	 : Drop the current slot if any				*/
/*  (returns)	 : void		:					*/

void	KBSlotListDlg::clickDropSlot ()
{
	int idx = m_lbSlotList.currentItem() ;
	if (idx < 0) return ;

	KBSlotItem *slot = (KBSlotItem *)m_lbSlotList.item(idx) ;
	delete	slot->m_slot  ;
	delete	slot ;
}

/*  KBSlotListDlg							*/
/*  highlighted	: User highliggts slot in list				*/
/*  (returns)	 : void		:					*/

void	KBSlotListDlg::highlighted ()
{
	m_bEditSlot.setEnabled (m_lbSlotList.currentItem() >= 0) ;
	m_bDropSlot.setEnabled (m_lbSlotList.currentItem() >= 0) ;
}

/*  KBSlotListDlg							*/
/*  save	: Save 		  : Save results back into slot list	*/
/*  slotList	: QList<KBSlot> & : List of slots			*/

void	KBSlotListDlg::save
	(	QList<KBSlot>	&slotList
	)
{
	slotList.clear() ;
	for (uint idx = 0 ; idx < m_lbSlotList.count() ; idx += 1)
		slotList.append (((KBSlotItem *)m_lbSlotList.item(idx))->m_slot) ;
}
