/***************************************************************************
    file	         : kb_attrexpr.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_location.h"
#include	"kb_attr.h"
#include	"kb_script.h"
#include	"kb_object.h"
#include	"kb_attrexpr.h"
#include	"kb_callback.h"
#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"
#include	"kb_docroot.h"

/*  KBAttrExpr								*/
/*  KBAttrExpr: Constructor for expression class			*/
/*  node	: KBNode *	: Owning node				*/
/*  name	: cchar *	: Attribute name			*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  (returns)	: KBAttrExpr	:					*/

KBAttrExpr::KBAttrExpr
	(	KBNode			*node,
		cchar			*name,
		const QDict<QString>	&aList
	)
	:
	KBAttrStr (node, name, aList)
{
	disable	= false	;
	code	= 0	;
	isexpr	= getValue().at(0) == '=' ;
}

/*  KBAttrExpr								*/
/*  KBAttrExpr: Constructor for expression class			*/
/*  node	: KBNode *	: Owning node				*/
/*  name	: cchar *	: Attribute name			*/
/*  text	: cchar *	: Initial text value			*/
/*  (returns)	: KBAttrExpr	:					*/

KBAttrExpr::KBAttrExpr
	(	KBNode	*node,
		cchar	*name,
		cchar	*text
	)
	:
	KBAttrStr (node, name, text)
{
	disable	= false	;
	code	= 0	;
	isexpr	= getValue().at(0) == '=' ;
}

/*  KBAttrExpr								*/
/*  KBAttrExpr: Constructor for expression class			*/
/*  node	: KBNode *	: Owning node				*/
/*  name	: cchar *	: Attribute name			*/
/*  srce	: KBNode *	: Extant source				*/
/*  (returns)	: KBAttrExpr	:					*/

KBAttrExpr::KBAttrExpr
	(	KBNode	*node,
		cchar	*name,
		KBNode	*srce
	)
	:
	KBAttrStr (node, name, srce)
{
	disable	= false	;
	code	= 0	;
	isexpr	= getValue().at(0) == '=' ;
}

/*  KBAttrExpr								*/
/*  ~KBAttrExpr	: Destructor for expression class			*/
/*  (returns)	:		:					*/

KBAttrExpr::~KBAttrExpr ()
{
	if (code != 0) delete code ;
}

/*  KBAttrExpr								*/
/*  setValue	: Set event text value					*/
/*  value	: QString &	: Value					*/
/*  (returns)	: void		:					*/

void	KBAttrExpr::setValue
	(	const QString	&value
	)
{
	/* This method is overridden so that we can clear any code	*/
	/* compiled for an earlier value, and clear the disabled flag	*/
	DELOBJ	(code)	;
	disable	= false	;
	isexpr	= value.at(0) == '=' ;

	KBAttrStr::setValue (value)  ;
}

/*  KBAttrExpr								*/
/*  evaluate	: Evaluate value					*/
/*  argval	: const KBValue & : Argument value			*/
/*  rc		: KB::ScriptRC &  : Script execution result		*/
/*  fSubs	: bool &	  : Substitution flag			*/
/*  (returns)	: KBValue	  : Resultant value			*/

KBValue	KBAttrExpr::evaluate
	(	const KBValue	&argval,
		KB::ScriptRC	&eRC,
		bool		&fSubs
	)
{
	if (!isexpr)
	{	eRC	= KB::ScriptOK ;
		return	argval	;
	}

	bool		ok	  ;
	KBError		error	  ;
	QString		expr	  = getValue () ;
	KBDocRoot	*root	  = owner->getDocRoot    () ;
	KBScriptIF	*scrIface = root ->loadScripting (ok, error) ;
	KBValue		resval	  ;
	KBScript::ExeRC rc 	  ;

	/* A script interface is needed to be able to execute the	*/
	/* expression code.						*/
	if (!ok)
	{
		error.DISPLAY() ;
		eRC	= KB::ScriptInlineError ;
		return	resval	;
	}
	if (scrIface == 0)
	{
		KBError::EError
		(	TR("No scripting language specified"),
			QString(TR("Trying to execute expression %1")).arg(expr),
			__ERRLOCN
		)	;
		return	KB::ScriptInlineError ;
	}

	/* If the expression is flagged as disabled then there has	*/
	/* been an earlier error ...					*/
	if (disable)
	{
		KBError::EError
		(	TR("Expression has been disabled due to earlier error"),
			QString::null,
			__ERRLOCN
		)	;

		owner->getDocRoot()->doExecError () ;
		eRC	= KB::ScriptInlineError ;
		return	resval	;
	}


	/* We compile the code and keep a copy. First see if the code	*/
	/* has already been compiled and if not then so so now.		*/
	if (code == 0)
	{
		QString		eText	;
		QString		ePatt	;
		KBError		error	;

		if ((code = scrIface->compileExpr
			    (	expr.mid(1),
				owner->isObject  ()->getPath   (),
				eText,
				ePatt,
				owner->getDocRoot()->getImports(),
				error
			    )	) == 0)
		{
			/* Compile error in the inline code. Display	*/
			/* the error message, and return the form or	*/
			/* report to design mode.				*/
			error.DISPLAY  () ;
			owner->getDocRoot()->doExecError () ;

			/* The event is disabled, and we return such	*/
			/* that the caller will bring up the required	*/
			/* property dialog.				*/
			disable	= true	;
			eRC	= KB::ScriptInlineError ;
			return	 resval	;
		}
	}

	/* Code was or has been compiled successfully, in which case	*/
	/* execute it. Check for an execution time error ....		*/
	rc = code->execute (owner, 0, 0, resval) ;

	if ((rc == KBScript::ExeError) || (rc == KBScript::ExeFail))
	{
		QString	   errMsg   ;
		uint	   errLno   ;
		QString	   errText  ;
		KBLocation errLocn  = scrIface->exeError (errMsg, errLno, errText) ;

		KBError::EError
		(	errMsg,
			QString (TR("%1, line %2\n%3"))
				.arg(errLocn.docName)
				.arg(errLno)
				.arg(errText),
			__ERRLOCN
		)	;

		owner->getDocRoot()->doExecError () ;

		/* If the error was not in the inline code then bring	*/
		/* up the script editor (unless the debugger is		*/
		/* handling this), and return such that the caller	*/
		/* will not show the property editor.			*/
		if (errLocn.docName != KBLocation::m_pInline)
		{
			if (rc != KBScript::ExeFail)
			{
				KBError	   error ;
				if (!KBAppPtr::getCallback()->editScript (errLocn, errText, "", errLno, error))
					error.DISPLAY () ;
			}

			eRC	= KB::ScriptGlobalError ;
			return	resval	 ;
		}

		/* Error was inline. Disable the expression and return	*/
		/* such that the dialog editor will be displayed.	*/
		disable	= true	;
		eRC	= KB::ScriptInlineError ;
		return	resval	;
	}

	/* Success ....							*/
	eRC	= KB::ScriptOK ;
	fSubs	= resval.getRawText().find("%{") >= 0 ;
	return	resval	;
}
