/***************************************************************************
    file	         : kb_attrimagedlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>
#include	<qimage.h>

#include	<errno.h>

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_graphic.h"
#include	"kb_docroot.h"
#include	"kb_dbdociter.h"

#ifndef 	_WIN32
#include 	"kb_attrimagedlg.moc"
#else
#include 	"kb_attrimagedlg.h"
#endif

#include	"tk_filedialog.h"



/*  importImage	: Import an image into the system			*/
/*  dbInfo	: KBDBInfo *	  : Database information object		*/
/*  svName	: const QString & : Server name				*/
/*  name	: QString &	  : Return image name			*/
/*  pError	: KBError &	  : Return error			*/
/*  (returns)	: bool		  : Success				*/

LIBKBASE_API
	bool	importImage
	(	KBDBInfo	*dbInfo,
		const QString	&svName,
		QString		&name,
		KBError		&pError
	)
{
	/* Start with the file open dialog, with a filter set that	*/
	/* covers the extensions handled by Qt (found dynamically, this	*/
	/* adapts to however Qt was built).				*/
	extern	QString	imageFmtList (QStrList) ;

	KBFileDialog fDlg 
		     (	".",
			imageFmtList (QImageIO::inputFormats()),
			qApp->activeWindow(),
			"loadimage",
			true
		     )	;

	fDlg.setMode	  (KBFileDialog::ExistingFile) ;
	fDlg.setCaption   ("Load image ....") ;

	/* If the user cancels then that is not an error, but pass the	*/
	/* name back as null to signal such.				*/
	if (!fDlg.exec ())
	{
		name	= QString::null ;
		return true ;
	}

	QString	file	  = fDlg.selectedFile  () ;
	QString filter	  = fDlg.currentFilter () ;

	fprintf
	(	stderr,
		"importImage: [%s][%s]\n",
		(cchar *)file,
		(cchar *)filter
	)	;

	/* Load the image file into memory, whence it can be stored as	*/
	/* for any other document.					*/
	QFile  imgFile (file) ;

	if (!imgFile.open (IO_ReadOnly))
	{
		pError	= KBError
			  (	KBError::Error,
				QString  (TR("Cannot open \"%1\"")).arg(file),
				strerror (errno),
				__ERRLOCN
			  )	;
		return	false	;
	}

	QByteArray  data = imgFile.readAll() ;

	/* We will store the image using the final part of the path	*/
	/* with the extension split off ...				*/
	QFileInfo info (file) ;

	KBLocation dest
		   (	dbInfo,
			"graphic",
			svName,
			info.baseName (),
			info.extension(false)
		   )	;

	if (!dest.save
		(	QString::null,
			QString::null,
			data.data(),
			data.size(),
			pError
		))
		return	false ;


	name	= info.fileName() ;
	return	true	;
}


/*  ------------------------------------------------------------------  */

/*  KBAttrImageDlg							*/
/*  KBAttrImageDlg							*/
/*		: Constructor for image selection/load dialog		*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttr *		: Associated attribute		*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: All attributes		*/
/*  (returns)	: KBImageDlg		:					*/

KBAttrImageDlg::KBAttrImageDlg
	(	QWidget			*parent,
		KBAttr			*attr,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_image		(this),
	m_list		(this),
	m_bLoad		(this)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;

	layMain->addWidget (&m_image) ;
	layMain->addWidget (&m_list ) ;

	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;

	layButt->addStretch()	      ;
	layButt->addWidget (&m_bLoad) ;

	layMain->addStretch()	      ;

	m_bLoad.setText	   (TR("Load graphic")) ;
	loadImageList	   () ;

	connect	(&m_list,  SIGNAL(activated(int)), SLOT(slotListActive())) ;
	connect (&m_bLoad, SIGNAL(clicked     ()), SLOT(slotClickLoad ())) ;
}

/*  KBAttrImageDlg							*/
/*  loadImageList: Load list of images in server			*/
/*  (returns)	 : void		:					*/

void	KBAttrImageDlg::loadImageList ()
{
	KBNode		 *node	 = m_item->attr()->getOwner() ;
	const KBLocation &locn	 = node->getDocRoot()->getLocation() ;
	KBDBDocIter	 docIter (true) ;
	KBError		 error	 ;

	m_list.clear ()	 ;

	if (docIter.init
		(	locn.dbInfo,
			locn.docLocn,
			"graphic",
			"*",
			error
		))
	{
		QString	name	;
		QString	stamp	;

		while (docIter.getNextDoc (name, stamp))
		{
			m_list.insertItem (name) ;
		}
	}
	else	error.DISPLAY() ;
}

/*  KBAttrImageDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool  	  : Always false, no modal dialog	*/

bool	KBAttrImageDlg::init
	(	const QString	&value
	)
{
	m_image.setText (value) ;

	for (int idx = 0 ; idx < m_list.count() ; idx += 1)
		if (m_list.text(idx) == value)
		{	m_list.setCurrentItem (idx) ;
			break	;
		}

	return	false	;
}

/*  KBAttrImageDlg							*/
/*  value	: Get value						*/
/*  (returns)	: void		:					*/

QString	KBAttrImageDlg::value ()
{
	return	m_image.text () ;
}

/*  KBAttrImageDlg							*/
/*  slotListActive: User selects image from list			*/
/*  (returns)	  : void	:					*/

void	KBAttrImageDlg::slotListActive ()
{
	m_image.setText (m_list.currentText()) ;
}

/*  KBAttrImageDlg							*/
/*  slotClickLoad : User requests to load an image			*/
/*  (returns)	  : void	:					*/

void	KBAttrImageDlg::slotClickLoad ()
{
	KBNode		 *node	= m_item->attr()->getOwner() ;
	const KBLocation &locn	= node->getDocRoot()->getLocation() ;
	QString		 name	;
	KBError		 error	;

	/* Import the image. Report errors and check for the case where	*/
	/* the user has just cancelled the file dialog.			*/
	if (!importImage
		(	locn.dbInfo,
			locn.docLocn,
			name,
			error
		))
	{
		error.DISPLAY() ;
		return		;
	}

	if (name.isNull()) return ;

	/* Presumably the user wants to use this as the image to set	*/
	/* the image name to match, then update the list of images to	*/
	/* reflect the addition.					*/
	m_image.setText (name) ;
	loadImageList   () ;

	for (int idx = 0 ; idx < m_list.count() ; idx += 1)
		if (m_list.text(idx) == name)
		{	m_list.setCurrentItem (idx) ;
			break	;
		}
}

