/***************************************************************************
    file	         : kb_button.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_button.moc"
#else
#include 	"kb_button.h"
#endif

#include	"kb_nodereg.h"
#include	"kb_navigator.h"


/*  KBButton								*/
/*  KBButton	: Consructor for button node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBButton	:					*/

KBButton::KBButton
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBObject 	(parent, "KBButton",	aList),
	fgcolor		(this,   "fgcolor",	aList),
	bgcolor		(this,   "bgcolor",	aList),
	font		(this,	 "font",	aList),
	text	 	(this,   "text",     	aList),
	tabOrd	 	(this,	 "taborder", 	aList),
	onClick	 	(this,   "onclick",  	"onButton", aList)

{
	button	= 0 	;
	code	= 0 	;
	disable	= false	;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!KBNode::propertyDlg ("Button"))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBButton								*/
/*  KBButton	: Consructor for button node				*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _button	: KBButton *	: Extant button				*/
/*  (returns)	: KBButton	:					*/

KBButton::KBButton
	(	KBNode	 	*_parent,	
		KBButton 	*_button
	)
	:
	KBObject	(_parent, _button),
	fgcolor		(this,   "fgcolor",	_button),
	bgcolor		(this,   "bgcolor",	_button),
	font		(this,	 "font",	_button),
	text	 	(this,   "text",	_button),
	tabOrd	 	(this,	 "taborder", 	_button),
	onClick	 	(this,   "onclick",	"onButton", _button)
{
	button	= 0	;
	code	= 0 	;
	disable	= false	;
}

/*  KBButton								*/
/*  ~KBButton	: Desructor for button node				*/
/*  (returns)	:		:					*/

KBButton::~KBButton ()
{
//	fprintf	(stderr, "Delete button: %s\n", (const char *)text.getValue()) ;
}

/*  KBButton								*/
/*  buildCtrls	: Build controls for this node				*/
/*  numrows	: uint		: Number of rows to be displayed	*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBButton::buildCtrls
	(	uint		numrows,
		int		dx,
		int		dy
	)
{
	KBObject::buildCtrls (numrows, dx, dy) ;

	if (button == 0)
	{
		button	= new KBCtrlButton (getDisplay(), this) ;
		setControl (button) ;
	}

	setText    	    (text.getValue()) ;
	button->setGeometry (geometry     ()) ;
	button->setVisible  (true ) ;
	setPalette 	    () ;
	setFont 	    () ;
}

/*  KBButton								*/
/*  showAs	: Switch in or out of design mode			*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBButton::showAs
	(	KB::ShowAs	mode
	)
{
	KBObject::showAs (mode) ;
	setText	(text.getValue()) ;
}

/*  KBButton								*/
/*  clicked	: Handle button click					*/
/*  (returns)	: void		:					*/

void	KBButton::clicked ()
{
	bool	evRc ;
	eventHook (onClick, 0, 0, evRc) ;
}

/*  KBButton								*/
/*  keyStroke	: Handle keystroke					*/
/*  e		: QKeyEvent *	: Event to be handled			*/
/*  (returns)	: bool		: True if event consumed		*/

bool	KBButton::keyStroke
	(	QKeyEvent	*k
	)
{
//	fprintf
//	(	stderr,
//		"KBButton::keyStroke: %d\n",
//		k->key()
//	)	;
	KBNavigator *navi = getNavigator() ;
	bool	    shift = (k->state () & Qt::ShiftButton) != 0 ;

	if (button != 0)
		switch (k->key())
		{
			case Qt::Key_Enter	:
			case Qt::Key_Return	:
				((QButton *)button->topWidget())->animateClick () ;
				return	true	;

			case Qt::Key_Tab	:
				if (navi != 0)
				{
					if (shift)
						navi->goPrevious (this, true) ;
					else	navi->goNext 	 (this, true) ;
				}
				return	true	;

			case Qt::Key_Backtab	:
				if (navi != 0)
					navi->goPrevious (this, true) ;
				return	true	;
			
			default	:
				break	;
		}

	return	false	;
}

/*  KBButton								*/
/*  setTabOrder	: Return tab order value				*/
/*  order	: int		: Tab order				*/
/*  (returns)	: void		:					*/

void	KBButton::setTabOrder
	(	int	order
	)
{
	tabOrd.setValue (order) ;
}

/*  KBButton								*/
/*  getTabOrder	: Return tab order value				*/
/*  (returns)	: int		: Tab order				*/

int	KBButton::getTabOrder ()
{
	return	tabOrd.getIntValue () ;
}

/*  KBButton								*/
/*  replicate	: Replicate this button					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New button node			*/

KBNode	*KBButton::replicate
	(	KBNode	*_parent
	)
{
	return	new KBButton (_parent, this) ;
}

/*  KBButton								*/
/*  updateProps	: Update properties					*/
/*  (returns)	: void		:					*/

void	KBButton::updateProps ()
{
	KBObject::updateProps ()  ;
	setText (text.getValue()) ;
}

#if	! __KB_RUNTIME

/*  KBButton								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial property			*/
/*  (returns)	: bool		: Success				*/

bool	KBButton::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!KBNode::propertyDlg ("Button", iniAttr)) return false ;

	updateProps () ;
	return	true   ;
}
#endif


NEWNODE(Button, __TR("New &Button"), KF_FORM|KF_BLOCK|KF_STATIC)
