/***************************************************************************
    file	         : kb_fieldchooser.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#ifndef 	_WIN32
#include	"kb_fieldchooser.moc"
#else
#include	"kb_fieldchooser.h"
#endif

#include	"kb_serverinfo.h"
#include	"kb_dialog.h"
#include	"kb_qryquery.h"



/*  KBFieldChooser							*/
/*  KBFieldChooser							*/
/*		: Constructor for field chooser				*/
/*  location	: KBLocation &	 : Database location			*/
/*  cbServer	: QComboBox &	 : Server selector			*/
/*  cbObject	: QComboBox &	 : Table/query selector			*/
/*  lbFields	: QListBox &	 : List of all fields			*/
/*  lbSelect	: QListBox &	 : List of selected fields		*/
/*  bAdd	: QPustButton &	 : Add field button			*/
/*  bAddAll	: QPustButton &	 : Add all button			*/
/*  bRemove	: QPustButton &	 : Remove button			*/
/*  bUp		: QPustButton &	 : Move up button			*/
/*  bDown	: QPustButton &	 : Move down button			*/
/*  table	: bool		 : Selecting from query			*/
/*  multi	: bool		 : Field can be selected more than once	*/
/*  (returns)	: KBFieldChooser :					*/

KBFieldChooser::KBFieldChooser
	(	KBLocation	&location,
		QComboBox	&cbServer,
		QComboBox	&cbObject,
		QListBox	&lbFields,
		QListBox	&lbSelect,
		QPushButton	&bAdd,
		QPushButton	&bAddAll,
		QPushButton	&bRemove,
		QPushButton	&bUp,
		QPushButton	&bDown,
		bool		table,
		bool		multi
	)
	:
	location	(location),
	cbServer	(cbServer),
	cbObject	(cbObject),
	tabChooser
	(	table ?
			new KBTableChooser(location, cbServer, cbObject) :
			0
	),
	qryChooser
	(	table ?
			0 :
			new KBQueryChooser(location, cbServer, cbObject)
	),
	lbFields	(lbFields),
	lbSelect	(lbSelect),
	m_lbPair
	(	&lbFields,
		&lbSelect,
		&bAdd,
		&bAddAll,
		&bRemove,
		&bUp,
		&bDown,
		multi
	)
{
	if (tabChooser != 0)
	{
		connect (tabChooser, SIGNAL(serverChanged()),	SLOT(setFields	   ())) ;
		connect (tabChooser, SIGNAL(tableChanged ()),	SLOT(setFields	   ())) ;
	}
	if (qryChooser != 0)
	{
		connect (qryChooser, SIGNAL(serverChanged()),	SLOT(setFields	   ())) ;
		connect (qryChooser, SIGNAL(queryChanged ()),	SLOT(setFields	   ())) ;
	}

	connect
	(	&m_lbPair,
		SIGNAL	(destChanged(bool)),
		SLOT	(destChanged(bool))
	)	;
}

KBFieldChooser::~KBFieldChooser ()
{
	DELOBJ	(tabChooser) ;
	DELOBJ	(qryChooser) ;
}

void	KBFieldChooser::destChanged
	(	bool		contents
	)
{
	emit	selectChanged (contents) ;
}

/*  KBFieldChooser							*/
/*  setFields	: Set fields for selected server and table/query	*/
/*  (returns)	: void		  :					*/

void	KBFieldChooser::setFields ()
{
	lbSelect.clear () ;
	lbFields.clear () ;

	QString	svrName	= cbServer.currentText() ;
	QString	objName	= cbObject.currentText() ;

	if (!svrName.isEmpty() && !objName.isEmpty())
	{
		if (tabChooser != 0)
		{
			KBTableSpec 	tabSpec (objName) ;
			KBDBLink    	dbLink  ;

			if (!dbLink.connect (location, svrName))
			{	dbLink.lastError().DISPLAY() ;
				return	;
			}

			if (!dbLink.listFields (tabSpec))
			{	dbLink.lastError().DISPLAY() ;
				return	;
			}

			LITER
			(	KBFieldSpec,
				tabSpec.m_fldList,
				fldSpec,

				lbFields.insertItem (fldSpec->m_name) ;
			)
		}

		if (qryChooser != 0)
		{
			KBLocation	locn
					(	location.dbInfo,
						"query",
						svrName,
						objName
					)	;

			KBDummyRoot	dummy (locn) ;

			KBQryQuery *qry	 = new KBQryQuery (&dummy) ;

			if (!qry->loadQueryDef (locn))
			{
				qry->lastError().DISPLAY() ;
				return	;
			}

			QList<KBFieldSpec> fldList ;
			int		   pKey	   ;
			fldList.setAutoDelete (true) ;

			if (!qry->getFieldList (0, fldList, pKey))
			{
				qry->lastError().DISPLAY() ;
				return	;
			}

			LITER
			(	KBFieldSpec,
				fldList,
				fldSpec,

				lbFields.insertItem (fldSpec->m_name) ;
			)
		}
	}

	m_lbPair.setButtonState () ;
	emit   fieldsChanged () ;
	emit   selectChanged (true) ;
}


/*  ------------------------------------------------------------------  */

/*  KBFieldChooserDlg							*/
/*  KBFieldChooserDlg							*/
/*		: Constructor for field chooser dialog			*/
/*  location	: KBLocation &	    : Database location			*/
/*  table	: bool		    : Selecting from tables		*/
/*  multi	: bool		    : Allow multiple selection		*/
/*  (returns)	: KBFieldChooserDlg :					*/

KBFieldChooserDlg::KBFieldChooserDlg
	(	KBLocation	&location,
		bool		table,
		bool		multi
	)
	:
	_KBDialog 	("Select fields", true),
	location	(location),
	lServer		(this),
	lObject		(this),
	cbServer	(this),
	cbObject	(this),
	lbFields	(this),
	lbSelect	(this),
	bAdd		(this),
	bAddAll		(this),
	bRemove		(this),
	bUp		(this),
	bDown		(this),
	bOK		(this),
	bCancel		(this),
	fldChooser
	(	location,
		cbServer,  cbObject, lbFields, lbSelect,
		bAdd,	   bAddAll,  bRemove,  bUp,      bDown,
		table,
		multi
	)
{
	layMain	    = new QVBoxLayout (this     ) ;

	layObject   = new QGridLayout (layMain  ) ;
	layObject  ->addWidget (&lServer,   0, 0) ;
	layObject  ->addWidget (&lObject,   0, 1) ;
	layObject  ->addWidget (&cbServer,  1, 0) ;
	layObject  ->addWidget (&cbObject,  1, 1) ;

	laySelect   = new QHBoxLayout (layMain  ) ;
	laySelect  ->addWidget (&lbFields) ;
	layButton   = new QVBoxLayout (laySelect) ;
	laySelect  ->addWidget (&lbSelect) ;

	layButton  ->addWidget (&bAdd    ) ;
	layButton  ->addWidget (&bAddAll ) ;
	layButton  ->addWidget (&bRemove ) ;
	layButton  ->addWidget (&bUp     ) ;
	layButton  ->addWidget (&bDown   ) ;
	layButton  ->addStretch() ;

	layOKCancel = new QHBoxLayout  (layMain ) ;
	layOKCancel->addStretch() ;
	layOKCancel->addWidget (&bOK	 ) ;
	layOKCancel->addWidget (&bCancel ) ;

	_KBDialog::setupLayout (layMain,     -1, -1) ;
	_KBDialog::setupLayout (layButton,   -1, -1) ;
	_KBDialog::setupLayout (layOKCancel, -1, -1) ;

	lbFields.setMinimumWidth (120) ;
	lbSelect.setMinimumWidth (120) ;

	lServer .setText    (TR("Select server")) ;
	lObject .setText    (table ? TR("Select table") : TR("Select query")) ;
	bOK	.setText    (TR("OK"    )) ;
	bCancel	.setText    (TR("Cancel")) ;
	bOK	.setEnabled (false   ) ;

	connect (&fldChooser, SIGNAL(selectChanged(bool)), SLOT(selectChanged())) ;
	connect	(&bOK,	      SIGNAL(clicked          ()), SLOT(clickOK      ())) ;
	connect	(&bCancel,    SIGNAL(clicked          ()), SLOT(clickCancel  ())) ;
}

/*  KBFieldChooserDlg							*/
/*  selectChanged: User has changed selected fields list		*/
/*  (returns)	: void		:					*/

void	KBFieldChooserDlg::selectChanged ()
{
	bOK.setEnabled (lbSelect.count() > 0) ;
}

/*  KBFieldChooserDlg							*/
/*  clickOK	: User clicks OK button					*/
/*  (returns)	: void		:					*/

void	KBFieldChooserDlg::clickOK ()
{
	done	(true ) ;
}

/*  KBFieldChooserDlg							*/
/*  clickCancel	: User clicks cancel button				*/
/*  (returns)	: void		:					*/

void	KBFieldChooserDlg::clickCancel ()
{
	done	(false)	;
}

/*  KBFieldChooserDlg							*/
/*  getFields	: Get list of fields					*/
/*  (returns)	: QStringList	: Field list				*/

QStringList	KBFieldChooserDlg::getFields ()
{
	QStringList	fields	;
	for (uint idx = 0 ; idx < lbSelect.count() ; idx += 1)
		fields.append (lbSelect.text (idx)) ;
	return		fields	;
}

