/***************************************************************************
    file	         : kb_link.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qpopupmenu.h>
#include	<qcursor.h>

#include	"kb_formblock.h"
#include	"kb_sizer.h"
#include	"kb_select.h"

#ifndef		_WIN32
#include	"kb_link.moc"
#else
#include	"kb_link.h"
#endif

#include	"kb_qtlink.h"
#include	"kb_qtreplink.h"
#include	"kb_nodereg.h"
#include	"kb_queryset.h"
#include	"kb_qrytable.h"
#include	"kb_qryquery.h"
#include	"kb_qrysql.h"
#include	"kb_layout.h"
#include	"kb_finddlg.h"


/*  KBLinkDummy								*/
/*  -----------								*/
/*  The KBLink class works by creating some dummy items. These are of	*/
/*  class KBLinkDummy, which overrides the various methods ....		*/

class	KBLinkDummy : public KBItem
{
public	:

	inline	KBLinkDummy
		(	KBObject 	*parent,
			const QString	&eName,
			const QString	show
		)
		:
		KBItem	(parent, "KBLinkDummy", QRect(), eName, show, 0)
	{
	}

	virtual	void	buildGUI
		(	uint	,
			int	,
			int
		)
	{
	}
	virtual	void	showAs
		(	KB::ShowAs
		)
	{
		/* Switching in and out of design mode should not do	*/
		/* anything.						*/
	}
	virtual	void	printNode
		(	QString	&,
			int
		)
	{
		/* Dont want to print anything for this note, it is	*/
		/* always built on the fly.				*/
	}
	virtual	bool	isUpdateVal ()
	{
		/* Don't get a value from here, is should come from the	*/
		/* read link node.					*/
		return	false	;
	}
}	;


/*  KBLink								*/
/*  KBLink	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBLink::KBLink
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem		(parent, "KBLink",
				 "master", 	aList),
	m_child		(this,   "child",	aList,    KF_REQD),
	m_show		(this,   "show",	aList,    KF_REQD),
	m_fgcolor	(this,   "fgcolor",	aList),
	m_bgcolor	(this,   "bgcolor",	aList),
	m_font		(this,	 "font",	aList),
	m_nullval	(this,	 "nullval",	aList),
	m_nullOK	(this,	 "nullok",	aList,    KF_FORM),
	m_dynamic	(this,	 "dynamic",	aList),
	m_morph		(this,   "morph",	aList,    KF_FORM),
	m_showCols	(this,	 "showcols",	aList,	  KF_FORM),
	m_onChange	(this,	 "onchange",	"onLink", aList)
{
//	expr.setFlags (KF_REQD) ;

	m_query	 = 0	 ;
	m_iKey	 = 0	 ;
	m_loaded = false ;

	m_iShow .setAutoDelete (true) ;
	m_valset.setAutoDelete (true) ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		QString	*lt = aList.find ("linktype") ;

		if (lt != 0)
			if	(*lt == "query") m_query = new KBQryQuery (this) ;
			else if (*lt == "sql"  ) m_query = new KBQrySQL   (this) ;

		if (m_query == 0)
			m_query	= new KBQryTable (this) ;

		if (!m_query->propertyDlg ())
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		if (!::linkPropDlg (this, "Link", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		if (getFormBlock() != 0)
			getFormBlock()->fixTabOrder () ;

		*ok	= true	 ;
	}
#endif
}

/*  KBLink								*/
/*  KBLink	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _link	: KBLink *	: Extant link				*/
/*  (returns)	: KBNode	:					*/

KBLink::KBLink
	(	KBNode		*_parent,
		KBLink		*_link
	)
	:
	KBItem		(_parent, "master", 			_link),
	m_child		(this,    "child",			_link, KF_REQD),
	m_show		(this,    "show",			_link, KF_REQD),
	m_fgcolor	(this,    "fgcolor",			_link),
	m_bgcolor	(this,    "bgcolor",			_link),
	m_font		(this,	  "font",			_link),
	m_nullval	(this,	  "nullval",			_link),
	m_nullOK	(this,	  "nullok",			_link),
	m_dynamic	(this,	  "dynamic",			_link),
	m_morph		(this,    "morph",			_link, KF_FORM),
	m_showCols	(this,	  "showcols",			_link, KF_FORM),
	m_onChange	(this,	  "onchange",	"onChoice",	_link)
{
//	expr.setFlags (KF_REQD) ;

	m_iKey	 = 0 		;
	m_loaded = false	;
	m_query	 = 0		;

	m_iShow .setAutoDelete (true) ;
	m_valset.setAutoDelete (true) ;
}

/*  KBLink								*/
/*  ~KBLink	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBLink::~KBLink ()
{
	DELOBJ	(m_iKey) ;
	m_iShow.clear () ;
}

/*  KBLink								*/
/*  keyStroke	: Control has received keystroke			*/
/*  k		: QKeyEvent *	: Key event in question			*/
/*  (returns)	: bool		: Key event consumed			*/

bool	KBLink::keyStroke
	(	QKeyEvent	*k
	)
{
	/* Override for key up and key down so that we can change	*/
	/* selection, otherwise these keys will navigate between	*/
	/* records.							*/
	if (k->type() == QEvent::KeyPress)
		if ((k->key() == Qt::Key_Up) || (k->key() == Qt::Key_Down))
			return	false	;

	return	KBItem::keyStroke (k) ;
}

/*  KBLink								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBLink::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
	{
		m_keyset.clear ()	;
		m_valset.clear ()	;
		remDummyItems  () 	;
		m_loaded = false  	;
	}
#endif
	m_query	= 0 ;

	CITER
	(	QryBase,
		q,
		m_query = q
	)	;

	if (m_query == 0)
		KBError::EFault
		(	"Link control lacks a query",
			QString::null,
			__ERRLOCN
		)	;

	KBItem::showAs (mode) ;
}

/*  KBLink								*/
/*  remDummyItems: Remove dummy items for query				*/
/*  (returns)	 : void		:					*/

void	KBLink::remDummyItems ()
{
	if (m_iKey  != 0)
	{
		if (m_query != 0) m_query->remItem (0, m_iKey ) ;
		DELOBJ	(m_iKey)	;
	}

	LITER
	(	KBItem,
		m_iShow,
		item,

		m_query->remItem (0, item)
	)

	m_iShow.clear () ;
}

/*  KBLink								*/
/*  addDummyItems: Add dummy items for query				*/
/*  (returns)	 : void		:					*/

void	KBLink::addDummyItems ()
{
	/* The link works by adding two items, one to contain the key	*/
	/* from the query (ie., the child value), and the other for	*/
	/* the values from the query (ie., the displayed expressions).	*/

	/* If any dummy items already exist then remove them. This is	*/
	/* needed since this routine is called after the link		*/
	/* properties have been changed.				*/
	remDummyItems  () ;

	m_query->addItem (0, 0) ;
	m_query->addItem (0, m_iKey = new KBLinkDummy (this, "_key",  m_child.getValue())) ;


	/* Split the "show" expression into separate expressions and	*/
	/* add a dummy item for each. We use the select parser to do 	*/
	/* this; if it fails to parse then assume that we have a single	*/
	/* expression and hope!						*/
	KBSelect select	;
	if (select.parseExprList (m_show.getValue()))
	{
		const QValueList<KBSelectExpr> exprs = select.getExprList () ;
		QValueList<KBSelectExpr>::ConstIterator iter ;
		uint idx = 0 ;

		for (iter = exprs.begin() ; iter != exprs.end() ; iter++, idx++)
		{
			KBItem	*item = new KBLinkDummy
					(	this,
						QString("__show_%1").arg(idx),
						(*iter).exprText(0)
					)	;

			m_iShow .append  (item)	   ;
			m_query->addItem (0, item) ;

//			fprintf
//			(	stderr,
//				"KBLink::addDummyItems: add %d [%s]\n",
//				idx,
//				(cchar *)(*iter).exprText(0)
//			)	;
		}

		return	;
	}

	KBItem	*item = new KBLinkDummy
			(	this,
				"__show_0",
				m_show.getValue().stripWhiteSpace()
			)	;

	m_iShow .append  (item)	   ;
	m_query->addItem (0, item) ;
}

/*  KBLink								*/
/*  makeCtrl	: Make a link control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: Associated control			*/

KBControl
	*KBLink::makeCtrl
	(	uint		drow
	)
{
	if (getRoot()->isReport() != 0)
		return	new KBCtrlRepLink (getDisplay(), this, drow) ;

	return	new KBCtrlLink (getDisplay(), this, drow) ;
}

/*  KBLink								*/
/*  checkValid	: Check whether value can be saved in database		*/
/*  idx		: uint		: Value set index			*/
/*  alowNull	: bool		: Ignore not-null check			*/
/*  (returns)	: bool		: True if OK				*/

bool	KBLink::checkValid
	(	uint		idx,
		bool		allowNull
	)
{
	if (!allowNull)
		if (!m_nullOK.getBoolValue () && (idx == 0))
		{
			setError
			(	KBError::Error,
				TR("Value must be selected from list"),
				QString::null,
				__ERRLOCN
			)	;
			return	false ;
		}

	return	true	;
}

/*  KBLink								*/
/*  loadValues	: Load keys and values					*/
/*  (returns)	: void		:					*/

void	KBLink::loadValues ()
{
	QStringList	*qsl;

	m_keyset.clear   () ;
	m_valset.clear   () ;

	qsl = new QStringList  ;
	qsl->append (m_nullval.getValue()) ;

	m_keyset.append  ("")  ;
	m_valset.append  (qsl) ;

	if (m_query->select (0, (KBValue *)0, QString::null, QString::null, QString::null))
	{
		for (uint row = 0 ; row < m_query->getNumRows(0) ; row += 1)
		{
			QString	key = m_query->getField(0, row, m_iKey->getQueryIdx()).getRawText() ;

			qsl = new QStringList ;

			LITER
			(	KBItem,
				m_iShow,
				item,

				/* FIX: Including a null value in a	*/
				/* string list which is then loaded	*/
				/* into a combobox seems to terminate	*/
				/* the combo list at that entry.	*/
				QString	show = m_query->getField(0, row, item->getQueryIdx()).getRawText() ;
				if (show.isNull()) show = "" ;
				qsl->append (show) ;
			)

			m_keyset.append (key) ;
			m_valset.append (qsl) ;
		}
	}
	else	m_query->lastError().DISPLAY () ;
}

/*  KBLink								*/
/*  prepare	: Prepare link prior to display				*/
/*  (returns)	: void		:					*/

void	KBLink::prepare ()
{
	if (!m_loaded)
	{
		addDummyItems	() ;
		loadValues	() ;
		m_loaded = true	   ;
	}

	KBItem::prepare() ;
}

/*  KBLink								*/
/*  prepareCtrls: Prepare link prior to display				*/
/*  first	: uint		: First control requiring preparation	*/
/*  limit	: uint		: Limit of controls to prepare		*/
/*  (returns)	: void		:					*/

void	KBLink::prepareCtrls
	(	uint	first,
		uint	limit
	)
{
	for (uint idx = first ; idx < limit ; idx += 1)
		if (ctrls[idx] != 0)
			ctrls[idx]->setData ((void *)&m_valset) ;
}

/*  KBLink								*/
/*  itemToValue	: Map item number to value				*/
/*  item	: uint		: Item number				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBLink::itemToValue
	(	uint	item
	)
{
	return	item == 0 ?
			KBValue (type) :
			KBValue	(m_keyset[item], type) ;
}

/*  KBLink								*/
/*  valueToItem	: Map value to item number				*/
/*  value	: const KBValue &: Value to map				*/
/*  (returns)	: uint		 : Item number				*/

uint	KBLink::valueToItem
	(	const KBValue	&value
	)
{
	int	idx = m_keyset.findIndex (value.getRawText()) ;
	return	idx < 0 ? 0 : idx ;
}

/*  KBLink								*/
/*  valueToText	: Map value to display text				*/
/*  value	: const KBValue &: Value to map				*/
/*  (returns)	: QString	 : Display text				*/

QString	KBLink::valueToText
	(	const KBValue	&value
	)
{
	int	idx = m_keyset.findIndex (value.getRawText()) ;
	return	idx < 0 ? QString::null :
			  m_valset.at(idx)->join(" ") ;
}

/*  KBLink								*/
/*  userChange	: Selection changed notification			*/
/*  qrow	: uint		: Query row number			*/
/*  idx		: uint		: New selection index			*/
/*  (returns)	: void		:					*/

void	KBLink::userChange
	(	uint	qrow,
		uint	idx
	)
{
	KBValue	args[2]	;
	bool	evRc	;

	args[0] = (int)qrow		    ;
	args[1] = KBValue (m_keyset[idx])   ;
	eventHook (m_onChange, 2, args, evRc) ;

	KBItem::userChange (qrow) ;
}

/*  KBLink								*/
/*  getReportValue							*/
/*		: Get value for report writing				*/
/*  first	: bool		: First output flag			*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBLink::getReportValue
	(	bool
	)
{
	int	slot	;

	if ((slot = m_keyset.findIndex (curVal.getRawText())) >= 0)
		return	KBValue (m_valset.at(slot)->join(" ")) ;

	return	KBValue	() ;
}

/*  KBLink								*/
/*  getOrderType: Get ordering type					*/
/*  (returns)	: KB::IType	  : Ordering type			*/

KB::IType KBLink::getOrderType()
{
	return	KB::ITString	;
}

/*  KBLink								*/
/*  getOrderValue							*/
/*		: Get ordering value					*/
/*  value	: const KBValue & : Value				*/
/*  (returns)	: QString	  : Ordering value			*/

QString	KBLink::getOrderValue
	(	const KBValue	&value
	)
{
	return	valueToText (value) ;
}

/*  KBLink								*/
/*  isMorphing	: Test if field is morphed				*/
/*  (returns)	: bool		: Morphed				*/

bool	KBLink::isMorphing ()
{
	return	m_morph.getBoolValue() ;
}

/*  KBLink								*/
/*  getQuery	: Get associated query					*/
/*  (returns)	: KBQryBase *	: Associated query			*/

KBQryBase *KBLink::getQuery ()
{
	return	m_query	;
}

/*  KBLink								*/
/*  replicate	: Replicate this link					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New link node				*/

KBNode	*KBLink::replicate
	(	KBNode	*_parent
	)
{
	KBLink	*nLink	= new KBLink (_parent, this) ;
	if (m_query != 0)
		nLink->m_query = m_query->replicate (nLink)->isQryBase() ;
	return	nLink	;
}

/*  KBLink								*/
/*  doRefresh	: Possibly refresh selections				*/
/*  drow	: uint		: Display row to refresh		*/
/*  (returns)	: void		:					*/

void	KBLink::doRefresh
	(	uint		drow
	)
{
	loadValues () ;
	ctrls[drow]->setData ((void *)&m_valset) ;
}

/*  KBLink								*/
/*  doSearch	: Do record search					*/
/*  (returns)	: void		:					*/

void	KBLink::doSearch ()
{
	QStringList list ;

	for (uint idx = 0 ; idx < m_valset.count() ; idx += 1)
		list.append (m_valset.at(idx)->join(" ")) ;

	KBFindChoiceDlg findDlg (getFormBlock(), this, list, m_keyset) ;
	findDlg.exec () ;
}

/*  KBLink								*/
/*  showQuery	: Show associated query					*/
/*  (returns)	: void		:					*/

void	KBLink::showQuery ()
{
#if	! __KB_RUNTIME
	if (m_query != 0)
	{
		addDummyItems  () ;

		QString	sql	= m_query->getSQLText   (0, true) ;
		KBQryDisplay(sql, QString::null).exec() ;

		remDummyItems  () ;
	}
#endif
}

/*  KBLink								*/
/*  designPopup	: Display design menu					*/
/*  e		: QMouseEvent *	: Triggering mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBLink::designPopup
	(	QMouseEvent	*,
		uint
	)
{
#if	! __KB_RUNTIME
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("C&ut"),		this, SLOT(cutObj         ())) ;
	pop.insertItem (TR("&Copy"),		this, SLOT(copyObj        ())) ;
	pop.insertItem (TR("&Delete"),		this, SLOT(deleteObj      ())) ;
	pop.insertItem (TR("Save as component"),this, SLOT(saveAsComponent())) ;
	pop.insertItem (TR("&Properties"),	this, SLOT(propertyDlg    ())) ;
	pop.insertItem (TR("&Show query"),	this, SLOT(showQuery      ())) ;
	pop.exec       (QCursor::pos()) ;
#endif
}


#if	! __KB_RUNTIME
/*  KBLink								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBLink::propertyDlg ()
{
	if (!::linkPropDlg (this, "Link", attribs)) return false ;

	updateProps  ()	;
	addDummyItems() ;
	return	true	;
}
#endif

static	KBNode	*newLinkTable
	(	KBNode			*parent,
		const QDict<QString>	&aDict,
		bool			*ok
	)
{
	QDict<QString>	d2 (aDict  ) ;
	QString		lt ("table") ;

	d2.insert ("linktype", &lt)   ;
	return	new KBLink (parent, d2, ok) ;
}

static	KBNode	*newLinkQuery
	(	KBNode			*parent,
		const QDict<QString>	&aDict,
		bool			*ok
	)
{
	QDict<QString>	d2 (aDict  ) ;
	QString		lt ("query") ;

	d2.insert ("linktype", &lt)   ;
	return	new KBLink (parent, d2, ok) ;
}

static	KBNode	*newLinkSQL
	(	KBNode			*parent,
		const QDict<QString>	&aDict,
		bool			*ok
	)
{
	QDict<QString>	d2 (aDict ) ;
	QString		lt ("sql" ) ;

	d2.insert ("linktype", &lt)   ;
	return	new KBLink (parent, d2, ok) ;
}



/*  ------------------------------------------------------------------  */

/*  The following code is used to generate the "New Link" popup menu,	*/
/*  which allows the insertion of links based on Queries (both Rekall	*/
/*  and SQL) as well as tables.						*/

static	NodeSpec nodeSpecTable =
{	
	0,
	QString::null,
	0,
	newLinkTable,
	KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA
}	;

static	NodeSpec nodeSpecQuery =
{	
	0,
	QString::null,
	0,
	newLinkQuery,
	KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA
}	;

static	NodeSpec nodeSpecSQL   =
{	
	0,
	QString::null,
	0,
	newLinkSQL,
	KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA
}	;


/*  makeLinkPopup: Make new link popp menu				*/
/*  popup	 : QPopupMenu *	: Popup menu				*/
/*  receiver	 : QObject *	: Reciever for popup menu signals	*/
/*  (returns)	 : void		:					*/

static	void	makeLinkPopup
	(	QPopupMenu	*popup,
		QObject		*receiver
	)
{
	QPopupMenu *lp = new QPopupMenu (popup) ;

	lp->insertItem
	(	TR("Table link"),
		receiver,
		SLOT(newNode(int)),
		0,
		(int)&nodeSpecTable
	)	;
	lp->insertItem
	(	TR("Query link"),
		receiver,
		SLOT(newNode(int)),
		0,
		(int)&nodeSpecQuery
	)	;
	lp->insertItem
	(	TR("SQL link"  ),
		receiver,
		SLOT(newNode(int)),
		0,
		(int)&nodeSpecSQL
	) 	;

	popup->insertItem (TR("New &Link"), lp) ;
}

NEWNODE(Link, makeLinkPopup, KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA)
