/***************************************************************************
    file	         : kb_paramdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_paramdlg.moc"
#else
#include 	"kb_paramdlg.h"
#endif

#include	"kb_node.h"
#include	"kb_param.h"
#include	"kb_helper.h"


/*  KBParamItem								*/
/*  KBParamItem	: Constructor for parameter dialog parameter item	*/
/*  listView	: QListView *	: Parent list view			*/
/*  param	: KBParam *	: Extant parameter			*/
/*  (returns)	: KBParamItem	:					*/

KBParamItem::KBParamItem
	(	QListView	*listView,
		KBParam		*param
	)
	:
	QListViewItem
	(	listView,
		param->getName  (),
		param->getDefval(),
		param->getLegend()
	),
	m_param		(param)
{
	m_format	= param->getFormat() ;
	m_prompt	= param->getPrompt() ;
}

/*  KBParamItem								*/
/*  KBParamItem	: Constructor for parameter dialog parameter item	*/
/*  listView	: QListView *	  : Parent list view			*/
/*  name	: const QString & : Parameter name			*/
/*  defval	: const QString & : Default value			*/
/*  legend	: const QString & : Prompt legend			*/
/*  format	: const QString & : Format setting			*/
/*  prompt	: bool		  : Prompt always			*/
/*  (returns)	: KBParamItem	  :					*/

KBParamItem::KBParamItem
	(	QListView		*listView,
		const QString		&name,
		const QString		&defval,
		const QString		&legend,
		const QString		&format,
		bool			prompt
	)
	:
	QListViewItem	(listView, name, defval, legend),
	m_param		(0)
{
	m_format	= format	;
	m_prompt	= prompt	;
}

/*  KBParamItem								*/
/*  KBParamItem~: Destructor for parameter dialog parameter item	*/
/*  (returns)	:		:					*/

KBParamItem::~KBParamItem ()
{
}

/*  KBParamItem								*/
/*  fixup	: Fix up value on accept				*/
/*  node	: KBNode *	: Parent node				*/
/*  (returns)	: void		:					*/

void	KBParamItem::fixUp
	(	KBNode	*node
	)
{
	if ((m_param == 0) && (node != 0))
		m_param = new KBParam
			  (	node,
				text(0),
				text(1),
				text(2),
				m_format,
				m_prompt
			  ) ;
}


/*  ------------------------------------------------------------------  */

/*  KBParamDlg								*/
/*  KBParamDlg	: Constructor for parameter dialog			*/
/*  parent	: QWidget *	   : Parent widget			*/
/*  node	: KBNode *	   : Owning node			*/
/*  params	: QList<KBParam> & : List of parameter nodes		*/
/*  (returns)	: KBParamDlg	   :					*/

KBParamDlg::KBParamDlg
	(	QWidget		*parent,
		KBNode		*node,
		QList<KBParam>	&params
	)
	:
	QWidget		(parent),
	m_node		(node),
	m_layMain	(this),
	m_laySettings	(&m_layMain),
	m_lName		(this),
	m_lDefval	(this),
	m_lLegend	(this),
	m_lFormat	(this),
	m_lPrompt	(this),
	m_eName		(this),
	m_eDefval	(this),
	m_eLegend	(this),
	m_eFormat	(this),
	m_bFormat	(this),
	m_ePrompt	(this),
	m_bAdd		(this),
	m_bRemove	(this),
	m_bEdit		(this),
	m_lvParams	(this)
{
	init	() ;

	LITER
	(	KBParam,
		params,
		p,
		new KBParamItem (&m_lvParams, p)
	)
}

/*  KBParamDlg								*/
/*  KBParamDlg	: Constructor for parameter dialog			*/
/*  parent	: QWidget *	   	: Parent widget			*/
/*  params	: QDict<KBParamSet> &	: List of parameter nodes	*/
/*  (returns)	: KBParamDlg	   	:				*/

KBParamDlg::KBParamDlg
	(	QWidget			*parent,
		const QDict<KBParamSet>	&params
	)
	:
	QWidget		(parent),
	m_node		(0),
	m_layMain	(this),
	m_laySettings	(&m_layMain),
	m_lName		(this),
	m_lDefval	(this),
	m_lLegend	(this),
	m_lFormat	(this),
	m_lPrompt	(this),
	m_eName		(this),
	m_eDefval	(this),
	m_eLegend	(this),
	m_eFormat	(this),
	m_bFormat	(this),
	m_ePrompt	(this),
	m_bAdd		(this),
	m_bRemove	(this),
	m_bEdit		(this),
	m_lvParams	(this)
{
	init	() ;

	QDictIterator<KBParamSet> iter (params) ;
	const KBParamSet *param ;

	while ((param = iter.current()) != 0)
	{
		new KBParamItem
		(	&m_lvParams,
			iter.currentKey(),
			param->m_defval,
			param->m_legend,
			param->m_format,
			param->m_prompt
		)	;

		iter += 1 ;
	}
}

/*  KBParamDlg								*/
/*  init	: Initialise						*/
/*  (returns)	: void		:					*/

void	KBParamDlg::init ()
{
	m_lName     .setText	(TR("Name"	)) ;
	m_lDefval   .setText	(TR("Default"	)) ;
	m_lLegend   .setText	(TR("Legend"	)) ;
	m_lFormat   .setText	(TR("Format"	)) ;
	m_lPrompt   .setText	(TR("Prompt"	)) ; 
	m_bAdd	    .setText	(TR("Add"   	)) ;
	m_bRemove   .setText	(TR("Remove"	)) ;
	m_bEdit	    .setText	(TR("Edit"	)) ;
	m_bFormat   .setText	(TR("..."	)) ;
	m_bRemove   .setEnabled	(false	  ) ;
	m_bEdit     .setEnabled	(false	  ) ;
	m_eFormat   .setEnabled	(false	  ) ;

#if	__KB_EMBEDDED
	m_lvParams   .addColumn	(TR("Name"   ),  50) ;
	m_lvParams   .addColumn	(TR("Default"),  50) ;
	m_lvParams   .addColumn	(TR("Legend" ), 120) ;
#else
	m_lvParams   .addColumn	(TR("Name"   ),  80) ;
	m_lvParams   .addColumn	(TR("Default"), 120) ;
	m_lvParams   .addColumn	(TR("Legend" ), 200) ;
#endif

	m_laySettings.addMultiCellWidget (&m_lName,   	0, 0, 0, 0) ;
	m_laySettings.addMultiCellWidget (&m_eName,   	0, 0, 1, 4) ;
	m_laySettings.addMultiCellWidget (&m_bAdd,    	0, 0, 4, 5) ;
	m_laySettings.addMultiCellWidget (&m_lDefval, 	1, 1, 0, 0) ;
	m_laySettings.addMultiCellWidget (&m_eDefval, 	1, 1, 1, 4) ;
	m_laySettings.addMultiCellWidget (&m_bEdit,   	1, 1, 4, 5) ;
	m_laySettings.addMultiCellWidget (&m_lLegend, 	2, 2, 0, 0) ;
	m_laySettings.addMultiCellWidget (&m_eLegend, 	2, 2, 1, 4) ;
	m_laySettings.addMultiCellWidget (&m_bRemove, 	2, 2, 4, 5) ;
	m_laySettings.addMultiCellWidget (&m_lFormat,	3, 3, 0, 0) ;
	m_laySettings.addMultiCellWidget (&m_eFormat,	3, 3, 1, 1) ;
	m_laySettings.addMultiCellWidget (&m_bFormat,	3, 3, 2, 2) ;
	m_laySettings.addMultiCellWidget (&m_lPrompt,	3, 3, 3, 3) ;
	m_laySettings.addMultiCellWidget (&m_ePrompt,	3, 3, 4, 4) ;

	m_layMain    .addWidget (&m_lvParams) ;

	m_bFormat.setFixedSize (m_bFormat.sizeHint()) ;

	_KBDialog::setupLayout (this, -1, -1) ;

	connect	(&m_bAdd,     SIGNAL(clicked()), SLOT(clickAdd   ())) ;
	connect	(&m_bRemove,  SIGNAL(clicked()), SLOT(clickRemove())) ;
	connect	(&m_bEdit,    SIGNAL(clicked()), SLOT(clickEdit  ())) ;
	connect	(&m_bFormat,  SIGNAL(clicked()), SLOT(clickFormat())) ;

	connect (&m_lvParams, SIGNAL(selectionChanged(QListViewItem *)),
		 	      SLOT  (selectionChanged(QListViewItem *))) ;

	connect (&m_lvParams, SIGNAL(doubleClicked   (QListViewItem *)),
		 	      SLOT  (clickEdit	     ())) ;
	connect (&m_lvParams, SIGNAL(returnPressed   (QListViewItem *)),
		 	      SLOT  (clickEdit	     ())) ;
	m_curItem = 0 ;
}

/*  KBParamDlg								*/
/*  getText	: Get text to display in properties dialog		*/
/*  (returns)	: QString	: Text					*/

QString	KBParamDlg::getText ()
{
	QString	res	;
	QListViewItem	*item	= m_lvParams.firstChild() ;

	while (item != 0)
	{
		if (!res.isEmpty()) res += ", " ;

		res += item->text       (0) ;
		item = item->nextSibling()  ;
	}

	return	res	;
}

/*  KBParamDlg								*/
/*  getValues	: Get result values as strings				*/
/*  params	: QDict<KBParamSet> &	: Result set			*/
/*  (returns)	: void			:				*/

void	KBParamDlg::getValues
	(	QDict<KBParamSet>	&params
	)
{
	params.clear ()	;

	KBParamItem *item = (KBParamItem *)m_lvParams.firstChild() ;
	while (item != 0)
	{
		params.insert
		(	item->text(0),
			new KBParamSet
			(	item->text	(2),
				item->text	(1),
				QString::null,
				item->getFormat	(),
				item->getPrompt	()
			)
		)	;
		item = (KBParamItem *)item->nextSibling()  ;
	}
}

/*  KBParamDlg								*/
/*  fixUp	: Fix up on acceptance					*/
/*  (returns)	: void		:					*/

void	KBParamDlg::fixUp ()
{
	LITER (KBParam, m_dropped, p, delete p) ;

	QListViewItem	*item	= m_lvParams.firstChild() ;
	while (item != 0)
	{
		((KBParamItem *)item)->fixUp (m_node) ;
		item = item->nextSibling()  ;
	}
}

/*  KBParamDlg								*/
/*  clickAdd	: User clicks add button				*/
/*  (returns)	: void		:					*/

void	KBParamDlg::clickAdd ()
{
	if (!m_eName.text().isEmpty())
	{
		KBParamItem *item = new KBParamItem
				    (	&m_lvParams,
					m_eName  .text(),
					m_eDefval.text(),
					m_eLegend.text(),
					m_eFormat.text(),
					m_ePrompt.isChecked()
				    ) 	;
		m_lvParams  .setCurrentItem (item) ;
		m_eName     .clear () ;
		m_eDefval   .clear () ;
		m_eLegend   .clear () ;
		m_eFormat   .clear () ;
		m_ePrompt   .setChecked	    (false) ;
	}
}

/*  KBParamDlg								*/
/*  clickFormat	: User clicks format button				*/
/*  (returns)	: void		:					*/

void	KBParamDlg::clickFormat ()
{
	QString	result	= KBHelperDlg::run
			  (	"format",
				m_eFormat.text(),
				KBLocation()
			  )	;

	if (!result.isNull()) m_eFormat.setText (result) ;
}

/*  KBParamDlg								*/
/*  clickRemove	: User clicks remove button				*/
/*  (returns)	: void		:					*/

void	KBParamDlg::clickRemove ()
{
	if (m_curItem != 0)
	{
		KBParam *param = m_curItem->getParam() ;
		if (param != 0) m_dropped.append (param) ;
		DELOBJ	(m_curItem) ;
	}
}

/*  KBParamDlg								*/
/*  clickEdit	: User clicks edit button				*/
/*  (returns)	: void		:					*/

void	KBParamDlg::clickEdit ()
{
	if (m_curItem != 0)
	{
		QString	format	= m_curItem->getFormat() ;
		bool	prompt	= m_curItem->getPrompt() ;

		m_eName  	.setText 	(m_curItem->text (0)) ;
		m_eDefval	.setText 	(m_curItem->text (1)) ;
		m_eLegend	.setText	(m_curItem->text (2)) ;
		m_eFormat	.setText	(format) ;
		m_ePrompt	.setChecked	(prompt) ;

		KBParam *param = m_curItem->getParam  () ;
		if (param != 0) m_dropped.append (param) ;
		DELOBJ	(m_curItem) ;
	}
}

/*  KBParamDlg								*/
/*  selectionChanged							*/
/*		: Current item selection changes			*/
/*  item	: QListViewItem * : Newly selected item			*/
/*  (returns)	: void		  :					*/

void	KBParamDlg::selectionChanged
	(	QListViewItem	*item
	)
{
	m_curItem = (KBParamItem *)item	   ;
	m_bRemove .setEnabled  (item != 0) ;
	m_bEdit   .setEnabled  (item != 0) ;
}


/*  ------------------------------------------------------------------  */

/*  KBParamDefDlg							*/
/*  KBParamDefDlg: Parameter setup dialog				*/
/*  params	 : QDict<KBParamSet> &	: Parameter setup dictionary	*/
/*  (returns)	 : KBParamDefDlg	:				*/

KBParamDesignDlg::KBParamDesignDlg
	(	const QDict<KBParamSet>	&params
	)
	:
	_KBDialog	("Set Parameters", true),
	m_paramDlg	(this, params),
	m_bOK		(this),
	m_bCancel	(this)
{
	m_layMain	= new QVBoxLayout (this) ;
	m_layMain  ->addWidget (&m_paramDlg) ;

	m_layButton	= new QHBoxLayout (m_layMain) ;
	m_layButton->addStretch () ;
	m_layButton->addWidget  (&m_bOK    )	;
	m_layButton->addWidget  (&m_bCancel)	;

	m_bOK	    .setText	(TR("OK"    ))	;
	m_bCancel   .setText	(TR("Cancel"))	;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
}

void	KBParamDesignDlg::clickOK ()
{
	done	(true) ;
}

void	KBParamDesignDlg::clickCancel ()
{
	done	(false) ;
}


/*  ------------------------------------------------------------------  */

