/***************************************************************************
    file	         : kb_qrydata.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYDATA_H
#define	 _KB_QRYDATA_H


#include 	"kb_qrybase.h"
#include	"kb_dialog.h"

#include	<qtextview.h>
#include	<qpushbutton.h>

#include	"libkbase_exports.h"

class	LIBKBASE_API	KBQryDisplay : public _KBDialog
{
	Q_OBJECT

	QTextView	m_query		;
	QTextView	m_reason	;
	QPushButton	m_bOK		;
	QVBoxLayout	*m_layMain	;
	QHBoxLayout	*m_layButt	;

protected slots :

	void		clickOK ()	;
public	:

	KBQryDisplay	(const QString &, const QString &) ;
}	;


/*  KBQryData								*/
/*  -----------								*/
/*  Class used for data queries, ie., those that access either a table	*/
/*  directly, or through a KBase-level query				*/

class	LIBKBASE_API	KBQryData : public KBQryBase
{
	Q_OBJECT

protected :

	QList<KBQryLevel>	qryLevels	;
	bool			wLError		;

	QString			svrName		;
	QList<KBTable>		tabList		;

	KBQryLevel	*getQryLevel	(uint)	;
	virtual	bool	loadQuery	()	= 0 ;

public	:

	KBQryData	(KBNode *, const QDict<QString> &, cchar *) ;
	KBQryData	(KBNode *, KBQryData *) ;
	KBQryData	(KBNode *, cchar     *) ;

virtual~KBQryData	() ;

	virtual	KBQryData 	*isQryData  	() { return this ; }


	virtual	bool		addItem      	(uint, KBItem  *) ;
	virtual	void		remItem      	(uint, KBItem  *) ;
	virtual	bool		loadItems    	(uint, uint)      ;
	virtual	bool		clearItems    	(uint, uint)      ;
	virtual	void		resetData	(uint, uint)      ;

	virtual	bool		getSelect	(uint, KBSelect &);

	virtual	bool		select       	(uint, KBValue *,
						    const QString &,
						    const QString &,
						    const QString &,
						    bool = false, uint = 0) ;

	virtual	bool		startUpdate	(uint, uint, Locking) ;
	virtual	bool		endUpdate	(uint, bool) ;
	virtual	KBQryBase::Locking
				lockingState	(uint)	     ;

	virtual	bool		saveRow      	(uint, uint) ;
	virtual	bool		deleteRow    	(uint, uint) ;
	virtual	bool		insertRow    	(uint, uint) ;
	virtual	bool		syncRow	     	(uint, uint, KBValue *, const QString &, KBBlock *, KB::Action &, KBValue &) ;
	virtual	bool		syncAll	     	(uint,	  KBValue *, const QString &, KBBlock *) ;

	virtual	bool		newRowEmpty  	(uint, uint)	;
	virtual	bool		rowIsDirty   	(uint, uint, bool) ;
	virtual	KB::RState	getRowState  	(uint, uint)	;
	virtual	KBValue		getField     	(uint, uint, uint, bool  = false  ) ;
	virtual	void		setField     	(uint, uint, uint, const KBValue &) ;
	virtual uint		getNumRows   	(uint)		;
	virtual	uint		setCurrentRow	(uint, uint)	;
	virtual	uint		getWidth	(uint, uint)	;
	virtual	uint		getPermission	(uint)		;
	virtual	void		sortByColumn 	(uint, uint, bool, KBItem *) ;

	virtual	bool		getFieldList 	(uint, QList<KBFieldSpec> &, int &) ;
	virtual void		setRowMarked	(uint, uint, KB::MarkOp) ;
	virtual bool		getRowMarked	(uint, uint)	;
	virtual	bool		deleteAllMarked	(uint, uint &)	;

	virtual	QString		getSQLText	(uint, bool)	;
	virtual	QString		getSQLReason	(uint)		;
}	;

#endif	// _KB_QRYDATA_H
