/***************************************************************************
    file	         : kb_qrytabledlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QRYTABLEDLG_H
#define	_KB_QRYTABLEDLG_H

#if	! __KB_RUNTIME

#include	"kb_qrytabledlg.h"
#include	"kb_propdlg.h"
#include	"kb_table.h"

#include	"libkbase_exports.h"

class	KBPrimaryDlg	;

class	LIBKBASE_API	KBAttrPrimaryItem : public KBAttrItem
{
	KBAttr			*m_uTypeAttr	;
	KBAttr			*m_uExprAttr	;
	KBTable::UniqueType	m_utype		;
	QString			m_uexpr		;

public	:

	KBAttrPrimaryItem		(KBAttr  *) ;
	virtual ~KBAttrPrimaryItem	()	;

	void			setType	(KBAttr	 *, KBAttr *) ;
	void			setType	(KBTable::UniqueType, const QString &) ;
	KBTable::UniqueType	getType	(QString &) ;

	virtual	QString	displayValue	() ;
	virtual	void	save		() ;
}	;


/*  KBQryTablePropDlg							*/
/*  -----------------							*/
/*  Wrapper class for table query properties dialog. Handles special-	*/
/*  case properties.							*/

class 	LIBKBASE_API	KBQryTablePropDlg : public KBPropDlg
{
	KBPrimaryDlg	*m_primaryDlg	;
	KBQryData	*m_query  	;
	KBTableSpec	m_tabSpec	;

	KBAttrPrimaryItem
			*m_primaryItem	;
	KBAttr		*m_ptypeAttr	;
	KBAttr		*m_pexprAttr	;

	bool		m_warn	  	;

	bool		getTableSpec	() ;
	void		findPrimary	() ;
	bool		checkPrimary	(const QString &) ;

protected :

	virtual	void	clickOK		() ;

	virtual	bool	hideProperty	(KBAttr     *) ;
	virtual	bool	showProperty	(KBAttrItem *) ;
	virtual	bool	saveProperty	(KBAttrItem *) ;
	virtual	void	preExec		() ;

	virtual KBAttrItem
			*getAttrItem	(KBAttr *) ;

public	:

	KBQryTablePropDlg (KBQryData *, cchar *, QList<KBAttr> &) ;
       ~KBQryTablePropDlg () ;
}	;

#endif
#endif	// _KB_QRYTABLEDLG_H
