/***************************************************************************
    file	         : kb_qtchoice.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef 	_WIN32
#include	"kb_qtchoice.moc"
#else
#include	"kb_qtchoice.h"
#endif

#include	"kb_choice.h"
#include	"kb_display.h"
#include	"kb_block.h"


/*  KBCtrlChoice								*/
/*  KBCtrlChoice: Constructor for choice combo box wrapper		*/
/*  display	: KBDisplay *	: Parent display			*/
/*  choice	: KBChoice *	: Parent choice item			*/
/*  drow	: uint		: Row number in field			*/
/*  (returns)	: KBCtrlChoice	:					*/

KBCtrlChoice::KBCtrlChoice
	(	KBDisplay	*display,
		KBChoice	*choice,
		uint		drow
	)
	:
	KBComboBox (display->getDisplayWidget()),
	KBControl  (this, display, choice, drow),
	m_choice   (choice)
{
	connect	   (this, SIGNAL(activated(int)), this, SLOT(slotChanged())) ;

	setInsertionPolicy (NoInsertion) ;

	m_inSetValue = false ;
}

/*  KBCtrlChoice								*/
/*  ~KBCtrlChoice: Destructor for choice class				*/
/*  (returns)	 :		:					*/

KBCtrlChoice::~KBCtrlChoice ()
{
}

/*  KBCtrlChoice							*/
/*  setData	: Set value set						*/
/*  _valset	: void *	:					*/
/*  (returns)	: void		:					*/

void	KBCtrlChoice::setData
	(	void	*
	)
{
	CHOICE_NOCHANGE
	(
	clear		 () ;
	insertStringList (m_choice->getValues()) ;
	)
}

/*  KBCtrlChoice							*/
/*  slotChanged	: Selection changed notification			*/
/*  (returns)	: void		:					*/

void	KBCtrlChoice::slotChanged ()
{
	if (!m_inSetValue && startUpdate())
		m_choice->userChange
		(	m_choice->getBlock()->getCurDRow() + m_drow,
			currentText()
		)	;
}

/*  KBCtrlChoice								*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlChoice::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
	{	clear	   () ;
		insertItem (m_choice->getName()) ;
	}
#endif
}

/*  KBCtrlChoice							*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlChoice::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	CHOICE_NOCHANGE
	(
	clear	() ;
	)

	redraw	() ;

#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (m_drow == 0))
	{
		showName () ;
		return	    ;
	}
#endif

	if (m_showing == KB::ShowAsData)
	{
		CHOICE_NOCHANGE
		(
		insertStringList (m_choice->getValues()) ;
		)

		if (lineEdit() != 0)
		{
			disconnect
			(	lineEdit(),
				SIGNAL(textChanged(const QString &)),
				this,
				SLOT  (slotChanged())
			)	;
			connect
			(	lineEdit(),
				SIGNAL(textChanged(const QString &)),
				this,
				SLOT  (slotChanged())
			)	;
		}
	}
}

/*  KBCtrlChoice							*/
/*  setValue	: Set value						*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlChoice::setValue
	(	const KBValue	&value
	)
{
	QString	v	  = value.getRawText() ;
	int	slot	  = m_choice->getValues().findIndex(v) ;

	if (slot < 0)
	{
		for (int p = v.length() - 1 ; p >= 0 ; p -= 1)
			if (v.at(p) != QChar(' '))
			{
				v = v.left (p + 1) ;
				break	;
			}

		slot	  = m_choice->getValues().findIndex(v) ;

		fprintf
		(	stderr,
			"KBCtrlChoice::setValue: retry [%s]->[%s]->[%d]\n",
			(cchar *)value.getRawText(),
			(cchar *)v,
			slot
		)	;
	}

	CHOICE_NOCHANGE
	(
		if ((slot >= 0) && m_choice->canEdit ())
			setEditText    (v) ;
		else	setCurrentItem (slot < 0 ? 0 : slot) ;
	)

	KBControl::setValue (value) 	;
}

/*  KBCtrlChoice							*/
/*  getValue	: Get value						*/
/*  (returns)	: KBValue 	: Value					*/

KBValue	KBCtrlChoice::getValue ()
{
	/* If the control is empty and the initial value was null (as	*/
	/* opposed to an empty string), then return a null string.	*/
	if (currentText().isEmpty() && getIniValue().isNull())
		return	KBValue (m_choice->getFieldType()) ;

	return	KBValue (currentText(), m_choice->getFieldType()) ;
}

/*  KBCtrlChoice							*/
/*  clearValue	: Clear value						*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: KBValue 	: Value					*/

void	KBCtrlChoice::clearValue
	(	bool	
	)
{
	setCurrentItem (0) ;
}

/*  KBCtrlChoice							*/
/*  changed	: See if field has changed				*/
/*  (returns)	: bool 		: Changed				*/

bool	KBCtrlChoice::changed ()
{
	/* Special case: This handles the situation where the inital	*/
	/* value is null, otherwise we get empty != null.		*/
	if (currentText().isEmpty() && getIniValue().getRawText().isEmpty())
		return false ;

	return	currentText() != getIniValue().getRawText() ;
}

/*  KBCtrlChoice							*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlChoice::isEmpty ()
{
	return	currentText().isEmpty() ;
}

/*  KBCtrlChoice								*/
/*  isValid	: See if control is valid				*/
/*  allowNull	: bool		: True to ignore not-null check		*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlChoice::isValid
	(	bool		allowNull
	)
{
	if (!m_choice->checkValid (currentText(), allowNull))
	{
		setError (m_choice->lastError()) ;
		return	false	;
	}

	return	true	;
}

/*  KBCtrlChoice								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlChoice::giveFocus ()
{
	QComboBox::setFocus () ;
}

/*  KBCtrlChoice							*/
/*  morphText	: Get text for morphed control				*/
/*  (returns)	: QString	: Text					*/

QString	KBCtrlChoice::morphText ()
{
	return	currentText () ;
}

/*  KBCtrlChoice								*/
/*  redraw	: Update to match design state				*/
/*  (returns)	: void		:					*/

void	KBCtrlChoice::redraw ()
{
	setReadOnly ((m_showing == KB::ShowAsData) && m_choice->isReadOnly()) ;
	setEditable ((m_showing == KB::ShowAsData) && m_choice->canEdit   ()) ;
}
