/***************************************************************************
    file	         : kb_recordnav.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_recordnav.moc"
#else
#include	"kb_recordnav.h"
#endif

#include	"tk_icons.h"


#if	__KB_EMBEDDED
#define	NAVWIDTH	60
#define	NAVFORMAT	TR("%1 of %2")
#else
#define	NAVWIDTH	120
#define	NAVFORMAT	TR("Record %1 of %2")
#endif

/*  KBRecordNav								*/
/*  KBRecordNav	: Record navigation tool constructor			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  d		: uint		: Dimension				*/
/*  (returns)	: KBRecordNav	:					*/

KBRecordNav::KBRecordNav
	(	QWidget		*parent,
		uint		d
	)
	:
	QFrame		(parent),
	m_bFirst	(this),
	m_bPrevious	(this),
	m_lRecordNo	(this),
	m_bNext		(this),
	m_bLast		(this),
	m_bAdd		(this)
{
	m_bFirst	.setGeometry (   	     0, 0,  	  d, d) ;
	m_bPrevious	.setGeometry (	  	     d, 0,   	  d, d) ;
	m_lRecordNo	.setGeometry (      	 2 * d, 0, NAVWIDTH, d) ;
	m_bNext		.setGeometry (NAVWIDTH + 2 * d, 0,   	  d, d) ;
	m_bLast		.setGeometry (NAVWIDTH + 3 * d, 0,   	  d, d) ;
	m_bAdd		.setGeometry (NAVWIDTH + 4 * d, 0,   	  d, d) ;

	m_bFirst	.setIconSet  (QIconSet (getSmallIcon ("mini_first"))) ;
	m_bPrevious	.setIconSet  (QIconSet (getSmallIcon ("mini_prev" ))) ;
	m_bNext		.setIconSet  (QIconSet (getSmallIcon ("mini_next" ))) ;
	m_bLast		.setIconSet  (QIconSet (getSmallIcon ("mini_last" ))) ;
	m_bAdd		.setIconSet  (QIconSet (getSmallIcon ("mini_add"  ))) ;

	setFixedSize	(NAVWIDTH + 5 * d, d) ;

	m_lRecordNo	.setFrameStyle	(QFrame::Box|QFrame::Plain) ;
	m_lRecordNo	.setLineWidth	(1) ;

	connect	(&m_bFirst,	SIGNAL(clicked()), SLOT(slotClickFirst	 ())) ;
	connect	(&m_bPrevious,	SIGNAL(clicked()), SLOT(slotClickPrevious())) ;
	connect	(&m_bNext,	SIGNAL(clicked()), SLOT(slotClickNext	 ())) ;
	connect	(&m_bLast,	SIGNAL(clicked()), SLOT(slotClickLast	 ())) ;
	connect	(&m_bAdd,	SIGNAL(clicked()), SLOT(slotClickAdd	 ())) ;
}

void	KBRecordNav::slotClickFirst ()
{
	emit	action	(KB::First) ;
}

void	KBRecordNav::slotClickPrevious ()
{
	emit	action	(KB::Previous) ;
}

void	KBRecordNav::slotClickNext ()
{
	emit	action	(KB::Next) ;
}

void	KBRecordNav::slotClickLast ()
{
	emit	action	(KB::Last) ;
}

void	KBRecordNav::slotClickAdd ()
{
	emit	action	(KB::Add) ;
}

void	KBRecordNav::setRecord
	(	uint		curQRow,
		uint		totalRows
	)
{
	if (curQRow < totalRows)
		m_lRecordNo.setText
		(	QString	(NAVFORMAT)
				.arg(curQRow + 1)
				.arg(totalRows  )
		)	;
	else	m_lRecordNo.setText
		(	TR("New record")
		)	;

	m_bFirst	.setEnabled (curQRow > 0) ;
	m_bPrevious	.setEnabled (curQRow > 0) ;
	m_bNext		.setEnabled (curQRow <  totalRows) ;
	m_bLast		.setEnabled (curQRow != totalRows - 1) ;
}

