/***************************************************************************
    file	         : kb_reportdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_REPORTDLG_H
#define	_KB_REPORTDLG_H

#if	! __KB_RUNTIME

#include	"kb_propdlg.h"
#include	"kb_paramdlg.h"
#include	"kb_script.h"
#include	"kb_import.h"

#include	"libkbase_exports.h"

/*  KBReportPropDlg							*/
/*  -------------							*/
/*  Properties dialog for report top-level object, that is, those parts	*/
/*  of KBReport which are specific to KBReport and not contained in the	*/
/*  KBBlock base class.							*/

class LIBKBASE_API	KBReportPropDlg : public KBPropDlg
{
	Q_OBJECT

	KBScriptDlg	scriptDlg ;
	KBImportDlg	importDlg ;
	KBParamDlg	paramDlg  ;
	KBReport	*root	  ;
	QString		ibtype	  ;

	void	setModules ()	  ;

protected :

	virtual KBAttrItem
			*getAttrItem	(KBAttr *) ;

	virtual	bool	showProperty	(KBAttrItem *) ;
	virtual	bool	saveProperty	(KBAttrItem *) ;
	virtual	bool	hideProperty	(KBAttr *) ;
	virtual	void	preExec		() ;

protected slots :

	virtual	void	clickOK() ;

public	:

	KBReportPropDlg (KBReport *, cchar *, QList<KBAttr  > &,
					      QList<KBModule> &,
					      QList<KBModule> &,
					      QList<KBParam > &) ;
       ~KBReportPropDlg () ;
}	;

#endif
#endif	// _KB_REPORTDLG_H
