/***************************************************************************
    file	         : kb_tableinfodlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_TABLEINFODLG_H
#define	_KB_TABLEINFODLG_H

#if	! __KB_RUNTIME

#include	<qcombobox.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>


#include	"kb_classes.h"
#include	"kb_dbinfo.h"
#include	"kb_dialog.h"
#include	"kb_tableinfo.h"

class	KBTableInfoDlg : public _KBDialog
{
	Q_OBJECT

	KBDBInfo		*m_dbInfo	;
	const QString		&m_server	;
	KBTableInfoSet		*m_tableInfoSet	;

	QComboBox		m_tableList	;
	QListBox		m_columnList	;
	QListBox		m_uniqueList	;
	QPushButton		m_bAdd		;
	QPushButton		m_bRemove	;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;

	QVBoxLayout		*m_layMain	;
	QHBoxLayout		*m_layColumns	;
	QVBoxLayout		*m_layAddRem	;
	QHBoxLayout		*m_layOKCancel	;

	QDict<KBTableUniqueList>m_tableMap	;
	QString			m_currTable	;

	void		showTable	(const QString &) ;
	void		saveTable	(const QString &) ;

protected slots :

	void		pickTable	(const QString &) ;
	void		pickColumn	()	;
	void		pickUnique	()	;
	void		clickAdd	()	;
	void		clickRemove	()	;
	void		clickOK		()	;
	void		clickCancel	()	;

public	:

	KBTableInfoDlg	(KBDBInfo *, const QString &, KBTableInfoSet *) ;

	virtual	int	exec		()	;
}	;

#endif
#endif	// _KB_TABLEINFODLG_H
