/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#include "tktextaction.h"

TKEditorAction::TKEditorAction(ActionType action, int line, int column, int length, const QString &text)
: action(action), line(line), column(column), length(length), text(text)
{
}

TKEditorAction::~TKEditorAction()
{
}

TKEditorAction *TKEditorAction::replace(int line, int column, int length, const QString &s)
{
  return new TKEditorAction(Replace, line, column, length, s);
}

TKEditorAction *TKEditorAction::insert(int line, int column, const QString &s)
{
  return new TKEditorAction(Replace, line, column, 0, s);
}

TKEditorAction *TKEditorAction::remove(int line, int column, int length)
{
  return new TKEditorAction(Replace, line, column, length);
}
  
TKEditorAction *TKEditorAction::makeLine(int line)
{
  return new TKEditorAction(MakeLine, line);
}

TKEditorAction *TKEditorAction::removeLine(int line)
{
  return new TKEditorAction(RemoveLine, line);
}

TKEditorAction *TKEditorAction::insertLineBreak(int line, int column)
{
  return new TKEditorAction(InsertLineBreak, line, column);
}

TKEditorAction *TKEditorAction::removeLineBreak(int line)
{
  return new TKEditorAction(RemoveLineBreak, line);
}

TKEditorAction *TKEditorAction::fold(int line)
{
  return new TKEditorAction(Fold, line);
}

TKEditorActionGroup::TKEditorActionGroup()
{
  actions = new QPtrStack<TKEditorAction>;
  actions->setAutoDelete(true);
}

TKEditorActionGroup::~TKEditorActionGroup()
{
  delete actions;
}

void TKEditorActionGroup::setRedoCursor(int line, int column)
{
  redoLine = line;
  redoColumn = column;
}

void TKEditorActionGroup::setUndoCursor(int line, int column)
{
  undoLine = line;
  undoColumn = column;
}
