/***************************************************************************
    file	         : kb_wizdbtype.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"

#ifndef		_WIN32
#include	"kb_wizdbtype.moc"
#else
#include	"kb_wizdbtype.h"
#endif

class	KBDBTypeDriver : public QListBoxText, public KBDriverDetails
{
public	:

	inline	KBDBTypeDriver
		(	QComboBox		*parent,
			const KBDriverDetails	&details
		)
		:
		QListBoxText	(parent->listBox(), details.comment()),
		KBDriverDetails	(details)
	{
	}
	inline	KBDBTypeDriver
		(	QComboBox		*parent
		)
		:
		QListBoxText	(parent->listBox(), QString::null),
		KBDriverDetails	()
	{
	}
}	;


KBWizardCtrlDBType::KBWizardCtrlDBType
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	setWidget (m_dbType = new QComboBox (page)) ;

	page->setInfoCtrl (m_info = new QTextView (page)) ;

	loadTypes () ;

	connect
	(	m_dbType,
		SIGNAL(activated      (int)),
		SLOT  (ctrlChanged    ())
	)	;
	connect
	(	m_dbType,
		SIGNAL(activated      (int)),
		SLOT  (slotTypeChanged(int))
	)	;
}

KBWizardCtrlDBType::~KBWizardCtrlDBType ()
{
}

void	KBWizardCtrlDBType::setValue
	(	const QString	&value
	)
{
	for (int idx = 0 ; idx < m_dbType->count() ; idx += 1)
		if (m_dbType->text(idx) == value)
		{	m_dbType->setCurrentItem (idx) ;
			break	;
		}
}

/*  KBWizardCtrlDBType							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlDBType::value ()
{
	KBDBTypeDriver *t = (KBDBTypeDriver *)m_dbType->listBox()->item(m_dbType->currentItem()) ;
	return	t->tag () ;
}

void	KBWizardCtrlDBType::loadTypes ()
{
	KBDriverDetailsList	drvList	;
	KBError			error	;

	if (KBServer::listDrivers (drvList, error))
	{
		new KBDBTypeDriver (m_dbType) ;

		for (uint idx = 0 ; idx < drvList.count() ; idx += 1)
			new KBDBTypeDriver
			(	m_dbType,
				drvList[idx]
			)	;

	}
	else	error.DISPLAY () ;
}

QVariant KBWizardCtrlDBType::attribute
	 (	const QString 	&attr
	 )
{
	KBDBTypeDriver *t = (KBDBTypeDriver *)m_dbType->listBox()->item(m_dbType->currentItem()) ;

	if (attr == "flags")
		return	QVariant (t->flags()) ;

	return	QVariant() ;
}

void	KBWizardCtrlDBType::slotTypeChanged
	(	int		idx
	)
{
	KBDBTypeDriver *t = (KBDBTypeDriver *)m_dbType->listBox()->item(idx) ;
	m_info->setText (t->info()) ;
}

WIZARDCTRLREG(DBType)
