/***************************************************************************
    file	         : kb_wizonefield.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dblink.h"
#include	"kb_location.h"
#include	"kb_qryquery.h"


#include	"kb_wizsource.h"

#ifndef		_WIN32
#include	"kb_wizonefield.moc"
#else
#include	"kb_wizonefield.h"
#endif


/*  KBWizardCtrlOneField							*/
/*  KBWizardCtrlOneField							*/
/*		: Constructor for single column wizard control		*/
/*  page	: KBWizardPage *	 : Parent page			*/
/*  elem	: QDomElement  &	 : Definition element		*/
/*  (returns)	: KBWizardCtrlOneField :					*/

KBWizardCtrlOneField::KBWizardCtrlOneField
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	/* The "source" attribute should have the form "page.ctrl"	*/
	/* and names the control (which should actually be of class	*/
	/* "KBWizardCtrlDataSource") that specifies the source for the	*/
	/* fields.							*/
	m_sourceName	= elem.attribute  ("source") ;

	setWidget	(m_fields = new QComboBox (page)) ;
}

/*  KBWizardCtrlOneField							*/
/*  ~KBWizardCtrlOneField							*/
/*		: Destructor for data source wizard control		*/
/*  (returns)	:		:					*/

KBWizardCtrlOneField::~KBWizardCtrlOneField ()
{
}

/*  KBWizardCtrlOneField							*/
/*  pageShown	: Page containing control is shown			*/
/*  next	: bool		: Moving to next page			*/
/*  (returns)	: void		:					*/

void	KBWizardCtrlOneField::pageShown
	(	bool		next
	)
{
	/* Do nothing if moving backwards. The field list will not	*/
	/* have changed and this preserves the user selection.		*/
	if (!next) return ;

	KBWizard	*wizard	= page()->wizard() ;

	QStringList	source	= QStringList::split ('.', m_sourceName) ;
	KBWizardCtrl	*ctrl	= wizard->findCtrl   (source[0], source[1]) ;

	if (ctrl == 0)
	{
		KBError::EError
		(	TR("Cannot locate source control"),
			QString("Path '%1'").arg(m_sourceName),
			__ERRLOCN
		)	;
		return	;
	}

	m_fields->clear () ;

	KBWizardCtrlDataSource::Type type =
		(KBWizardCtrlDataSource::Type)ctrl->attribute("type").toUInt() ;


	/* First case is the source is a table, in which case query the	*/
	/* database to get a list of the columns in the table. Add	*/
	/* these to the source list.					*/
	if (type == KBWizardCtrlDataSource::Table)
	{
		KBTableSpec 	tabSpec (ctrl->value()) ;
		KBDBLink    	dbLink  ;

		if (!dbLink.connect (wizard->dbInfo(), wizard->server()))
		{	dbLink.lastError().DISPLAY() ;
			return	;
		}

		if (!dbLink.listFields (tabSpec))
		{	dbLink.lastError().DISPLAY() ;
			return	;
		}

		LITER
		(	KBFieldSpec,
			tabSpec.m_fldList,
			fldSpec,

			m_fields->insertItem (fldSpec->m_name)
		)
	}

	/* Second case is a query, in which case we need to load the	*/
	/* query definition and get the field list from that.		*/
	if (type == KBWizardCtrlDataSource::Query)
	{
		KBLocation	locn
				(	wizard->dbInfo(),
					"query",
					wizard->server(),
					ctrl  ->value ()
				)	;

		KBDummyRoot	dummy (locn) ;

		KBQryQuery *qry	 = new KBQryQuery (&dummy) ;

		if (!qry->loadQueryDef (locn))
		{
			qry->lastError().DISPLAY() ;
			return	;
		}

		QList<KBFieldSpec> fldList ;
		int		   pKey	   ;
		fldList.setAutoDelete (true) ;

		if (!qry->getFieldList (0, fldList, pKey))
		{
			qry->lastError().DISPLAY() ;
			return	;
		}

		LITER
		(	KBFieldSpec,
			fldList,
			fldSpec,

			m_fields->insertItem (fldSpec->m_name)
		)
	}
}

/*  KBWizardCtrlOneField							*/
/*  setValue	: Set data value					*/
/*  value	: const QString & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBWizardCtrlOneField::setValue
	(	const QString	&
	)
{
	/* Not used! Anyway, it is a bit meaningless since we'd need	*/
	/* the name *and* the type.					*/
}

/*  KBWizardCtrlOneField							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlOneField::value ()
{
	return	m_fields->currentText() ;
}


WIZARDCTRLREG(OneField)
