/***************************************************************************
    file	         : kb_tablebase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>
#include	<time.h>

#include	<qwidget.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_form.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_listitem.h"
#include	"kb_filelist.h"
#include	"kb_tablelist.h"
#include	"kb_tableviewer.h"

#include	"kb_objbase.h"
#include 	"libkbase_exports.h"
#ifndef		_WIN32
#include	"kb_tablebase.moc"
#else
#include	"kb_tablebase.h"
#endif

//#define	__KB_NINST
#include	"kb_nodereg.h"
//#undef	__KB_NINST
#include	"kb_parse.h"

/*  KBTableBase	:							*/
/*  KBTableBase	: Constructor for base object for tables			*/
/*  parent	: QObject *	: Parent object				*/
/*  (returns)	: KBTable	:					*/

KBTableBase::KBTableBase
	(	QObject	*parent
	)
	:
	KBObjBase (parent)
{
	m_viewer = 0	 ;
	m_create = false ;
}

/*  KBTableBase	:							*/
/*  ~KBTableBase: Destructor for base object for tables			*/
/*  (returns)	:		:					*/

KBTableBase::~KBTableBase ()
{
}

/*  KBTableBase	:							*/
/*  build	: Build an instance of an object			*/
/*  _location	: KBLocation &	  : Object location			*/
/*  _create	: bool		  : Creating a new object		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBTableBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&
	)
{
	setLocation  (location)	;
	m_create   = create	;
	return	   true	     	;
}

/*  KBTableBase	:							*/
/*  show	: Show form						*/
/*  showAs	: KB::ShowAs	  : Display mode			*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Startup result			*/

KB::ShowRC
	KBTableBase::show
	(	KB::ShowAs		showAs,
		const QDict<QString>	&,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&,
		QDict<QString>		*
	)
{
	if (m_viewer == 0)
	{
		bool	modal	= KBOptions::getTablesModal() ;

		m_viewer = new KBTableViewer
			   (		this,
					embed,
					modal
			   )  ;

		setPart	(m_viewer, modal) ;

		KB::ShowRC rc = m_viewer->startup (m_create, showAs, pError) ;

		if (rc == KB::ShowRCModal)
		{
			return	KB::ShowRCModal ;
		}

		if (rc != KB::ShowRCOK)
		{
			delete	m_viewer;
			return	rc	;
		}

		return	KB::ShowRCOK	;
	}

	m_viewer->widget()->setFocus() ;
	m_viewer->showAs(showAs) ;

	return	KB::ShowRCOK ;
}

void	KBTableBase::widgetClosing ()
{
}


KBFACTORYIMPL
(	KBTableFactory,
	tableview,
	"Rekall table viewer",
	"Plugin",
	"0",
	"7",
	"0"
)


QObject	*KBTableFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
#if	0
	static	bool	first	= true	;

	if (first)
	{
		extern	void	registerNode (cchar *, cchar *, MKNODE, uint) ;

		NEWNODE(QryDesign, 0, KF_FORM) 
		first	= false	;
	}
#endif
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBTableList ((QWidget *)parent, (KBDBInfo *)name) ;

	return	new	KBTableBase (parent) ;
}

const char	*KBTableFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
