/***************************************************************************
    file	         : tkc_pyeditor.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_TKC_PYEDITOR_H
#define	_TKC_PYEDITOR_H

#include	<qintdict.h>
#include	<qtabwidget.h>

#include	"tktextmanager.h"
#include	"tktexteditor.h"

#include	"tkc_pydebugwidget.h"
#include	"tkc_tkemapper.h"


/*  TKCPyEditor								*/
/*  -----------								*/
/*  This class is a wrapper round a QScintilla editor, to provide the	*/
/*  extra functionality needed to integrate the editor into the python	*/
/*  debugger.								*/
/*									*/
/*  NOTE: The interface numbers lines as does Pythin, ie., the first	*/
/*  line in the file is line one. These are mapped to Scintilla, where	*/
/*  numbering starts at line zero.					*/

class	TKCPyEditor : public TKTextEditor
{
	Q_OBJECT

	TKCTKEMapper		mapper		;
	TKCPyDebugWidget	*debug		;
	TKCPyCookie		*module		;
	QString			errText		;
	QValueList<int>		bptList		;
	int			curLineNo	;

private slots :

	void		onRightClick	(int, int, ButtonState) ;

public	:

	TKCPyEditor (QWidget *, TKCPyDebugWidget *, TKCPyCookie *) ;
       ~TKCPyEditor () ;

	void		showText	(const QString &) ;
	bool		save		(QString &, QString &) ;
	void		gotoLine	(uint)	;
	void		setCurrentLine	(uint)	;
	void		setBreakpoint	(uint)	;
	void		clearBreakpoint	(uint)	;
	uint		getCurrentLine	()	;

	inline	TKCPyCookie *getModule ()
	{
		return	module	;
	}
	inline	void	setErrText
		(	const QString	&_errText
		)
	{
		errText	= _errText	;
	}
	inline	const QString	&getErrText ()
	{
		return	errText	;
	}
}	;

#endif	// _TKC_PYEDITOR_H
