/***************************************************************************
    file	         : kb_pyscript.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PYSCRIPT_H
#define	_KB_PYSCRIPT_H

#include	"kb_python.h"

#include	"kb_classes.h"
#include	"kb_script.h"

/*  KBPYScriptCode							*/
/*  --------------							*/
/*  Python-specific class for precompiled inline code.			*/

class	KBPYScriptCode : public KBScriptCode
{
public	:

	PyObject	*pyFunc		;
	KBLocation	location	;

	KBPYScriptCode	(PyObject *, KBEvent *, KBLocation &) ;
	virtual	~KBPYScriptCode	() ;

	virtual	KBScript::ExeRC	execute
		(	KBNode		*,
			uint		,
			const KBValue	*,
			KBValue		&
		)	;

	virtual	KBScript::ExeRC	execute
		(	KBNode		*,
			KBNode		*,
			const QString	&,
			uint		,
			const KBValue	*,
			KBValue		&
		)	;
	virtual	void	setBreakpoints
		(	const QValueList<int>	&
		)	;
}	;

/*  KBPYScriptObject							*/
/*  ----------------							*/
/*  Local derived version of KBScriptObject, used to implement object	*/
/*  persistence.							*/

class	KBPYScriptObject : public KBScriptObject
{
	PyObject	*m_pyObject  ;

public	:

	KBPYScriptObject(PyObject *) ;
	virtual	~KBPYScriptObject () ;

	PyObject *object () ;
}	;

/*  KBPYScriptIF							*/
/*  ------------							*/
/*  This is the script interface object for the Python script module.	*/

class	KBPYScriptIF : public KBScriptIF
{
	Q_OBJECT


	PyObject	*compileText
		(	KBLocation		&,
			const QString		&,
			QString			&,
			QString			&,
			KBError			&
		) 	;

	KBScriptCode   *compileInline
		(	const QString		&,
			const QString		&,
			const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBEvent			*,
			KBError			&
		)	;

	PyObject*findFunction
		(	const QStringList	&,
			const QString		&
		)	;

public	:

	KBPYScriptIF () ;
	virtual	~KBPYScriptIF () ;

	bool	load
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&,
			bool			&
		)	;

	virtual	void		setApp  (KBNotifier *, KBCallback *) ;

	virtual	bool	compile
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&
		)	;

	virtual	KBScriptCode   *compileFunc
		(	const QString		&,
			const QString		&,
			const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBEvent			*,
			KBError			&
		)	;

	virtual	KBScriptCode   *compileExpr
		(	const QString		&,
			const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBError			&
		)	;

	virtual	bool	load
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&
		)	;

	virtual	KBScript::ExeRC	execute
		(	const QStringList	&,
			const QString		&,
			KBNode			*,
			uint,
			const KBValue		*,
			KBValue 		&
		)	;


	virtual	KBLocation	exeError	(QString &, uint &, QString &) ;

	virtual	bool		unlink		(KBLocation     &, KBError &) ;
	virtual	bool		rename		(KBLocation     &, const QString &, KBError &) ;

	virtual	void		editorInit	(TKTextEditor   *) ;
	virtual	KBDebug		*showDebug	(TKToggleAction *) ;
	virtual	bool		debugScript	(KBLocation   &, KBError 	   &) ;  

	virtual	QString		ident		() ;

	static	KBPYScriptIF 	*getIface	() ;
}	;


#define	_C(x)	((char *)(cchar *)x)
#define	MD(t)	{	_C(#t),		_rekall_##t,		METH_VARARGS,	0	},
#define	MN(t)	{	_C("new_"#t),	_rekall_new_##t,	0,		0	},
#define	ME	{	0,		0,			0,		0	}

#endif	// _KB_PYSCRIPT_H
