/***************************************************************************
    file	         : kb_pystub.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include 	<stdlib.h>

#ifndef 	_WIN32
#include	<dlfcn.h>
#else
#include 	<qlibrary.h>
#endif

#include	<qdir.h>

#include	"kb_classes.h"
#include	"kb_build.h"

#include	"kb_libloader.h"

#include	"tk_config.h"
#include	"tk_messagebox.h"

#include	"kb_pyfactory.h"


#if		__KB_RUNTIME
#define		__RT		"rt"
#else
#define		__RT		""
#endif

/*  The point of the code in this module is to make Rekall adapt to	*/
/*  whatever version of the python interpreter is installed on the host	*/
/*  This scheme means that we can have a one-size-fits-all build, which	*/
/*  is definitely required for QT-only builds.				*/

extern	"C"
{
typedef	QObject		*MKSCRIPTIF (cchar *)	;

#ifndef _WIN32
static	void		*scriptLib	= 0	;
#else
static QLibrary* scriptLib = 0;
#endif

static	MKSCRIPTIF	*scriptFn	= 0	;
static	QObject		*scriptObj	= 0	;
}

extern	QString locateFile(const char *, const QString &);
extern	QString locateDir (const char *, const QString &);


KBFACTORYIMPL
(	KBPYScriptFactory,
	script_py,
	"Rekall Python scripting",
	"Plugin",
	"0",
	"7",
	"0"
)

/*  We decide which version of python to run by searching through a set	*/
/*  of possible locations for the python library. For each we need to	*/
/*  know which version to use plus a nominal program name so that	*/
/*  we force python to use the appropriate search path.			*/
struct	PyInterpInfo
{
	QString		libdir		;
	QString		libver		;
	QString		binpath	;
	QString		pypath		;
}	;

#if	! __KB_EMBEDDED && ! __KB_USESYSPY && ! defined(_WIN32)
static	PyInterpInfo	interpInfo[] =
{
{	"/usr/local/lib/python2.2",	"22",	"/usr/local/bin/python", 0 },
{	"/usr/lib/python2.2",		"22",	"/usr/bin/python",	 0 },
{	"/usr/local/lib/python2.1",	"21",	"/usr/local/bin/python", 0 },
{	"/usr/lib/python2.1",		"21",	"/usr/bin/python",	 0 },
{	"/usr/local/lib/python2.0",	"20",	"/usr/local/bin/python", 0 },
{	"/usr/lib/python2.0",		"20",	"/usr/bin/python",	 0 },
{	"/usr/local/lib/python1.5",	"15",	"/usr/local/bin/python", 0 },
{	"/usr/lib/python1.5",		"15",	"/usr/bin/python",	 0 },
{	0,				0,	0,			 0 }
};
#endif

/*  KBPYScriptFactory							*/
/*		: Get an instance of the appropriate interpreter	*/
/*  parent	: QObject *	: Parent object				*/
/*  (returns)	: QObject *	: Interpreter instance			*/

QObject	*KBPYScriptFactory::create
	(	QObject		  *parent,
		cchar		  *,
		cchar		  *,
		const QStringList &
	)
{
	if ((parent != 0) && !parent->inherits ("QObject"))
	{
		fprintf	(stderr, "KBPYScriptFactory: parent does not inherit QObject\n") ;
		return	0  ;
	}

	/* If we have successfully been here before then return the	*/
	/* interpreter instance we generated then. Hence, we only ever	*/
	/* get one instance.						*/
	if (scriptObj != 0)
		return	scriptObj ;


	/* First step is to determin which python version to use,	*/
	/* either explicitely set by the user, or by scanning for the	*/
	/* python library directories. We go for the most recent	*/
	/* version we can find, and assume that a copy under usrlocal	*/
	/* takes preference.						*/

#ifndef _WIN32
	/* Since the Windows version will always install		*/
	/* Python-2.2.0-Win to the same location the code below is not	*/
	/* needed.							*/
	fprintf	(stderr, "Finding appropriate python version library ....\n") ;

	TKConfig *config = TKConfig::getConfig () ;
        config->setGroup ("Debug Options/py") ;

	QString	 binpath = config->readEntry	 ("binpath") ;
	QString	 pypath	 = config->readEntry	 ("pypath" ) ;

	PyInterpInfo *ip = 0 ;

#if	__KB_USESYSPY

	fprintf	(stderr, ".... using system python\n") ;
	ip	    = new PyInterpInfo ;
	ip->libver  = "sys"	;
	ip->binpath = binpath	;
	ip->pypath  = pypath	;
#else
	bool	 userpy	 = config->readBoolEntry ("userpy" ) ;
	QString	 libver	 = config->readEntry	 ("libver" ) ;

	if (userpy)
	{
		fprintf	(stderr, ".... using explicit settings\n") ;

		ip	    = new PyInterpInfo ;
		ip->libver  = libver	;
		ip->binpath = binpath	;
		ip->pypath  = pypath	;
	}
#if	! __KB_EMBEDDED 
	else
	{
		for (ip = &interpInfo[0] ; ip->libdir != 0 ; ip += 1)
			if (QDir(ip->libdir).exists())
				break	;

		if (ip == 0)
		{
			TKMessageBox::sorry
			(	0,
				QString("Unable to find python library directory"),
				"Script error",
				false
			)		;
			return	0	;
		}
	}
#endif
#endif

	/* Now load the interpreter module appropriate to the instance	*/
	/* of the python libraries which were found. This should not	*/
	/* fail since we build interpreters for all the versions that	*/
	/* we scan for.							*/
#if	__KB_EMBEDDED

	QString	libname = "libkbase" __RT "_script_pyinterp.so" ;

#else

	fprintf	(stderr, ".... using \"%s\"\n", (cchar *)ip->libver) ;
	fprintf	(stderr, "Loading appropriate python version library ....\n") ;

	QString	libname = QString("libkbase" __RT "_script_py%1.so").arg(ip->libver) ;
#endif

	fprintf
	(	stderr,
		"Locating python version library interface [%s]\n",
		(cchar *)libname
	)	;

	if ((scriptLib = dlopen ((cchar *)libname, RTLD_NOW|RTLD_GLOBAL)) == 0)
	{
		KBError::EError
		(	"Script Error",
			QString("Unable to load python script module: %1\n%2")
				.arg(libname  )
				.arg(dlerror()),
			__ERRLOCN
		)		;
		return	0	;
	}
#endif	// !_WIN32

#ifdef	_WIN32
	QString libname = "kbase" __RT "_script_pyinterp.dll" ;

	if ((scriptLib = new QLibrary (libname)) == 0)
	{
		KBError::EError
		(	"Script Error",
			QString("Unable to load python script module: %1\n%2")
				.arg(libname  )
				.arg(QString::null),
			__ERRLOCN
		)		;

		return	0	;
	}

#endif

	/* ... and locate the interface routine therein. An error here	*/
	/* is definitely a programming error.				*/
#ifndef _WIN32
	if ((scriptFn = (MKSCRIPTIF *)dlsym   (scriptLib, "makeScriptIF")) == 0)
#else
	if ((scriptFn = (MKSCRIPTIF *)scriptLib->resolve ("makeScriptIF")) == 0)
#endif
	{
		TKMessageBox::sorry
		(	0,
			"Unable to locate python interface",
			"Script error",
			false
		)	;

#ifndef _WIN32
		dlclose	(scriptLib) ;
#else
		scriptLib->unload();
#endif
		scriptLib = 0	;
		return	0 	;
	}

	/* Sucess. Update the environment if required, and then create	*/
	/* the interpreter, saving a pointer at it for future calls.	*/
#ifndef _WIN32
	if ((ip != 0) && (ip->pypath != 0) && (ip->pypath[0] != 0))
	{
		cchar	*oldp	= getenv ("PYTHONPATH"   ) ;
		QString	newp	= QString("PYTHONPATH=%1").arg(ip->pypath) ;

		if (oldp != 0)
		{	newp.append (":" ) ;
			newp.append (oldp) ;
		}

		fprintf	(stderr, "Setting %s\n", (cchar *)newp) ;
		putenv	(strdup ((cchar *)newp)) ;
	}
#endif


	QString	scriptPath	;

#if	__KB_EMBEDDED

	scriptPath = "/opt/Qtopia/usr/bin/python" ;

#elif	defined(_WIN32)

	/* This will not work on machine running WIN9x/ME, since windir	*/
	/* is not defined.						*/
	scriptPath = QString("%1\\system32").arg(getenv("windir")) ;

#else

	scriptPath = ip->binpath ;

#endif

	scriptObj = (*scriptFn) (scriptPath) ;
	return	scriptObj ;
}

cchar	*KBPYScriptFactory::ident ()
{
	return	__KB_BUILD_IDENT ;
}

