/***************************************************************************
    file	         : script.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<errno.h>
#include	<unistd.h>

#include	<qfile.h>
#include	<qdom.h>
#include	<qlibrary.h>
#include	<dlfcn.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_script.h"
#include	"kb_library.h"



#if		__KB_KDE
#include	<kapp.h>
#include	<klocale.h>
#include	<kaboutdata.h>
#include	<kcmdlineargs.h>
#endif


typedef	void	*(*IFPROC)()	;

uint	getArgs
	(	QDomElement	&parent,
		KBValue		*argv
	)
{
	uint	argc	= 0 ;

	for (QDomNode node = parent.firstChild	() ;
			     !node .isNull	() ;
		      node = node  .nextSibling() )
	{
		QDomElement elem = node.toElement () ;
		if (elem.isNull()) continue ;

		if (elem.nodeName() != "arg") continue ;

		QString	    typ	 = elem.attribute("type" ) ;
		QString	    val	 = elem.attribute("value") ;

		if (typ == "fixed")
		{
			argv[argc] = val.toInt() ;
			argc	  += 1 ;
			continue  ;
		}

		if (typ == "float")
		{
			argv[argc] = val.toDouble() ;
			argc	  += 1 ;
			continue  ;
		}

		argv[argc] = val ;
		argc	  += 1 ;
	}

	return	argc	;
}

bool	languageTest
	(	QDomElement	&parent,
		KBScriptIF	*iface
	)
{
	for (QDomNode node = parent.firstChild	() ;
			     !node .isNull	() ;
		      node = node  .nextSibling() )
	{
		QDomElement elem = node.toElement () ;
		if (elem.isNull()) continue ;

		if (elem.nodeName() == "script")
		{
			QString		tag	= elem.attribute("tag"  ) ;
			QString		fname	= elem.attribute("fname") ;
			QString		eText	;
			QString		ePatt	;
			KBError		error	;

			QString		text	= elem.text().stripWhiteSpace() + "\n" ;
			KBScriptCode	*code	= iface->compileFunc
						  (	text,
							fname,
							eText,
							ePatt,
							QStringList(),
							error
			    			  )	;

			if (code == 0)
			{
				fprintf	(stderr, "Script: compile failed '%s'\n", (cchar *)tag) ;
				error.display	(stderr) ;
				return	false	;
			}

			KBValue		args[64] ;
			uint		argc	 = getArgs (elem, args) ;

			KBValue	        rv	 ;
			KBScript::ExeRC rc	 = code->execute (0, argc, args, rv) ;

			printf
			(	"%-10s: %2d: %-8s: %s\n",
				(cchar *)tag,
				(int    )rc,
				(cchar *)rv.getType()->getDescrip(),
				(cchar *)rv.getRawText()
			)	;

			delete	code	;
			continue	;
		}

		if (elem.nodeName() == "expr")
		{
			QString		tag	= elem.attribute("tag"  ) ;
			QString		eText	;
			QString		ePatt	;
			KBError		error	;

			QString		text	= elem.text().stripWhiteSpace() ;
			KBScriptCode	*code	= iface->compileExpr
						  (	text,
							eText,
							ePatt,
							QStringList(),
							error
			    			  )	;

			if (code == 0)
			{
				fprintf	(stderr, "Script: compile failed '%s'\n", (cchar *)tag) ;
				error.display	(stderr) ;
				return	false	;
			}

			KBValue	        rv	 ;
			KBScript::ExeRC rc	 = code->execute (0, 0, 0, rv) ;

			printf
			(	"%-10s: %2d: %-8s: %s\n",
				(cchar *)tag,
				(int    )rc,
				(cchar *)rv.getType()->getDescrip(),
				(cchar *)rv.getRawText()
			)	;

			delete	code	;
			continue	;
		}
	}

	return	true	;
}

bool	xmlTest
	(	const QString	&xmlName
	)
{
	QFile	xmlFile	(xmlName) ;
	if (!xmlFile.open (IO_ReadOnly))
	{
		fprintf	(stderr, "xmlFile: %s: %s\n", (cchar *)xmlName, strerror(errno)) ;
		return	false	;
	}

	QDomDocument doc	;
	if (!doc.setContent (&xmlFile))
	{
		fprintf	(stderr, "xmlFile: %s: cannot parse\n", (cchar *)xmlName) ;
		return	false	;
	}

	QDomElement  docElem	= doc.documentElement() ;
	for (QDomNode node = docElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement elem = node.toElement () ;
		if (elem.isNull()) continue ;

		if (elem.nodeName() == "test")
		{
			QString	 lang = elem.attribute("language") ;
			QLibrary *lib = new QLibrary("kbase_script_" + lang) ;

			IFPROC	 ifproc = (IFPROC) lib->resolve ("init_libkbase_script_" + lang) ;
			if (ifproc ==  0)
			{
				fprintf
				(	stderr,
					"script: no language '%s' (%s)\n",
					(cchar *)lang,
					dlerror()
				)	;
				return	false	;
			}

			KBFactory *factory = (KBFactory *)(*ifproc)() ;
			if (factory ==  0)
			{
				fprintf	(stderr, "Script: no factory '%s'\n", (cchar *)lang) ;
				return	false	;
			}

			KBScriptIF *iface  = (KBScriptIF *)factory->create(0, "scriptiface", "") ;
			if (iface == 0)
			{
				fprintf	(stderr, "Script: no interface for '%s'\n", (cchar *)lang) ;
				return	false	;
			}

			if (!languageTest (elem, iface))
				return	false	;
		}

	}

	return	true	;
}


int	main
	(	int	argc,
		char	*argv[]
	)
{
#if	__KB_KDE
	char *dummy[2]	;

	dummy[0] = (char *)"script" ;
	dummy[1] = 0	;

	KAboutData about ("rekall",
			  I18N_NOOP("RekallScriptTest"),
			  "0.0.0",
			  I18N_NOOP("Rekall: Script test harness"),
			  KAboutData::License_Unknown,
			  "(c) 2000,2001,2002 by theKompany.com",
			  0,
			  "http://www.rekall.a-i-s.co.uk",
			  "mike@quaking.demon.co.uk"
			 ) ;
	about.addAuthor  ("Mike Richardson", 0, "mike@quaking.demon.co.uk") ; 
	about.addAuthor  ("John Dean", 	     0, "john@rygannon.com") ; 

	KCmdLineArgs::init (2, dummy, &about) ;

	KApplication	app	;
#endif

	KBError		error	;

	if (argc != 2)
	{
		fprintf	(stderr, "usage: script xmlfile\n") ;
		exit	(1) ;
	}

//	fprintf	(stderr, "sizeof(QByteArray) : %d\n", sizeof(QByteArray)) ;
//	fprintf	(stderr, "sizeof(KBValue   ) : %d\n", sizeof(KBValue   )) ;
//	fprintf	(stderr, "sizeof(KBRowSet  ) : %d\n", sizeof(KBRowSet  )) ;

	if (!xmlTest (argv[1]))
	{	fprintf	(stderr, "Script test exiting: failed\n") ;
		_exit	(1) ;
	}

	fprintf	(stderr, "Script test exiting\n") ;
	_exit	(0) ;
}
