/***************************************************************************
    file	         : kb_ora10iadvanced.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef		__KB_ORA10IADVANCED_H
#define		__KB_ORA10IADVANCED_H

#include	<qdialog.h>

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dom.h"


class	QCheckBox	;
class	QSpinBox	;

class	QLineEdit	;
class	QComboBox	;
class	QTabWidget	;
class	QTextEdit	;


#ifdef	__NOTYET

/*  KBOra10iGrantsDlg							*/
/*  -----------------							*/
/*  The advanced options contain grant settings. These in turn contain	*/
/*  an option to show a dialog each time a table is created; this is	*/
/*  said dialog.							*/

class	KBOra10iGrantsDlg : public QDialog
{
	// Put back q_object if implementing this class!

	QCheckBox	*m_cbGrantSelect	;
	QCheckBox	*m_cbGrantInsert	;
	QCheckBox	*m_cbGrantUpdate	;
	QCheckBox	*m_cbGrantDelete	;
	RKLineEdit	*m_leGrantTo		;

	bool		m_mapExpressions	;

protected slot__s :

	void		clickOK		()	;
	void		clickSkip	()	;
	void		clickCancel	()	;

public	:

	KBOra10iGrantsDlg
			(bool, bool, bool, bool, const QString &, bool) ;

	QString		grantText	()	;
}	;

#endif

/*  ------------------------------------------------------------------  */

/*  KBOra10iAdvanced							*/
/*  -----------------							*/
/*  This is the advanced options dialog for PostgreSQL. It has the	*/
/*  following server-specific pages					*/
/*									*/
/*	* General options						*/
/*	* Grant settings						*/

class	KBOra10iAdvanced : public KBDBAdvanced
{
	Q_OBJECT

	bool		m_showRowID			;
	bool		m_showOra10iObjects		;
	bool		m_useTimeouts			;
#ifdef	__NOTYET
	int		m_stmtTimeout			;
#endif
	int		m_lockTimeout			;
	QString		m_connectStr			;

	QCheckBox	*m_cbShowRowID			;
	QCheckBox	*m_cbShowOra10iObjects		;

	QCheckBox	*m_cbUseTimeouts		;
#ifdef	__NOTYET
	QSpinBox	*m_spStmtTimeout		;
#endif
	QSpinBox	*m_spLockTimeout		;

	QTextEdit	*m_teConnectStr			;

#ifdef	__NOTYET
	bool		m_grants			;
	bool		m_grantSelect			;
	bool		m_grantInsert			;
	bool		m_grantUpdate			;
	bool		m_grantDelete			;
	QString		m_grantTo			;
	bool		m_grantPopup			;

	QCheckBox	*m_cbGrants			;
	QCheckBox	*m_cbGrantSelect		;
	QCheckBox	*m_cbGrantInsert		;
	QCheckBox	*m_cbGrantUpdate		;
	QCheckBox	*m_cbGrantDelete		;
	QLineEdit	*m_leGrantTo			;
	QCheckBox	*m_cbGrantPopup			;
#endif

private slots :

	void		slotGrantsChanged	() ;
	void		slotUseTimeoutChanged	() ;

public	:

	KBOra10iAdvanced	()	;
virtual~KBOra10iAdvanced	()	;

	virtual	void		load		(const QDomElement &) ;
	virtual	void		save		(QDomElement	   &) ;
	virtual	void		setupDialog	(QTabWidget	   *) ;
	virtual	void		saveDialog	() ;
	virtual	KBDBAdvanced	*copy		() ;

	friend	class	KBOra10i	;
}	;

#endif		// __KB_ORA10IADVANCED_H
