/***************************************************************************
    file	         : kb_viewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>
#include	<errno.h>
#include	<time.h>

#include	<qfile.h>
#include	<qtextstream.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qevent.h>
#include	<qwidget.h>
#include	<qwidgetlist.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_location.h"
#include	"kb_attr.h"
#include	"kb_dblink.h"
#include	"kb_dbinfo.h"
#include	"kb_node.h"
#include	"kb_display.h"
#include	"kb_prompt.h"
#include	"kb_gui.h"
#include	"kb_notifier.h"
#include	"kb_formcopier.h"

#include	"kb_partwidget.h"
#include	"kb_part.h"

#ifndef 	_WIN32
#include	"kb_viewer.moc"
#else
#include 	"kb_viewer.h"
#endif

/*  KBViewer								*/
/*  KBViewer	: Constructor for viewer base class			*/
/*  parent	: KBObjBase *	: Parent object				*/
/*  embed	: QWidget *	: Embedding window			*/
/*  flags	: int		: Initial widget flags			*/
/*  modal	: bool		: Runs as modal				*/
/*  (returns)	: KBViewer	:					*/

KBViewer::KBViewer
	(	KBObjBase	*parent,
		QWidget		*embed,
		int		flags,
		bool		modal
	)
	:
	KBasePart (parent, embed, flags, modal),
	m_objBase (parent)
{
}

/*  KBViewer								*/
/*  ~KBViewer	: Destructor for viewer base class			*/
/*  (returns)	:		:					*/

KBViewer::~KBViewer ()
{
}

/*  KBViewer								*/
/*  showAs	: Show in specified mode				*/
/*  _showAs	: int		: Mode					*/
/*  (returns)	: void		:					*/

void	KBViewer::showAs
	(	int	_showAs
	)
{
	showAs	((KB::ShowAs)_showAs) ;
}

/*  KBViewer								*/
/*  setCaption	: Set caption						*/
/*  caption	: const QString & : Caption				*/
/*  (returns)	: void		  :					*/

void	KBViewer::setCaption
	(	const QString	&caption
	)
{
	if (m_partWidget)
	{
		if (caption.isEmpty())
			m_partWidget->setCaption (getLocation().title()) ;
		else	m_partWidget->setCaption (caption) ;
	}
}

