/***************************************************************************
    file	         : kb_listitem.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlistview.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_filelist.h"
#include	"kb_listitem.h"


/*  ------------------------------------------------------------------  */

/*  KBListItem								*/
/*  KBListItem	: Constructor for ordered list item			*/
/*  parent	: KBFileList *	  : Parent file list			*/
/*  order	: const QString & : Ordering prefix			*/
/*  text1	: QString	  : First text entry			*/
/*  text2	: QString	  : Second text entry			*/
/*  text3	: QString	  : Third text entry			*/
/*  text4	: QString	  : Fourth text entry			*/
/*  text5	: QString	  : Fourth text entry			*/
/*  (returns)	: KBListItem	  :					*/

KBListItem::KBListItem
	(	KBFileList	*parent,
		const QString	&order,
		QString		text1,
		QString		text2,
		QString		text3,
		QString		text4,
		QString		text5
	)
	:
	QListViewItem	(parent, 0, text1, text2, text3, text4, text5),
	m_order		(order)
{
	m_type	= Unknown	;
}

/*  KBListItem								*/
/*  KBListItem	: Constructor for ordered list item			*/
/*  parent	: KBServerItem *  : Parent server			*/
/*  order	: const QString & : Ordering prefix			*/
/*  text1	: QString	  : First text entry			*/
/*  text2	: QString	  : Second text entry			*/
/*  text3	: QString	  : Third text entry			*/
/*  text4	: QString	  : Fourth text entry			*/
/*  text5	: QString	  : Fourth text entry			*/
/*  (returns)	: KBListItem	  :					*/

KBListItem::KBListItem
	(	KBServerItem	*parent,
		const QString	&order,
		QString		text1,
		QString		text2,
		QString		text3,
		QString		text4,
		QString		text5
	)
	:
	QListViewItem	(parent, 0, text1, text2, text3, text4, text5),
	m_order		(order)
{
	m_type	= Unknown	;
}

/*  KBListItem								*/
/*  KBListItem	: Constructor for ordered list item			*/
/*  parent	: KBObjectItem *  : Parent object			*/
/*  order	: const QString & : Ordering prefix			*/
/*  text1	: QString	  : First text entry			*/
/*  text2	: QString	  : Second text entry			*/
/*  text3	: QString	  : Third text entry			*/
/*  text4	: QString	  : Fourth text entry			*/
/*  text5	: QString	  : Fourth text entry			*/
/*  (returns)	: KBListItem	  :					*/

KBListItem::KBListItem
	(	KBObjectItem	*parent,
		const QString	&order,
		QString		text1,
		QString		text2,
		QString		text3,
		QString		text4,
		QString		text5
	)
	:
	QListViewItem	(parent, 0, text1, text2, text3, text4, text5),
	m_order		(order)
{
	m_type	= Unknown	;
}

/*  KBListItem								*/
/*  key		: Return ordering key					*/
/*  column	: int		: Column being sorted			*/
/*  ascending	: bool		: Sort ascending			*/
/*  (returns)	: QString	: Ordering key				*/

QString	KBListItem::key
	(	int	,
		bool
	)
	const
{
	return	m_order + text(0) ;
}

/*  ------------------------------------------------------------------  */

/*  KBServerItem							*/
/*  KBServerItem: Constructor for server list item			*/
/*  parent	: KBFileList *	  : Parent file list			*/
/*  order	: const QString & : Ordering prefix			*/
/*  server	: QString	  : Server name				*/
/*  (returns)	: KBServerItem	  :					*/

KBServerItem::KBServerItem
	(	KBFileList	*parent,
		const QString	&order,
		QString		server
	)
	:
	KBListItem	(parent, order, server),
	m_parent	(parent)
{
	setExpandable	(true  ) ;
	setType		(Server) ;
}

/*  KBServerItem								*/
/*  setOpen	: Open or close the branch				*/
/*  open	: bool		: Opening				*/
/*  (returns)	: void		:					*/

void	KBServerItem::setOpen
	(	bool	open
	)
{
	if (open && (childCount() == 0))
		m_parent->reloadServer (this) ;

	QListViewItem::setOpen (open) ;
}


/*  ------------------------------------------------------------------  */

/*  KBObjectItem								*/
/*  KBListItem	: Constructor for object list item			*/
/*  parent	: KBServerItem *  : Parent server item			*/
/*  order	: const QString & : Ordering prefix			*/
/*  name	: QString	  : Object name				*/
/*  text2	: QString	  : Second text entry			*/
/*  text3	: QString	  : Third text entry			*/
/*  text4	: QString	  : Fourth text entry			*/
/*  (returns)	: KBListItem	  :					*/

KBObjectItem::KBObjectItem
	(	KBServerItem	*parent,
		const QString	&order,
		QString		name,
		QString		text2,
		QString		text3,
		QString		text4
	)
	:
	KBListItem	(parent, order, name, text2, text3, text4),
	m_parent	(parent)
{
	setExpandable	(false ) ;
	setType		(Object) ;
}
