/***************************************************************************
    file	         : kb_part.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>
#include	<errno.h>
#include	<time.h>

#include	<qfile.h>
#include	<qtextstream.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qevent.h>
#include	<qwidget.h>
#include	<qwidgetlist.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_location.h"
#include	"kb_attr.h"
#include	"kb_dblink.h"
#include	"kb_dbinfo.h"
#include	"kb_node.h"
#include	"kb_display.h"
#include	"kb_prompt.h"
#include	"kb_gui.h"
#include	"kb_notifier.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"

#include	"kb_objbase.h"
#include	"kb_partwidget.h"

#ifndef 	_WIN32
#include	"kb_part.moc"
#else
#include 	"kb_part.h"
#endif


/*  KBasePart								*/
/*  KBasePart	: Constructor for MDI child window wrapper class	*/
/*  parent	: KBObjBase *	: Parent object				*/
/*  embed	: QWidget *	: Embedding window			*/
/*  flags	: int		: Widget flags				*/
/*  modal	: bool		: Part runs as modal			*/
/*  (returns)	: KBasePart	:					*/

KBasePart::KBasePart
	(	KBObjBase	*parent,
		QWidget		*embed,
		int		flags,
		bool		modal
	)
	:
	TKPart		(parent),
	m_modal		(modal),
	m_objBase	(parent),
	m_embed		(embed)
{
	m_localGUISpec	= 0 ;
	m_currentGUI 	= 0 ;
	m_topWidget  	= 0 ;

	/* If not embedding or requested modal then the part is show in	*/
	/* a separate top-level window, otherwise the part is embedded	*/
	/* in the MDI parent.						*/
	if ((embed == 0) || modal)
	{
		m_mainWin    = new KBSDIMainWindow (this, m_modal) ;
		m_partWidget = new KBPartWidget    (m_mainWin, this, flags, m_mainWin) ; 
		m_mainWin->setCentralWidget (m_partWidget) ;

		m_mainWin   ->hide () ;

		KBAppPtr::getCallback()->addPart (this) ;
	}
	else
	{
		m_mainWin	   = 0 ;
		m_partWidget = new KBPartWidget (embed, this, flags) ;

		m_partWidget->hide () ;

		KBAppPtr::getCallback()->addPart (this) ;
	}

	setWidget (m_partWidget) ;
}

/*  KBasePart								*/
/*  ~KBasePart	: Destructor for MDI child window base class		*/
/*  (returns)	:		:					*/

KBasePart::~KBasePart ()
{
	fprintf
	(	stderr,
		"KBasePart::~KBasePart: mainWin=%p partWidget=%p\n",
		(void *)m_mainWin,
		(void *)m_partWidget
	)	;

	if (m_mainWin)
	{
		/* Running in SDI mode or object is being displayed	*/
		/* modally. Delete the main window, but reparent the	*/
		/* part widget first, the part destructor will destroy	*/
		/* this.						*/
		KBAppPtr::getCallback ()->dropPart (this) ;

		m_partWidget->hide    () ;
		m_partWidget->deparent() ;
		DELOBJ	(m_mainWin) ;
		return	;
	}

	/* MDI mode and not modal. The part destructor will destory the	*/
	/* part widget.							*/
	KBAppPtr::getCallback()->dropPart (this) ;
}

/*  KBasePart								*/
/*  show	: Show MDI child window					*/
/*  (returns)	: void		:					*/

void	KBasePart::show ()
{
	if (m_mainWin)
	{
		m_mainWin   ->show  () ;
		m_mainWin   ->raise () ;
	}

	m_partWidget->show     () ;
	m_partWidget->raise    () ;
	m_partWidget->setFocus () ;
}

/*  KBasePart								*/
/*  hide	: Hide MDI child window					*/
/*  (returns)	: void		:					*/

void	KBasePart::hide ()
{
	if	(m_mainWin   ) m_mainWin   ->hide () ;
	else if (m_partWidget) m_partWidget->hide () ;
}

/*  KBasePart								*/
/*  resizeEvent	: Handle resize event from part widget			*/
/*  e		: QResizeEvent * : Resize event in question		*/
/*  (returns)	: void		:					*/

void	KBasePart::resizeEvent
	(	QResizeEvent	*e
	)
{
	if (m_topWidget != 0) m_topWidget->resize(e->size()) ;
}

/*  KBasePart								*/
/*  setGUI	: Set specified GUI					*/
/*  gui		: KBaseGUI *	: Required GUI				*/
/*  (returns)	: void		:					*/

void	KBasePart::setGUI
	(	KBaseGUI	*gui
	)
{
	/* Note the required GUI, and set the associated XML files. The	*/
	/* pointer is also passed to the KBaseGUI class, which acts as	*/
	/* a common static repository for it.				*/
	if (gui != 0)
		setXMLFile (gui->getXMLFile ()) ;

	m_currentGUI = gui ;

	/* We now need to get the GUI displayed. KDE2 does not have	*/
	/* any direct way to do this, so we have to it by signal. But	*/
	/* see the comments in KBPartWidget::setGUI as to why we emit	*/
	/* the signal there.						*/
	if (m_partWidget)
		m_partWidget->setGUI (gui) ;
}

/*  KBasePart								*/
/*  action	: Get GUI action					*/
/*  element	: QDomElement &	: XML GUI element			*/
/*  (returns)	: (T)KAction *	: Action or null if none		*/

ACTION	*KBasePart::action
	(	const QDomElement &element
	)
	const
{
	if (m_currentGUI != 0)
	{
		TKAction *action = m_currentGUI->getAction (element, m_localGUISpec) ;
		if (action != 0) return action->getAction () ;
	}

	return	TKPart::action (element) ;
}

/*  KBasePart								*/
/*  action	: Get GUI action					*/
/*  name	: cchar *	: Actioo name				*/
/*  (returns)	: (T)KAction *	: Action or null if none		*/

ACTION	*KBasePart::action
	(	cchar		*name
	)
	const
{
	if (m_currentGUI != 0)
	{
		TKAction *action =  m_currentGUI->getAction (name) ;
		if (action != 0) return action->getAction () ;
	}

	return	TKPart::action (name) ;
}

/*  KBasePart								*/
/*  guiEnable	: Enable/disable named GUI element			*/
/*  name	: cchar *	: Element name				*/
/*  enable	: bool		: Enable/disable			*/
/*  (returns)	: void		:					*/

void	KBasePart::guiEnable
	(	cchar		*name,
		bool		enable
	)
{
	if (m_currentGUI != 0) m_currentGUI->setEnabled (name, enable) ;
}

/*  KBasePart								*/
/*  guiEnable	: Enable/disable GUI group				*/
/*  ggrp	: KB::GGroup	: GUI group				*/
/*  enable	: bool		: Enable/disable			*/
/*  (returns)	: void		:					*/

void	KBasePart::guiEnable
	(	KB::GGroup	ggrp,
		bool		enable
	)
{
	if (m_currentGUI != 0) m_currentGUI->setEnabled (ggrp, enable) ;
}

/*  KBasePart								*/
/*  slotClose	: Handle close request					*/
/*  (returns)	: void		:					*/

void	KBasePart::slotClose ()
{
	fprintf
	(	stderr,
		"KBasePart::slotClose: objBase=[%p]\n",
		(void *)m_objBase
	)	;

	/* Check that is it OK to close ....				*/
	if (!queryClose()) return ;


	/* If modal then exit the main window from the modal loop. This	*/
	/* is sufficient to shut things down ....			*/
	if (m_modal)
	{
		m_mainWin->exitModal () ;
		return	;
	}

	/* Otherwise all the work is done from the base object if there	*/
	/* is one, or directly here if not.				*/
	if (m_objBase)
	{
		m_objBase->closeObject () ;
		return	;
	}

	delete	this	;
}
