/***************************************************************************
    file	         : kb_classes.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_CLASSES_H
#define	_KB_CLASSES_H

#include 	"libcommon_exports.h"

#include	<stdio.h>
#include	<qdict.h>
#include	<qstring.h>


#define		KB_HEXVER		0x00020000

class	KBaseApp	;
class	KBaseGUI	;
class	KBasePart	;
class	KBFormCopier	;

class	KBControl	;

class	KBNode		;
class	KBNodeMonitor	;
class	KBForm		;
class	KBReport	;
class	KBComponent	;
class	KBLayout	;
class	KBDocRoot	;
class	KBParam		;
class	KBModule	;
class	KBImport	;
class	KBScript	;
class	KBScriptCode	;
class	KBScriptObject	;
class	KBConfig	;
class	KBOverride	;
class	KBObject	;
class	KBItem		;
class	KBField		;
class	KBBlock		;
class	KBFormBlock	;
class	KBReportBlock	;
class	KBFramer	;
class	KBHeader	;
class	KBFooter	;
class	KBContainer	;
class	KBTabberPage	;
class	KBTabber	;
class	KBNavigator	;
class	KBButton	;
class	KBLabel		;
class	KBGraphic	;
class	KBLink		;
class	KBChoice	;
class	KBCheck		;
class	KBPixmap	;
class	KBMorph		;
class	KBRowMark	;
class	KBGrid		;
class	KBHidden	;
class	KBMemo		;
class	KBSummary	;
class	KBSpinBox	;
class	KBData		;
class	KBAttr		;
class	KBAttrStr	;
class	KBAttrInt	;
class	KBAttrUInt	;
class	KBAttrBool	;
class	KBAttrDict	;
class	KBEvent		;
class	KBEmitter	;
class	KBSlot		;
class	KBParamSet	;

class	KBWriter	;
class	KBWidgetWriter	;
class	KBPrinterWriter	;

class	KBQuery		;
class	KBTable		;
class	KBQryExpr	;
class	KBQueryDlg	;

class	KBQryBase	;
class	KBQryData	;
class	KBQryDesign	;
class	KBQryTable	;
class	KBQryQuery	;
class	KBQrySQL	;
class	KBQryNull	;
class	KBQryLevel	;

class	KBDisplay	;
class	KBScriptIF	;
class	KBObjBase	;

class	KBTableList	;
class	KBFileList	;
class	KBFormList	;
class	KBReportList	;
class	KBQueryList	;
class	KBScriptList	;

class	KBServerDlg	;
class	KBDBaseDlg	;
class	KBDBInfo	;
class	KBDBLink	;
class	KBServerInfo	;
class	KBDBAdvanced	;

class	KBNotifier	;
class	KBCallback	;

class	KBValue		;
class	KBType		;
class	KBShared	;
class	KBDateTime	;

struct	KBDataArray	;
class	KBDataBuffer	;

class	KBPopupMenu	;
class	KBResizeWidget	;

class	QXmlAttributes	;


class	KBFactory	;
class	KBPartFactory	;


class 	LIBCOMMON_API	KB
{
public	:

	enum	TableType
	{	IsTable		= 0x01,
		IsView		= 0x02,
		IsSequence	= 0x04,
		IsAny		= 0xff
	}	;

	enum	CtrlAlign
	{	AlignTop	= 1,
		AlignLeft	= 2,
		AlignBottom	= 3,
		AlignRight	= 4,
		SameHeight	= 5,
		SameWidth	= 6,
		SameSize	= 7
	}	;

	enum	Action
	{	Null		= 0,
		First		= 1,
		Previous	= 2,
		Next		= 3,
		Last		= 4,
		Add		= 5,
		Save		= 6,
		Delete		= 7,
		Query		= 8,
		Execute		= 9,
		Cancel		= 10,
		Insert		= 11,
		PrevBack	= 12,
		NextForw	= 13,
		Reset		= 14,
		GotoQRow	= 15,
		SyncAll		= 16,
		Store		= 17,
		PrevPage	= 18,
		NextPage	= 19,
		Reload		= 20,
		Scroll		= 21
	}	;

	enum	GGroup
	{
		GRNone,
		GRCopy,
		GRAlign,
		GRDelta
	}	;

	enum	IType
	{
		ITUnknown,		/* Type not known		*/
		ITRaw,			/* Value to be used raw		*/
		ITFixed,		/* Value is fixed point		*/
		ITFloat,		/* Value is floating point	*/
		ITDecimal,		/* Value is decimal(n,m)	*/
		ITDate,			/* Value is date		*/
		ITTime,			/* Value is time		*/
		ITDateTime,		/* Value is date/time		*/
		ITString,		/* Value is a string		*/
		ITBinary,		/* Value is binary data		*/
		ITBool,			/* Value is boolean		*/
		ITDriver		/* Value is driver-specific	*/
	}	;

	enum	RState
	{
		RSUnknown,		/* Row state not known		*/
		RSInSync,		/* In sync with server		*/
		RSDeleted,		/* Row marked deleted		*/
		RSInserted,		/* Row has been inserted	*/
		RSChanged		/* Row contents changed		*/
	}	;

	enum	ScriptRC
	{	ScriptOK,		/* Script exited correctly	*/
		ScriptInlineError,	/* Error in inline script	*/
		ScriptGlobalError	/* Error elsewhere		*/
	}	;

	enum	ShowAs
	{	ShowAsUnknown,		/* Indeterminate state		*/
		ShowAsData,		/* Show document in data view	*/
		ShowAsPrint,		/* Print document		*/
		ShowAsPreview,		/* Preview document		*/
		ShowAsReport,		/* Print report			*/
		ShowAsDesign		/* Show document in design view	*/
	}	;

	enum	ShowRC
	{	ShowRCOK,		/* Document shown OK		*/
		ShowRCModal,		/* Document shown modally	*/
		ShowRCData,		/* Document shown in data view	*/
		ShowRCError,		/* Error showing document	*/
		ShowRCCancel,		/* User cancelled		*/
		ShowRCReport,		/* Report printed		*/
		ShowRCDesign		/* Document shown in design	*/
	}	;

	enum	ShowMode
	{	ShowAuto,		/* Show in requested state	*/
		ShowNormal,		/* Show in normal state		*/
		ShowModal		/* Show in modal state		*/
	}	;

	enum	MarkOp
	{	MarkOpSet,		/* Mark specified row		*/
		MarkOpSetAll,		/* Mark all rows		*/
		MarkOpToggle,		/* Toggle mark on specified row	*/
		MarkOpRange,		/* Set mark on range of rows	*/
		MarkOpClear		/* Clear all marks		*/
	}	;

	enum	ObjType
	{
		ObjUnknown	= 0,
		ObjForm		= 1,
		ObjReport	= 2
	}	;


private :

}	;

typedef	unsigned int	uint	  ;
typedef	const char	cchar	  ;



/*  KBError								*/
/*  -------								*/
/*  General error class. This class is used to pass error information	*/
/*  about. It encapsulates three items:					*/
/*	error type	- the severity of the error			*/
/*	message		- basic error message, originated by kbase	*/
/*	details		- details message, may include server text	*/

class LIBCOMMON_API	KBError
{
public	:

	enum	EType
	{	None,		/* No error				*/
		Info,		/* Eg., previous row at first row	*/
		Warning,	/* Eg., field contents invalid		*/
		Error,		/* Eg., SQL statement syntax error	*/
		Fault		/* Eg., internal bugs			*/
	}	;

private	:

	EType	m_etype	    ;	/* General error type			*/
	QString	m_message   ;	/* Error message			*/
	QString	m_details   ;	/* Optional error details		*/
	cchar	*m_file	    ;	/* Source code file			*/
	uint	m_lno	    ;	/* Source code line number		*/
	int	m_errno	    ;	/* System error code			*/

public	:

	KBError	(EType, const QString &, const QString &, cchar *, uint) ;
	KBError	()	;

	inline	void	setErrno
		(	int	_errno
		)
	{
		m_errno	= _errno	;
	}

	void			operator = (const KBError &) ;

	inline	KBError::EType	getEType   () const { return m_etype   ; }
	inline	const QString	&getMessage() const { return m_message ; }
	inline	const QString	&getDetails() const { return m_details ; }
	inline	cchar		*getFile   () const { return m_file    ; }
	inline	uint		getLineno  () const { return m_lno     ; }
	inline	int		getErrno   () const { return m_errno   ; }

	static	void		EInfo      (const QString &, const QString &, cchar *, uint) ;
	static	void		EWarning   (const QString &, const QString &, cchar *, uint) ;
	static	void		EError	   (const QString &, const QString &, cchar *, uint) ;
	static	void		EFault	   (const QString &, const QString &, cchar *, uint) ;
	static	void		EFatal	   (const QString &, const QString &, cchar *, uint) ;

	void			display	   (const QString & = QString::null, cchar * = 0, uint = 0) const ;
#if	! __KB_EMBEDDED
	void			display	   (FILE *) const ;
#endif
	static	uint		errDebug   ;
}	;

#define	ERRTRACE
#ifdef	ERRTRACE
#define	__ERRLOCN		__FILE__, __LINE__
#else	// ERRTRACE
#define	__ERRLOCN		0, 0
#endif	// ERRTRACE

#define	DISPLAY()		display	   (QString::null, __ERRLOCN)
#define	DISPLAYCAP(cap)		display	   (cap, 	   __ERRLOCN)
#define	DISPLAYFD(fd)		display	   (fd) ;

#define	DELOBJ(p)	if (p) { delete p ; p = 0 ; }

/*  TITER(Type,Ptr,Action)						*/
/*  This macro is like kb_node.h/CITER, except that an explicit list	*/
/*  is given.								*/


#define	TITER(Type,List,Ptr,Action) \
	{	QListIterator<KBNode> __iter (List) ;			\
		KBNode *__##Ptr ;					\
		KB##Type *Ptr ;						\
		while ((__##Ptr = __iter.current()) != 0)		\
		{	__iter += 1 ;					\
			if ((Ptr = __##Ptr->is##Type()) != 0)		\
			{	Action ;				\
			}						\
		}							\
	}

/*  LITER(Type,List,Ptr)						*/
/*  Another convenience macro. Iterates through a list of sepecified	*/
/*  type for a named pointer variable, applyting action.		*/


#define	LITER(Type,List,Ptr,Action) \
	{	QListIterator<Type> __iter (List)  ; 			\
		Type *Ptr ;						\
		while ((Ptr = __iter.current()) != 0)			\
		{	__iter += 1 ;					\
			Action ;					\
		}							\
	}

/*  LITER(Type,List,Ptr)						*/
/*  Another convenience macro, similar to LITER, but iterates through	*/
/*  a dictionary.							*/


#define	DITER(Type,Dict,Ptr,Action) \
	{	QDictIterator<Type> __iter (Dict)  ; 			\
		Type *Ptr ;						\
		while ((Ptr = __iter.current()) != 0)			\
		{	__iter += 1 ;					\
			Action ;					\
		}							\
	}


#define	OBJECTTABNAME	"RekallObjects"
#define	DESIGNTABNAME	"RekallDesign"

#ifndef	__KB_EMBEDDED
#define	__KB_EMBEDDED	0
#endif

#if	__KB_KDE
#include		<klocale.h>
#define	TR(x)		i18n(x)
#endif

#if	__KB_TKC

#if	__KB_EMBEDDED
#define	TR(x)		QObject::tr(x)
#else
#define	TR(x)		QObject::trUtf8(x, "")
#endif
#endif

#define	__TR(x)		x

#ifdef 	_WIN32

#define uint		UINT
#define	SEPSTR		"\\"
#define	SEPCHR		'\\'

#else

#define	SEPSTR		"/"
#define	SEPCHR		'/'

#endif

#endif	// _KB_CLASSES_H
