/***************************************************************************
    file	         : kb_designinfo.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qintdict.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_designinfo.h"



/*  KBDesignInfo							*/
/*  KBDesignInfo: Constructor for column design information		*/
/*  select	: KBSQLSelect *	: Query containing information		*/
/*  qrow	: uint		: Row in query for this column		*/
/*  (returns)	: KBDesignInfo	:					*/

KBDesignInfo::KBDesignInfo
	(	KBSQLSelect	*select,
		uint		qrow
	)
{
	if (select->getNumFields() != DI_NVALS)
		KBError::EFatal
		(	QString (TR("KBDesignInfo size mismatch %1 != %2"))
				 .arg(sizeof(values)/sizeof(KBValue))
				 .arg(select->getNumFields()),
			QString::null,
			__ERRLOCN
		)	;

	/* Copy the values from the query. The first value, which is	*/
	/* the primary key, is copied to the end so that we can use	*/
	/* the same array for insert and update later.			*/
	for (uint qcol = 0 ; qcol < DI_NVALS ; qcol += 1)
		values[qcol] = select->getField (qrow, qcol) ;

	values[DI_NVALS] = values[0] ;
	changed	 	= false     ;
}

/*  KBDesignInfo							*/
/*  KBDesignInfo: Constructor for column design information		*/
/*  table	: const QString & : Table name				*/
/*  (returns)	: KBDesignInfo	  :					*/

KBDesignInfo::KBDesignInfo
	(	const QString	&table
	)
{
	changed	  = false ;
	values[1] = KBValue (table) ;
}

/*  KBDesignInfo							*/
/*  getField	: Get pointer at field value				*/
/*  qcol	: uint		: Column number				*/
/*  (returns)	: KBValue *	: Value pointer				*/

KBValue	*KBDesignInfo::getField
	(	uint	qcol
	)
{
	static	KBValue	nullVal ;
	return	qcol < DI_NVALS ? &values[qcol] : &nullVal ;
}

/*  KBDesignInfo							*/
/*  setField	: Set field value					*/
/*  qcol	: uint		  : Column number			*/
/*  value	: const KBValue & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBDesignInfo::setField
	(	uint		qcol,
		const KBValue	&value
	)
{
	if (qcol < DI_NVALS)
	{	values[qcol]	= value	;
		changed		= true	;
	}
}

/*  KBDesignInfo							*/
/*  setField	: Set field value					*/
/*  qcol	: uint		  : Column number			*/
/*  value	: const QString & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBDesignInfo::setField
	(	uint		qcol,
		const QString	&value
	)
{
	if (qcol < DI_NVALS)
	{	values[qcol]	= KBValue (value) ;
		changed		= true	;
	}
}
