/***************************************************************************
    file	         : kb_libloader_tkc.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef		__KB_LIBLOADER_TKC
#define		__KB_LIBLOADER_TKC

#if		__KB_TKC

#if 		__KB_EMBEDDED
#include	<qpe/qlibrary.h>
#else
#include 	<qlibrary.h>
#endif


#include	<qobject.h>
#include	<qstringlist.h>

#include	"libcommon_exports.h"

/*  If __KB_RUNTIME is not defined then it can be arbitrarily set to	*/
/*  zero (false). It will be set whenever the KBINITFUNC is actually	*/
/*  invoked in a runtime build.						*/

#if		!defined(__KB_RUNTIME)
#define		__KB_RUNTIME	0
#endif

#if		__KB_RUNTIME
#define		KBINITFUNC(part)	init_libkbasert_##part
#else
#define		KBINITFUNC(part)	init_libkbase_##part
#endif

/*  ------------------------------------------------------------------  */

/*  KBLibrary								*/
/*  ---------								*/
/*  Library wrapper class. In this case is simply wraps the standard	*/
/*  QT QLibrary class.							*/

class	LIBCOMMON_API	KBLibrary
{
	QLibrary	*m_library	;
	QString		m_name		;

public	:

	inline	KBLibrary
		(	QLibrary	*library,
			const QString	&name
		)
		:
		m_library	(library),
		m_name		(name)
	{
	}

	void	*factory ()	;
}	;


/*  KBLibLoader								*/
/*  -----------								*/
/*  Library loader class. For QT builds we have our own implemetation	*/
/*  that does all the work.						*/

class	LIBCOMMON_API	KBLibLoader 
{
	QString		m_error		;
public	:

	KBLibrary	*getLibrary		(const char *)	;
	KBLibrary	*getGlobalLibrary	(const char *)	;
	QString		lastErrorMessage	()		;

	static	KBLibLoader	*self	() ;
}	;


/*  ------------------------------------------------------------------  */

/*  CREATE_DEFN								*/
/*  -----------								*/
/*  Macro to generate the library creation method definition. This is	*/
/*  that same in all cases.						*/

#define	CREATE_DEFN	\
	virtual	QObject	*create						\
		(	QObject *		= 0,			\
			const char *		= 0, 			\
			const char *		= 0, 			\
			const QStringList &	= QStringList()		\
		)	;

#define	IDENT_DEFN	\
	virtual	const char *ident	() ;

/*  ------------------------------------------------------------------  */


#ifdef	_WIN32
#define	KBINITDECL		__declspec(dllexport)
#else
#define	KBINITDECL
#endif

class 	LIBCOMMON_API	KBPartFactory : public QObject
{
public	:

	KBPartFactory	      () ;
	virtual~KBPartFactory () ;
	CREATE_DEFN
	IDENT_DEFN
}	;

class	LIBCOMMON_API	KBFactory : public QObject
{
public	:

	KBFactory 	  () ;
	virtual~KBFactory () ;
	CREATE_DEFN
	IDENT_DEFN
}	;

/*  KBPARTFACTORY							*/
/*  -------------							*/
/*  This is used to generate factory classes for components which are	*/
/*  notionally KDE parts, ie., which display things, although it is not	*/
/*  obvious that Rekall's parts can be used in any general way.		*/


#define	KBPARTFACTORY(className,instName)				\
	class	className : public KBPartFactory			\
	{								\
	public	:							\
		inline	className () : KBPartFactory ()			\
		{							\
		}							\
		CREATE_DEFN						\
		IDENT_DEFN						\
	}	;

/*  KBFACTORY								*/
/*  ---------								*/
/*  This is used to generate factory classes for components which can	*/
/*  never be a KDE part. With Qlib this is exactly the same as the	*/
/*  notional part factory above.					*/

#define	KBFACTORY(className,instName)					\
	class	className : public KBFactory				\
	{								\
	public	:							\
		inline	className () : KBFactory ()			\
		{							\
		}							\
		CREATE_DEFN						\
		IDENT_DEFN						\
	}	;

#define	KBFACTORYIMPL(className,libName,i1,i2,i3,i4,i5)			\
	extern	"C"							\
	{	KBINITDECL void *KBINITFUNC(libName) ()			\
		{							\
			return	new className ;				\
		}							\
	}	;
#endif	// __KB_TKC
#endif	// __KB_LIBLOADER_KDE
