/***************************************************************************
    file	         : kb_notifier.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"

#ifndef 	_WIN32
#include 	"kb_notifier.moc"
#else
#include	"kb_notifier.h"
#endif


KBNotifier::KBNotifier ()
	:
	QObject	(0)
{
}

void	KBNotifier::nServerChanged
	(	const KBLocation &location
	)
{
	emit	sServerChanged (location) ;
}

void	KBNotifier::nTablesChanged
	(	const KBLocation &location
	)
{
	emit	sTablesChanged (location) ;
}

void	KBNotifier::nObjectChanged
	(	const KBLocation &location
	)
{
	emit	sObjectChanged (location) ;
}

KBNotifier *KBNotifier::self ()
{
	static	KBNotifier *kbNotifier = 0 ;
	if (kbNotifier == 0) kbNotifier = new KBNotifier () ;
	return	kbNotifier ;
}
