/***************************************************************************
    file	         : kb_macroform.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_macroform.h"
#include	"kb_objbase.h"
#include	"kb_form.h"


/*  KBMacroOpenForm							*/
/*  KBMacroOpenForm							*/
/* 		: Macro to open a form					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroOpenForm::KBMacroOpenForm
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "OpenForm")
{
}

/*  KBMacroOpenForm							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroOpenForm::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 2, pError) ;
}

/*  KBMacroOpenForm							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroOpenForm::execute
	(	KBError		&pError
	)
{
	KBLocation location 
	(	m_exec->getDBInfo (),
		"form",
		m_exec->getServer (),
		m_args[0]
	)	;

	QDict<QString>	pDict	;
	KBNode		*node	;
	KB::ShowAs	showAs	= m_args[1] == "Design" ?
				KB::ShowAsDesign :
				KB::ShowAsData	 ;

	KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject
						   (	location,
						 	showAs,
					 		pDict,
					 		pError
						   )	;
	fprintf
	(	stderr,
		"Macro::openForm: rc=%d\n",
		(int)rc
	)	;

	if ((rc != KB::ShowRCOK) && (rc != KB::ShowRCCancel))
		return	false	;

	node = KBAppPtr::getCallback()->objectNode(location) ;

	fprintf
	(	stderr,
		"Macro::openForm: node=[%p]\n",
		(void *)node
	)	;

	m_exec->addNode ("form", node) ;
	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroCloseForm							*/
/*  KBMacroCloseForm							*/
/* 		: Macro to close a form					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroCloseForm::KBMacroCloseForm
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "CloseForm")
{
}

/*  KBMacroCloseForm							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroCloseForm::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 1, pError) ;
}

/*  KBMacroCloseForm							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroCloseForm::execute
	(	KBError		&
	)
{
	KBNode	  *node = m_exec->getNode (m_args[0], "form") ;

	if ((node != 0) && (node->isForm() != 0))
		node->isForm()->getDocRoot()->doRequestClose(1) ;

	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroNavigate							*/
/*  KBMacroNavigate							*/
/* 		: Macro to close a form					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroNavigate :					*/

KBMacroNavigate::KBMacroNavigate
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "Navigate")
{
}

/*  KBMacroNavigate							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroNavigate::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 2, pError) ;
}

/*  KBMacroNavigate							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroNavigate::execute
	(	KBError		&
	)
{
	KBNode	  *node = m_exec->getNode (m_args[0], "form")  ;
	if ((node == 0) || (node->isForm() == 0)) return true ;

	const QString	&arg1	= m_args[1] ;
	KB::Action	act	= KB::Null  ;

	if	(arg1 == "First"	) act = KB::First	;
	else if (arg1 == "Previous"	) act = KB::Previous	;
	else if (arg1 == "Next"		) act = KB::Next	;
	else if (arg1 == "Last"		) act = KB::Last	;
	else if (arg1 == "Add"		) act = KB::Add		;
	else if (arg1 == "Save"		) act = KB::Save	;
	else if (arg1 == "Delete"	) act = KB::Delete	;
	else if (arg1 == "Query"	) act = KB::Query	;
	else if (arg1 == "Execute"	) act = KB::Execute	;
	else if (arg1 == "Cancel"	) act = KB::Cancel	;
	else
	{
		KBError::EError
		(	TR("Unrecognised macro ReloadForm action"),
			QString(TR("Action: %1")).arg(m_args[1]),
			__ERRLOCN
		)	;
	}

	if (!node->isForm()->formAction (act))
	{
		node->lastError().DISPLAY() ;
		return	true	;
	}

	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroReloadForm							*/
/*  KBMacroReloadForm							*/
/* 		: Macro to close a form					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroReloadForm:					*/

KBMacroReloadForm::KBMacroReloadForm
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "ReloadForm")
{
}

/*  KBMacroReloadForm							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroReloadForm::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 3, 3, pError) ;
}

/*  KBMacroReloadForm							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroReloadForm::execute
	(	KBError		&
	)
{
	KBNode	  *node = m_exec->getNode (m_args[0], "form")  ;
	if ((node == 0) || (node->isForm() == 0)) return true ;

	node->isForm()->setUserFilter (m_args[1]) ;
	node->isForm()->setUserSorting(m_args[2]) ;

	if (!node->isForm()->requery ())
	{
		node->lastError().DISPLAY() ;
		return	true	;
	}

	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroFormField							*/
/*  KBMacroFormField							*/
/* 		: Class used by form macros that access fields		*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  name	: cchar *	   : Macro Name				*/
/*  (returns)	: KBMacroFormField :					*/

KBMacroFormField::KBMacroFormField
	(	KBMacroExec	*exec,
		cchar		*name
	)
	:
	KBMacroInstr (exec, name)
{
}

/*  KBMacroFormField							*/
/*  getFormField: Locate field						*/
/*  (returns)	: KBItem *	: Item or null on error			*/

KBItem	*KBMacroFormField::getFormField ()
{
	KBNode	 *node	= m_exec->getNode (m_args[0], "form") ;
	if ((node == 0) || (node->isForm() == 0)) return 0 ;

	KBObject *obj	= node->isForm()->getNamedObject(m_args[1]) ;
	if (obj == 0)
	{
		KBError::EError
		(	QString(TR("Field '%1' not found in form")).arg(m_args[1]),
			QString::null,
			__ERRLOCN
		)	;
		return	0 ;
	}

	KBItem  *item	= obj->isItem() ;
	if (item == 0)
	{
		KBError::EError
		(	QString(TR("Field '%1' is not a data control")).arg(m_args[1]),
			QString::null,
			__ERRLOCN
		)	;
		return	0 ;
	}

	return	item	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroSetField							*/
/*  KBMacroSetField							*/
/* 		: Macro to set a field in a form			*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroSetField  :					*/

KBMacroSetField::KBMacroSetField
	(	KBMacroExec	*exec
	)
	:
	KBMacroFormField (exec, "SetField")
{
}

/*  KBMacroSetField							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroSetField::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 3, pError) ;
}

/*  KBMacroSetField							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroSetField::execute
	(	KBError		&
	)
{
	KBItem	*item	= getFormField () ;
	if (item == 0) return true    ;

	QString	value	= m_args[2]   ;
	QString	result	;
	int	offset	= 0 ;
	int	offset2	;

	while ((offset2 = value.find ("[Value]", offset, false)) >= 0)
	{
		result	+= value.mid (offset, offset2 - offset) ;
		result	+= m_exec->getValue("value") ;
		offset	 = offset2 + 7 ;
	}

	result	+= value.mid(offset) ;
	item->setValue (item->getBlock()->getCurQRow(), KBValue(result)) ;

//	if (value == "[Value]") value = m_exec->getValue("value") ;
//	item->setValue (item->getBlock()->getCurQRow(), KBValue(value)) ;

	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroGetField							*/
/*  KBMacroGetField							*/
/* 		: Macro to get a field value				*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroSetField  :					*/

KBMacroGetField::KBMacroGetField
	(	KBMacroExec	*exec
	)
	:
	KBMacroFormField (exec, "GetField")
{
}

/*  KBMacroGetField							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroGetField::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 2, pError) ;
}

/*  KBMacroGetField							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroGetField::execute
	(	KBError		&
	)
{
	KBItem	*item	= getFormField () ;
	if (item == 0) return true    ;

//	QString	value	= m_args[2]   ;
//	if (value == "[Value]") value = m_exec->getValue("value") ;

	m_exec->addValue
	(	"value",
		item->getValue(item->getBlock()->getCurQRow()).getRawText()
	)	;

	return	true	;
}

/*  ------------------------------------------------------------------  */


NEWMACRO(OpenForm )
NEWMACRO(CloseForm)
NEWMACRO(Navigate)
NEWMACRO(ReloadForm)
NEWMACRO(SetField)
NEWMACRO(GetField)

/*  ------------------------------------------------------------------  */

#ifdef	__DOCS
  <macro name="OpenForm">
    <arg type="object:form" legend="Form Name"/>
    <arg type="choice" legend="Mode">
      <choice value="Data"/>
      <choice value="Design"/>
    </arg>
      <![CDATA[
        <h3>Open Form</h3>
        Opens the named form. Control will return immediately, unless the
        form is modal, in which case execution is paused until the user
        closes the form.
      ]]>
  </macro>
  <macro name="CloseForm">
    <arg type="object:form:[Invoker]" legend="Form Name"/>
      <![CDATA[
        <h3>Close Form</h3>
        Closes the named form. If the name is
        <i>[Invoker]</i> and the macro was invoked from a form, then
        that form is closed.
      ]]>
  </macro>
  <macro name="Navigate">
    <arg type="object:form:[Invoker]" legend="Form Name"/>
    <arg type="choice" legend="Record">
      <choice value="First"/>
      <choice value="Previous"/>
      <choice value="Next"/>
      <choice value="Last"/>
      <choice value="Add"/>
      <choice value="Save"/>
      <choice value="Delete"/>
      <choice value="Query"/>
      <choice value="Execute"/>
      <choice value="Cancel"/>
      <choice value="Reload"/>
    </arg>
      <![CDATA[
        <h3>Navigate</h3>
        Navigates through records in a form, and handled associated form
        operations, such as save and delete. If the form name is left
        empty then the form previously opened by the macro is used;
        <i>[Invoker]</i> means the form that invoked the macro.
      ]]>
  </macro>
  <macro name="ReloadForm">
    <arg type="object:form:[Invoker]" legend="Form Name"/>
    <arg type="text" legend="Filter"/>
    <arg type="text" legend="Order"/>
      <![CDATA[
        <h3>Reload Form</h3>
        Reloads the form data. You can optionally set a filter (a valid
        SQL <i>where</i> expression) and a record ordering (a valid
        SQL <i>order by</i> expression).
      ]]>
  </macro>
  <macro name="SetField">
    <arg type="object:form:[Invoker]" legend="Form Name"/>
    <arg type="text" legend="Field Name"/>
    <arg type="text" legend="Value"/>
      <![CDATA[
        <h3>Set Field</h3>
        Use this macro to set a field in a form. If the form name is left
        empty then the form previously opened by the macro is used;
        <i>[Invoker]</i> means the form that invoked the macro. If the
        value is set to <i>[Value]</i> then the value from the last call
        to <i>GetValue</i> or <i>PromptBox</i> will be used.
      ]]>
  </macro>
  <macro name="GetField">
    <arg type="object:form:[Invoker]" legend="Form Name"/>
    <arg type="text" legend="Field Name"/>
      <![CDATA[
        <h3>Set Field</h3>
        Use this macro to get the value from a field in a form.
        If the form name is left empty then the form previously opened
        by the macro is used; <i>[Invoker]</i> means the form that
        invoked the macro. The value is stored in the macro, and can
        be used subsequently by <i>SetValue</i>.
      ]]>
  </macro>
#endif	// __DOCS
