/***************************************************************************
    file	         : kb_attrdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_ATTRDLG_H
#define	__KB_ATTRDLG_H


#include	<qlist.h>
#include	<qstring.h>
#include	<qwidget.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_attritem.h"
#include	"kb_dialog.h"


/*  KBAttrDlg								*/
/*  ---------								*/
/*  This is an abstract base class for property dialogs (strinctly,	*/
/*  plugins to dialogs such as the main properties dialog) used when	*/
/*  editing a property.							*/

class	KBAttrDlg : public QWidget
{
	Q_OBJECT

protected :

	KBAttr			*m_attr		;
	KBAttrItem		*m_item		;
	QDict<KBAttrItem>	&m_attrDict	;

	QString			getAttrVal	(const QString &) ;

public	:

	KBAttrDlg
	(	QWidget			*,
		KBAttr			*,
		KBAttrItem		*,
		QDict<KBAttrItem>	&
	)	;
	virtual	~KBAttrDlg	()		;

	virtual	void		verify		() ;
	virtual	bool		init		() ;
	virtual	void		save		() ;

	virtual	QString		value		() = 0 ;
	virtual	bool		init		(const QString &) = 0 ;

	QString			displayValue	() ;
}	;

/*  KBAttrDlgDialog							*/
/*  ---------------							*/
/*  Wrapper dialog so that KBAttrDlg derived classes can actually run	*/
/*  as real dialogs.							*/

class	KBAttrDlgDialog : public _KBDialog
{
	Q_OBJECT

	KBAttrDlg	*m_attrDlg	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;

protected slots :

	void		accept	()	;
	void		reject	()	;

public	:

	KBAttrDlgDialog	(KBAttrDlg *, const QString &) 	;
	~KBAttrDlgDialog()		;

	int		exec	()	;

	inline	bool	init
		(	const QString	&value
		)
	{
		return	m_attrDlg->init  (value) ;
	}
	inline	QString	value	()
	{
		return	m_attrDlg->value 	() ;
	}
	inline	QString	displayValue	()
	{
		return	m_attrDlg->displayValue () ;
	}
	inline	void	verify	()
	{
		return	m_attrDlg->verify	() ;
	}
}	;

#endif	// __KB_ATTRDLG_H
