/***************************************************************************
    file	         : kb_emitter.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_EMITTER_H
#define	__KB_EMITTER_H


#include	<qobject.h>

#include	"kb_classes.h"


/*  KBEmitter								*/
/*  ---------								*/
/*  This class is used for thr rekall signal slot mechanism, and is	*/
/*  used by the KBEvent class to emit signals. We do it this way so	*/
/*  that we do not need to derive KBEvent from QObject (or embed a	*/
/*  QObject). This would eat a fair amount of memory, since most events	*/
/*  will not emit any signals.						*/

class	KBEmitter : public QObject
{
	Q_OBJECT

	KBObject	*m_parent	;
	KBEvent		*m_event	;

signals	:

	void	eventSignal
		(	KBObject	*,
			const QString	&,
			uint		,
			KBValue		*,
			KB::ScriptRC	&
		)	;

private	:

	KB::ScriptRC
		doSignal
		(	uint		,
			KBValue		*
		)	;

public	:

	KBEmitter	(KBObject *, KBEvent *)	;

	friend	class	KBEvent		;

}	;

#endif	// __KB_EMITTER_H
