/***************************************************************************
    file	         : kb_formblock.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_formblock.moc"
#else
#include	"kb_formblock.h"
#endif

#include	"kb_form.h"
#include	"kb_framer.h"
#include	"kb_layout.h"
#include	"kb_qrybase.h"
#include	"kb_hidden.h"
#include	"kb_rowmark.h"
#include	"kb_display.h"
#include	"kb_nodereg.h"
#include	"kb_popupmenu.h"
#include	"kb_blockevents.h"
#include	"kb_attrdict.h"
#include	"kb_grid.h"

#if		! __KB_RUNTIME
#include	"kb_wizard.h"
#endif


/*  KBFormBlock								*/
/*  KBFormBlock	: Constructor for extant form block element		*/
/*  parent	: KBNode *	: Parent element			*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*		: bool *	:					*/
/*  (returns)	: KBFormBlock	:					*/

KBFormBlock::KBFormBlock
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		cchar			*element,
		bool			*
	)
	:
	KBBlock	   	(parent, aList,		element),
	KBNavigator	(this,   this,		children),
	m_sloppy	(this,   "sloppy",	aList),
	m_blkrdonly	(this,   "blkrdonly",	aList),
	m_tabsWrap	(this,   "tabswrap", 	aList),
	m_locking	(this,	 "locking",	aList, KAF_GRPDATA)
{
	m_curItem  = 0	     ;
	m_inQuery  = false   ;
	m_dChanged = false   ;
	m_prepared = false   ;

	if ((dx.getIntValue() == 0) && (dy.getIntValue() == 0))
			dy.setValue (25) ;
}

/*  KBFormBlock								*/
/*  KBFormBlock	: Constructor for new form block element		*/
/*  parent	: KBObject *	: Parent element			*/
/*  rect	: const QRect &	: Size and position			*/
/*  blkType	: BlkType	: Initial block type			*/
/*  ok		: bool &	: Success				*/
/*  element	: cchar *	: Element name				*/
/*  (returns)	: KBFormBlock	:					*/

KBFormBlock::KBFormBlock
	(	KBObject	*parent,
		const QRect	&rect,
		BlkType		_blkType,
		bool		&ok,
		cchar		*element
	)
	:
	KBBlock		(parent, rect, 	  	_blkType,  ok, element),
	KBNavigator	(this,   this,	  	KBNode::children),
	m_sloppy	(this,   "sloppy",	false),
	m_blkrdonly 	(this,   "blkrdonly",	false),
	m_tabsWrap	(this,   "tabswrap",	false),
	m_locking	(this,	 "locking",	(uint)0, KAF_GRPDATA)
{
	m_curItem  = 0	     ;
	m_inQuery  = false   ;
	m_dChanged = false   ;
	m_prepared = false   ;
}

/*  KBFormBlock								*/
/*  KBFormBlock	: Constructor for extant form block element		*/
/*  _parent	: KBNode *	: Parent element			*/
/*  _block	: KBFormBlock *	: Extant block				*/
/*  (returns)	: KBFormBlock	:					*/

KBFormBlock::KBFormBlock
	(	KBNode		*_parent,
		KBFormBlock	*_block
	)
	:
	KBBlock	   	(_parent, _block),
	KBNavigator	(this,    this,		KBNode::children),
	m_sloppy	(this,    "sloppy",	_block),
	m_blkrdonly 	(this,    "blkrdonly",	_block),
	m_tabsWrap	(this,    "tabswrap",	_block),
	m_locking	(this,	  "locking",	_block, KAF_GRPDATA)
{
	m_curItem  = 0	     ;
	m_inQuery  = false   ;
	m_dChanged = false   ;
	m_prepared = false   ;
}

/*  KBFormBlock								*/
/*  ~KBFormBlock: Destructor for form block element			*/
/*  (returns)	: void		:					*/

KBFormBlock::~KBFormBlock ()
{
}

/*  KBFormBlock								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBFormBlock::showAs
	(	KB::ShowAs	mode
	)
{
	m_prepared = false   	;
	KBBlock::showAs (mode)	;

	if (mode == KB::ShowAsData) 
	{
		fixTabOrder   () ;
		fixGridLayout () ;
		m_curItem = 0	 ;
		m_inQuery = false;
	}

	if (blkDisp != 0)
		blkDisp->setTitle (title.getValue()) ;
}

void	KBFormBlock::prepare ()
{
	m_prepared = true	;
	KBBlock::prepare ()	;
}

/*  KBFormBlock								*/
/*  newTabOrder	: Invoke tab order dialog				*/
/*  (returns)	: void		:					*/

void	KBFormBlock::newTabOrder ()
{
#if	! __KB_RUNTIME
	if (KBNavigator::newTabOrder()) getLayout()->setChanged() ;
#endif
}

/*  KBFormBlock								*/
/*  checkChange	: Check for field changes				*/
/*  doLeaveEvent: bool		: Do leave event on current item	*/
/*  rowDelta	: bool &	: Row was changed and saved		*/
/*  (returns)	: bool		: Success (rather, no error)		*/

bool	KBFormBlock::checkChange
	(	bool	doLeaveEvent,
		bool	&rowDelta
	)
{
	/* NOTE:							*/
	/* On exit from this method, any outstanding transaction will	*/
	/* have been terminated if required (eg., for row update	*/
	/* locking). This is handled locally or within the query	*/
	/* depending on circumstances.					*/

	bool	changed	= false ;

	rowDelta = false  ;

	/* If there is a current item and requested to do so, then	*/
	/* execute the leave event on that item.			*/
	/* FIX: Need to have a tri-state return from checkChange, which	*/
	/*	can now be OK, Error, or Cancel				*/
	if (doLeaveEvent && (m_curItem != 0))
		if (!m_curItem->doLeave (curQRow))
		{
			setError
			(	KBError::Warning,
				TR("Leave event cancelled operation"),
				QString::null,
				__ERRLOCN
			)	;

			/* Note: any transaction is *not* terminated	*/
			/* since this may just be the application	*/
			/* saying a value is not allowed.		*/
			return	false	;
		}

	/* If this is the new row at the end of the query and all	*/
	/* fields are empty, then focus can move out. We just need to	*/
	/* end any transaction, since there is no actual server action.	*/
	if (m_query->newRowEmpty (qryLvl, curQRow))
	{
		return	endUpdate (true) ;
	}

	/* Scan for nested blocks and make sure that they have been	*/
	/* updated. FIXME: Need to recurse down through null blocks.	*/
	CITER
	(	FormBlock,
		b,

		switch (b->getBlkType())
		{
			case BTTable	:
			case BTQuery	:
			case BTSQL	:
				break	;

			case BTNull	:
				break	;

			default		:
				continue;
		}

		bool	dummy	;
		if (!b->checkChange (false, dummy))
		{
			setError  (b->lastError()) ;
			endUpdate (false) ;
			return	  false   ;
		}
	)

	/* Scan all items in the current row to see if any of them	*/
	/* have changed ....						*/
	CITER
	(	Item,
		i,
		if (i->isUpdateVal () && i->changed(curQRow))
		{
			changed	= true	;
			fprintf
			(	stderr,
				"KBFormBlock::checkChange: [%s]\n",
				(cchar *)i->getName()
			)	;
			break	;
		}
	)

	if (!changed)
		CITER
		(	Framer,
			f,
			if (f->changed(curQRow))
			{
				changed	= true	;
				break	;
			}
		)

	/* If nothing has changed then do nothing, except, clear the	*/
	/* dChange flag, as the user might have changed a field like	*/
	/*	mike -> mik -> mike					*/
	/* and also commit any outstanding transaction.			*/
	if (!changed)
	{
		m_dChanged = false ;
		return	endUpdate  (true) ;
	}

	/* Changes have been made, so run either the pre-update hook	*/
	/* or, this is an inserted row, the pre-update hook. After this	*/
	/* we can save into the associated query structure whatever is	*/
	/* in the fields.						*/
	KBValue	aCurQRow ((int)curQRow, &_kbFixed) ;
	KBEvent	*hook	 ;
	bool	evRc	 ;

	if ( (m_query->getRowState(qryLvl, curQRow) == KB::RSInserted) ||
	     (m_query->getNumRows (qryLvl)	    <= curQRow) )
		hook	= &events->preInsert ;
	else	hook	= &events->preUpdate ;

	if (!eventHook (*hook, 1, &aCurQRow, evRc))
	{	endUpdate (false) ;
		return	  false	  ;
	}

	if (!evRc)
	{
		/* False simply means the insert/update does not	*/
		/* proceed, so the transaction state is left unchanged.	*/
		return	true	;
	}

	if (!m_query->saveRow (qryLvl, curQRow))
	{
		setError  (m_query->lastError ()) ;
		endUpdate (false) ;
		return	  false	  ;
	}

	/* If autosync is enabled then call the query to synchronise	*/
	/* the row with the database itself.				*/
	if (autosync.getBoolValue())
	{
		KBValue		*mvp	= getBlockVal () ;
		KB::Action	oper 	;
		KBValue	  	args[3] ;

		// NEEDED ??
		if ((mvp != 0) && mvp->isNull())
		{
			setError
			(	KBError::Warning,
				TR("No parent record: cannot save data"),
				QString::null,
				__ERRLOCN
			)	;
			endUpdate (false) ;
			return	  false	  ;
		}

		/* Synchronise the row. Note that this call will result	*/
		/* in the termination, if needed of any outstanding	*/
		/* transaction, so there is no need beyond this point	*/
		/* to call "endUpdate()".				*/
		if (!m_query->syncRow
			(	qryLvl,
				curQRow,
				mvp,
				cexpr.getValue(),
				this,
				oper,
				args[2]
		   )	)
		{
			setError (m_query->lastError ()) ;
			return	 false ;
		}

		if (oper != KB::Null)
		{
			args[0]	= (int)curQRow	;
			args[1]	= (int)oper	;
			if (!eventHook (events->postSync, 3, args, evRc))
				return false ;

			m_dChanged = false	;
		}

		getLayout ()->setChanged   (false) ;
		getDocRoot()->doSetLocking (m_query->lockingState(qryLvl)) ;
		rowDelta = true ;
	}

	return	true ;
}

/*  KBFormBlock								*/
/*  checkChange	: Check for field changes				*/
/*  doLeaveEvent: bool		: Do leave event on current item	*/
/*  (returns)	: bool		: Success (rather, no error)		*/

bool	KBFormBlock::checkChange
	(	bool	doLeaveEvent
	)
{
	bool	dummy	;
	return	checkChange (doLeaveEvent, dummy) ;
}

/*  KBFormBlock								*/
/*  clearFields	: Clear values in fields in row				*/
/*  qrow	: uint		: Query row				*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::clearFields
	(	uint	qrow,
		bool	query
	)
{
	CITER
	(	Item,
		i,
		i->clearValue  (qrow, query)
	)	;
	CITER
	(	Framer,
		f,
		f->clearFields (qrow, query)
	)	;
}

/*  KBFormBlock								*/
/*  displayData	: Display data for range of rows			*/
/*  force	: bool		: Forcibly redisplay all		*/
/*  fromQRow	: uint		: From query row			*/
/*  toQRow	: uint		: To query row (plus one)		*/
/*  (returns)	: void		:					*/

void	KBFormBlock::displayData
	(	bool	force,
		uint	fromQRow,
		uint	toQRow
	)
{
	uint		_curQRow = curQRow ;

	KBRowMarkData	rmdata	 ;
	rmdata.type	= KBRowMarkData::RowNo ;

	// fprintf
	// (	stderr,
	//	"KBFormBlock::displayData(%d,%d,%d) (at %d/%d)\n",
	//	force,
	//	fromQRow, toQRow, curQRow, curDRow
	// )	;

	/* Redisplay all rows marked as dirty, or all rows if the force	*/
	/* flag is set. Note that the test is such that even if force	*/
	/* is set, any dirty flags will be cleared.			*/
	for (curQRow = fromQRow ; curQRow < toQRow ; curQRow += 1)
	{
		if (blkInfo.rowmark != 0)
		{
			rmdata.rowNo = curQRow ;
			blkInfo.rowmark->setData  (curQRow, (void *)&rmdata) ;
			blkInfo.rowmark->setState (curQRow, m_query->getRowState (qryLvl, curQRow)) ;
		}

		if	(curQRow >= m_query->getNumRows (qryLvl))
		{
			clearFields (curQRow) ;
		}
		else if (m_query->rowIsDirty (qryLvl, curQRow, true) || force)
		{
			m_query->loadItems (qryLvl, curQRow) ;
		}

		bool	marked	= m_query->getRowMarked (qryLvl, curQRow) ;

		CITER
		(	Item,
			i,
			i->setMarked (curQRow, marked)
		)

		bool	evRc  ;
		KBValue	rowNo = (int)curQRow ;
		eventHook (events->onDisplay, 1, &rowNo, evRc) ;
	}

	curQRow	= _curQRow ;

	/* ... and also ensure that the correct row rang is being	*/
	/* displayed.							*/
	uint	extra	= (m_query->getPermission(qryLvl) & QP_INSERT) != 0 ? 1 : 0 ;

	blkInfo.scroll->setRowRange
	(	m_query->getNumRows(qryLvl),
		extra,
		curQRow,
		curDRow,
		nRows
	)	;
}

/*  KBFormBlock								*/
/*  showData	: Display values from query in fields			*/
/*  force	: bool		: Force redisplay of all rows		*/
/*  showRow	: bool		: Scroll to show current row		*/
/*  (returns)	: bool		: Success				*/

bool	KBFormBlock::showData
	(	bool	force,
		bool	showRow
	)
{

	/* See if we need to scroll the display backwards or forwards,	*/
	/* in which case we need to force a complete redisplay.		*/
	if (showRow)
	{
		if (curDRow > curQRow)
		{	curDRow = curQRow ;
			force	= true	  ;
		}
		if (curDRow + nRows <= curQRow)
		{	curDRow = curQRow - nRows + 1 ;
			force	= true	  ;
		}
	}

	displayData (force, curDRow, curDRow + nRows) ;

	/* Scan through for nested blocks, requerying and redisplaying	*/
	/* for each. Note that this method should only be called when	*/
	/* we have moved row or changed a row, in which case the	*/
	/* requery/redisplay is required.				*/
	CITER
	(	FormBlock,
		b,
		if (!b->requery () || !b->showData (true))
		{	setError (b->lastError()) ;
			return   false ;
		}
	)
	CITER
	(	Framer,
		f,
		if (!f->showData ())
		{	setError (f->lastError()) ;
			return   false ;
		}
	)

	uint	extra	= (m_query->getPermission(qryLvl) & QP_INSERT) != 0 ? 1 : 0 ;
	CITER
	(	Item,
		i, 
		i->hideBelow (m_query->getNumRows(qryLvl) + extra)
	) ;
	CITER
	(	Framer,
		f, 
		f->hideBelow (m_query->getNumRows(qryLvl) + extra)
	) ;


	return	true ;
}

/*  KBFormBlock								*/
/*  moveFocusOK	: Query focus movement					*/
/*  item	: KBItem *	: Item which has gained focus		*/
/*  drow	: uint		: Field row number			*/
/*  (return)	: bool		: Focus allowed				*/

bool	KBFormBlock::moveFocusOK
	(	KBItem	*item,
		uint	drow
	)
{
	/* May not be a form if we are in a component ...		*/
	if (getForm() == 0)
		return	true	;

	/* This routine propogates information up to the root node,	*/
	/* which can then decide who needs to know what about the	*/
	/* focus change, if any.					*/
	if (getForm()->moveFocusOK (item, curDRow + drow))
	{
		/* Special case: If focus is moving into a rowmark then	*/
		/* explicitely ensure that there are no morphed		*/
		/* controls.						*/
		if (item->isRowMark() != 0) getLayout()->setUnMorphedItem (0, 0) ;
		return	true	;
	}

	return	false	;
}

/*  KBFormBlock								*/
/*  focusOutOK	: Check whether focus can move out of control		*/
/*  newRow	: bool		: Moving to a different row		*/
/*  (return)	: bool		: No update errors			*/

bool	KBFormBlock::focusOutOK
	(	bool	newRow
	)
{
	/* May not be a form if we are in a component ...		*/
	if (getForm() == 0)
		return	true	;

	/* There is no checking when in a query, so that (for example)	*/
	/* non-nul fields can be left blank, and numbers entered as	*/
	/* "> 666".							*/
	if (m_inQuery)
		return true ;

	/* Check whether the current item has changed and if so mark	*/
	/* the form as changed.						*/
	markChanged () ;

	/* If this is the new row at the end of the query and all	*/
	/* fields are empty, then focus can move out.			*/
	if (m_query->newRowEmpty (qryLvl, curQRow))
		return	 true  ;


	if ((m_curItem != 0) && !m_curItem->doLeave (curQRow))
		return	false ;

	/* Check whether the current item has valid contents, if not	*/
	/* report the error and fail.					*/
	if ((m_curItem != 0) && !m_curItem->isValid (curQRow, true))
	{
		setError (m_curItem->lastError ()) ;
		lastError().DISPLAY() ;
		return	 false ;
	}

	/* If we are changing rows, then see if there have been any	*/
	/* changes in the current row which need to be saved to the	*/
	/* database.							*/
	if (newRow && !checkChange (false))
	{
		lastError().DISPLAY() ;
		return	 false ;
	}

	if (blkInfo.rowmark != 0)
		blkInfo.rowmark->setState (curQRow, m_query->getRowState (qryLvl, curQRow)) ;

	return	true	;
}

/*  KBFormBlock								*/
/*  startUpdate	: Check if update can be started			*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: bool		: True if OK to update			*/

bool	KBFormBlock::startUpdate
	(	uint		qrow
	)
{
//	fprintf
//	(	stderr,
//		"KBFormBlock::startUpdate: qrow=%d dChanged=%d locking=%d\n",
//		qrow,
//		m_dChanged,
//		m_locking.getIntValue()
//	)	;

	/* Paranoia check .... should not get called unless in data	*/
	/* view, but in case ...					*/
	if (!showingData())
		return	true	;

	/* If the data has already changed then we are already in an	*/
	/* update and can proceed. If the data has not changed so see	*/
	/* what locking option is in effect.				*/
	if (m_dChanged)
		return	true	;

	bool	rc = true	;

	switch ((KBQryBase::Locking)m_locking.getIntValue())
	{
		case KBQryBase::NoLocking	:
			/* No locking so no problems, we can allow the	*/
			/* update.					*/
			break	;

		case KBQryBase::LockRowUpdate	:
			/* Lock on change in effect, see if we can	*/
			/* start an update. If OK then the query will	*/
			/* set the record to the current values, so	*/
			/* the data is redisplayed.			*/
			if (!m_query->startUpdate (qryLvl, qrow, KBQryBase::LockRowUpdate))
			{
				setError (m_query->lastError()) ;
				showData (false) ;
				rc	= false	 ;
			}
			break	;

		default	:
			break	;
	}

	getDocRoot()->doSetLocking (m_query->lockingState(qryLvl)) ;
	return	rc	;
}

bool	KBFormBlock::endUpdate
	(	bool		commit
	)
{
	fprintf
	(	stderr,
		"KBFormBlock::endUpdate: commit=%d dChanged=%d locking=%d\n",
		commit,
		m_dChanged,
		m_locking.getIntValue()
	)	;

	bool	rc = true	;

	switch ((KBQryBase::Locking)m_locking.getIntValue())
	{
		case KBQryBase::NoLocking	:
			/* No locking so nothing needs to be done ...	*/
			break	;

		case KBQryBase::LockRowUpdate	:
			/* Lock on change in effect, so we should be	*/
			/* ending the update at the query.		*/
			if (!m_query->endUpdate (qryLvl, commit))
			{
				setError(m_query->lastError()) ;
				showData(false)	;
				rc	= false	;
			}
			break	;

		default	:
			break	;
	}

	getDocRoot()->doSetLocking (m_query->lockingState(qryLvl)) ;
	return	true	;
}

/*  KBFormBlock								*/
/*  focusMovesRow: Focus moves into a new query row			*/
/*  newQRow	 : uint		: New row				*/
/*  (returns)	 : void		:					*/

void	KBFormBlock::focusMovesRow
	(	uint		newQRow
	)
{
	bool	evRc	;
	KBValue	argOld	((int)curQRow) ;
	KBValue	argNew	((int)newQRow) ;

	eventHook (events->onUnCurrent, 1, &argOld, evRc) ;

	curQRow	= newQRow ;
	m_query->setCurrentRow (qryLvl, curQRow) ;
	if (!showData(true)) lastError().DISPLAY() ;

	eventHook (events->onCurrent,   1, &argNew, evRc) ;
}

/*  KBFormBlock								*/
/*  focusMovesItem: Focus moves into a new data control			*/
/*  item	  : KBItem *	: Item					*/
/*  reason	  : Reason	: Reason focus moved			*/
/*  (returns)	  : void	:					*/

void	KBFormBlock::focusMovesItem
	(	KBItem			*item,
		QFocusEvent::Reason	reason
	)
{
	QRect	rCtrl  ;

	/* May not be a form if we are in a component ...		*/
	if (getForm() == 0)
		return	;

	/* Ensure that any rowmark is showing the correct current item.	*/
	if (blkInfo.rowmark != 0)
		blkInfo.rowmark->setCurrent (curQRow, true) ;

	/* If focus is arriving in an item other than a row mark then	*/
	/* all marks are cleared. Hence, only row marks are used for	*/
	/* selecting multiple rows.					*/
	if (item->isRowMark() == 0) setRowMarked (0, KB::MarkOpClear) ;

	m_curItem	= item ;
	getForm()->focusInEvent  (m_curItem, curQRow) ;
	getForm()->setFocusAtRow (this) ;

	switch (reason)
	{
		case QFocusEvent::ActiveWindow	:
		case QFocusEvent::Other		:
			break	;

		default	:
			/* Try to make sure that the current item and	*/
			/* row therein is visible. This can have an	*/
			/* affect if the display is a scroll view.	*/
			if (m_curItem->ctrlGeometry (curQRow, rCtrl))
				blkDisp->makeVisible (rCtrl, reason) ;
			break	;
	}
}

/*  KBFormBlock								*/
/*  focusInEvent: Note arrival of focus in item				*/
/*  item	: KBItem *	: Item in question			*/
/*  drow	: uint		: Display row in item			*/
/*  reason	: Reason	: Reason focus arrives			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::focusInEvent
	(	KBItem			*item,
		uint			drow,
		QFocusEvent::Reason	reason
	)
{
	if (curQRow != drow + curDRow)
		focusMovesRow (drow + curDRow) ;

	focusMovesItem (item, reason) ;
}

/*  KBFormBlock								*/
/*  getBlockVal	: Get block value pointer				*/
/*  (returns)	: KBValue *	: Value pointer or null at top level	*/

KBValue	*KBFormBlock::getBlockVal ()
{

	KBBlock	*parent	= getBlock () ;
	if ((parent == 0) || (parent->getBlkType() == BTNull))
		return	0 ;

	static	KBValue	mValue	;
	mValue	= parent->getRowValue (this, parent->getCurQRow()) ;
	return	&mValue	;
}

/*  KBFormBlock								*/
/*  getValue	: Get value						*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBFormBlock::getValue
	(	uint	qrow
	)
{
	return	m_query->getField (qryLvl, qrow, qryIdx.qryIdx()) ;
}

/*  KBFormBlock								*/
/*  setValue	: Set value display row					*/
/*  qrow	: uint		 : Query row				*/
/*  value	: const KBValue &: Value to set				*/
/*  (returns)	: bool		 : Success				*/

bool	KBFormBlock::setValue
	(	uint		,
		const KBValue	&
	)
{
	return	true	;
}

/*  KBFormBlock								*/
/*  newNode	: Add a new node					*/
/*  id		: int		: Actually NodeSpec pointer for node	*/
/*  (returns)	: KBNode *	: The new node				*/

KBNode	*KBFormBlock::newNode
	(	int	id
	)
{
#if	! __KB_RUNTIME

	NodeSpec	*spec	= (NodeSpec *)id ;
	QRect		cRect	= newCtrlRect () ;
	KBAttrDict	aDict	(0) ;
	bool		ok	;
	KBNode		*node	;

	aDict.addValue ("x", 	    cRect.x     ()) ;
	aDict.addValue ("y", 	    cRect.y     ()) ;
	aDict.addValue ("w", 	    cRect.width ()) ;
	aDict.addValue ("h", 	    cRect.height()) ;

	aDict.addValue ("taborder", m_tabList.count () + 1) ;
	aDict.addValue ("align",    Qt::AlignLeft ) ;

	node	= spec->nodeFunc (this, aDict, &ok) ;

	if (!ok) return 0 ;

	KBObject *obj ;
	if ((obj = node->isObject()) != 0)
	{
		obj->buildDisplay (blkDisp) ;
		buildCtrls (0, 0, 0) ;

		if (obj->getTabOrder() > 0) m_tabList.append (obj) ;
	}

	node->showAs 	   (KB::ShowAsDesign) ;
	getLayout()->setChanged() ;

	fixTabOrder   () ;
	fixGridLayout () ;

	if (obj != 0)
		getLayout()->addSizer (obj->getSizer(), true) ;

	return	node	 ;
#else
	return	0 ;
#endif
}

/*  KBFormBlock								*/
/*  replicate	: Replicate the block					*/
/*  _parent	: KBNode *	: Parent node				*/
/*  (returns)	: KBNode *	: Replicant				*/

KBNode	*KBFormBlock::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBFormBlock (_parent, this)) ;
}

/*  KBFormBlock								*/
/*  docPropDlg	: Show form property dialog				*/
/*  (returns)	: void		:					*/

void	KBFormBlock::docPropDlg ()
{
#if	! __KB_RUNTIME
	getForm()->propertyDlg (0) ;
#endif
}

/*  KBFormBlock								*/
/*  newNullBlock: Add a new menu block					*/
/*  (returns)	: void		:					*/

void	KBFormBlock::newNullBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  ;
	KBBlock	*b = new KBFormBlock (this, newCtrlRect(), KBBlock::BTNull, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (blkDisp) ;
	b->showAs   (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFormBlock								*/
/*  newTableBlock: Add a new table block				*/
/*  (returns)	 : void		:					*/

void	KBFormBlock::newTableBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  ;
	KBBlock	*b = new KBFormBlock (this, newCtrlRect(), KBBlock::BTTable, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (blkDisp) ;
	b->showAs   (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFormBlock								*/
/*  newQueryBlock: Add a new query block				*/
/*  (returns)	 : void		:					*/

void	KBFormBlock::newQueryBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  ;
	KBBlock	*b = new KBFormBlock (this, newCtrlRect(), KBBlock::BTQuery, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (blkDisp) ;
	b->showAs   (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFormBlock								*/
/*  newSQLBlock	: Add a new SQL block					*/
/*  (returns)	: void		:					*/

void	KBFormBlock::newSQLBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  ;
	KBBlock	*b = new KBFormBlock (this, newCtrlRect(), KBBlock::BTSQL, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (blkDisp) ;
	b->showAs   (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFormBlock								*/
/*  newContainer : Add a new container					*/
/*  (returns)	 : void		:					*/

void	KBFormBlock::newContainer ()
{
#if	! __KB_RUNTIME
	QRect	   r	 = newCtrlRect () ;
	KBAttrDict cDict ;

	cDict.addValue ("x",	r.x     ()) ;
	cDict.addValue ("y",	r.y	()) ;
	cDict.addValue ("w",	r.width ()) ;
	cDict.addValue ("h",	r.height()) ;


	bool	 ok ;
	KBFramer *c = new KBContainer (this, cDict, "KBContainer", &ok) ;
	if (!ok) return ;

	c->buildDisplay (blkDisp) ;
	c->showAs   (KB::ShowAsDesign) ;
	c->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFormBlock								*/
/*  newViaWizard : Add a subform using the subform wizard		*/
/*  (returns)	 : void		:					*/

void	KBFormBlock::newViaWizard ()
{
#if	! __KB_RUNTIME && 0
	QRect	   r	 = newCtrlRect () ;
	KBAttrDict cDict ;

	cDict.addValue ("x",	r.x     ()) ;
	cDict.addValue ("y",	r.y	()) ;
	cDict.addValue ("w",	r.width ()) ;
	cDict.addValue ("h",	r.height()) ;

	KBLocation	location   = getDocRoot()->getLocation() ;

	extern	bool	execWizardByName
			(	cchar		*,
				KBLocation	&,
				const QString	&
			)	;

	KBWizard *subFormWiz	= KBWizardReg::makeWizard
				  (	"SubForm",
					location,
					location.docLocn
				  )	;
	if (subFormWiz == 0)
	{
		fprintf
		(	stderr,
			"KBFormBlock::newViaWizard: not found\n"
		)	;
		return	;
	}

	subFormWiz->setCookie ("query", getQuery()) ;
	subFormWiz->execute   () ;

#endif
}

/*  KBFormBlock								*/
/*  makeNewPopup: Make a new-thingy popup menu for a form		*/
/*  cancel	: bool		: Show cancel item			*/
/*  _rect	: QRect		: New object area			*/
/*  (returns)	: void		:					*/

KBPopupMenu
	*KBFormBlock::makeNewPopup
	(	bool	cancel,
		QRect	_rect
	)
{
#if	! __KB_RUNTIME
	extern void 	makeFormMenu (QPopupMenu *, QObject *, uint) ;

	KBPopupMenu	*newPopup = new KBPopupMenu (&bState) ;
	KBPopupMenu	*blkPopup = new KBPopupMenu (&bState) ;

	blkPopup->insertEntry    (false,    TR("&Menu Block" ), this, SLOT(newNullBlock ())) ;
	blkPopup->insertEntry    (false,    TR("&Table Block"), this, SLOT(newTableBlock())) ;
	blkPopup->insertEntry    (false,    TR("&Query Block"), this, SLOT(newQueryBlock())) ;
	blkPopup->insertEntry    (false,    TR("&SQL Block"  ), this, SLOT(newSQLBlock  ())) ;
	blkPopup->insertEntry    (false,    TR("&Container"  ), this, SLOT(newContainer ())) ;
//	blkPopup->insertEntry    (false,    TR("Use &wizard" ), this, SLOT(newViaWizard ())) ;


	if (cancel)
		newPopup->insertItem (TR("Cancel")) ;


	newPopup->insertItem      (TR("New B&lock"), blkPopup) ;
	newPopup->insertSeparator () ;

//	makeFormMenu (newPopup, this, KF_BLOCK|KF_STATIC|(blkType != BTNull ? KF_DATA : 0)) ;
	makeFormMenu (newPopup, this, KF_BLOCK|KF_STATIC|KF_DATA) ;

	if (cancel)
	{
		newPopup->insertSeparator () ;
		newPopup->insertEntry     (false,  TR("Paste component"), this, SLOT(pasteComponent())) ;
		newPopup->insertEntry     (false,  TR("Link component"),  this, SLOT(linkComponent ())) ;
	}

	newRect	 = _rect ;
	insertAt = _rect.topLeft () ;
	return	newPopup ;
#else
	return	0 ;

#endif
}

/*  KBFormBlock								*/
/*  resize	: Resize the block in its parent			*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBFormBlock::resize
	(	int	w,
		int	h
	)
{
	if (KBBlock::resize (w, h))
	{
		if (rowcount.getIntValue() == 0)
			changeSizes () ;

		return	true	;
	}

	return	false	;
}

/*  KBFormBlock								*/
/*  remChild	: Remove a child node					*/
/*  child	: KBNode *	: Child in question			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::remChild
	(	KBNode	*child
	)
{
	KBBlock::remChild (child) ;
}

/*  KBFormBlock								*/
/*  blockSetup	: Form block setup					*/
/*  (returns)	: bool		: Success				*/

bool	KBFormBlock::blockSetup ()
{
	/* We implement this in order to check for a grid header, in	*/
	/* which case the layout and header will need fixing up.	*/
	fixGridLayout()	;

	return	KBBlock::blockSetup() ;
}

/*  KBFormBlock								*/
/*  enterBlock	: Focus enters block					*/
/*  move	: bool		: True to move focus to first item	*/
/*  toRow	: uint		: Goto row on move			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::enterBlock
	(	bool		move,
		uint		toRow
	)
{
	KBItem	*first	;

	if (move)
		if ((first = firstItem ()) != 0)
		{
			m_curItem = first	;
			curQRow	  = toRow	;
			getForm()->focusInEvent (m_curItem, curQRow) ;
			m_curItem->giveFocus    (curQRow) ;
		}

	getForm()->setFocusAtRow (this) ;
}

/*  KBFormBlock								*/
/*  markChanged	: Check for marking change when changing focus		*/
/*  (returns)	: void		:					*/

void	KBFormBlock::markChanged ()
{
	/* If there is a current item and it has changed then mark the	*/
	/* form as changed (unless we are in a query).			*/
	if (!m_inQuery || (m_curItem == 0) || !m_curItem->changed(curQRow))
		return	;

	/* Also ignore changes if the associated query is the null	*/
	/* (menu-only) query.						*/
	if (m_query->isQryNull() != 0)
		return	;

	getLayout()->setChanged() ;
}

/*  KBFormBlock								*/
/*  sortByColumn: Sort data by column					*/
/*  column	: KBItem *	: Item for column			*/
/*  asc		: bool		: Sort ascending			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::sortByColumn
	(	KBItem		*column,
		bool		asc
	)
{
	m_query->sortByColumn  (qryLvl, column->getQueryIdx(), asc, column) ;

	curQRow	= 0	;
	curDRow	= 0	;
	m_query->setCurrentRow (qryLvl, 0) ;
	if (!showData (true)) lastError().DISPLAY() ;
}

/*  KBFormBlock								*/
/*  rowsInBlock	: Calculate number of rows that can be displayed	*/
/*  (returns)	   : void	:					*/

uint	KBFormBlock::rowsInBlock ()
{
	if (blkDisp != 0)
	{
		QSize	s	= blkDisp->effectiveSize() ;
		uint	_bw	= s .width	 () ;
		uint	_bh	= s .height	 () ;
		int	_dx	= dx.getIntValue () ;
		int	_dy	= dy.getIntValue () ;

		uint	nr	;

		/* If the block does not have a specific number of	*/
		/* rows then find the maximum number that can be	*/
		/* displayed based on the embedded items, and any	*/
		/* embedded framers					*/
		if ((nr = rowcount.getIntValue()) == 0)
		{
			nr = 999 ;

			CITER
			(	Item,
				i,
				{	uint _nr = i->calcNumRows (_bw, _bh, _dx, _dy) ;
					if (_nr < nr) nr = _nr ;
				}
			)

			CITER
			(	Framer,
				f,
	
				uint _nr = f->rowsInFrame (_dx, _dy) ;
				if (_nr < nr) nr = _nr ;
			)

//			fprintf	(stderr, "KBBlock::rowsInBlock => %d\n", nr) ;

			if (nr >= 999) nr = 1 ;
			if (nr <=   0) nr = 1 ;
		}

		return	nr ;
	}

	uint	nr = rowcount.getIntValue() ;
	return	nr == 0 ? 999 : 0 ;
}

/*  KBFormBlock								*/
/*  setRowMarked: Row marking operation					*/
/*  qrow	: uint		: Query row number			*/
/*  op		: KB::MarkOp	: Mark operation			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::setRowMarked
	(	uint		qrow,
		KB::MarkOp	op
	)
{
	m_query->setRowMarked (qryLvl, qrow, op) ;

	for (uint drow = 0 ; drow < nRows ; drow += 1)
	{
		uint	qrow	= curDRow + drow ;
		bool	marked	= m_query->getRowMarked (qryLvl, qrow) ;

		CITER
		(	Item,
			i,
			i->setMarked    (qrow, marked)
		)
	}

	CITER
	(	Framer,
		f,
		f->setRowMarked (curDRow, curDRow + nRows) ;
	)
}

/*  KBFormBlock								*/
/*  getRowMarked: Get row marked state					*/
/*  qrow	: uint		: Query row number			*/
/*  (returns)	: bool		: True if marked			*/

bool	KBFormBlock::getRowMarked
	(	uint		qrow
	)
{
	return	m_query->getRowMarked (qryLvl, qrow) ;
}

/*  KBFormBlock								*/
/*  requery	: (Re)query associated query for all rows		*/
/*  (returns)	: bool		  : Success				*/

bool	KBFormBlock::requery ()
{
	KBGrid	*grid	= 0 ;

	if (!KBBlock::requery ()) return false ;

	CITER
	(	Grid,
		g,
		grid = g ; break ;
	)

	if (grid != 0) grid->columnSort () ;
	
	return	true ;
}

/*  KBFormBlock								*/
/*  dataChanged	: User has changed data in this block			*/
/*  qrow	: uint		: Query row number			*/
/*  (returns)	: void		:					*/

void	KBFormBlock::dataChanged
	(	uint	qrow
	)
{
	if (!m_dChanged)
	{
		bool	evRc  ;
		KBValue	rowNo = (int)qrow ;
		eventHook (events->onChange, 1, &rowNo, evRc) ;

		m_dChanged = true ;
	}
}

void	KBFormBlock::getResults
	(	const QString	&path,
		QDict<QString>	&dict
	)
{
	QString	prefix	= QString("%1%2").arg(path).arg(path.isEmpty() ? "" : ".") ;

	fprintf
	(	stderr,
		"KBFormBlock::getResults: [%s]\n",
		(cchar *)prefix
	)	;

	CITER
	(
		Item,
		item,

		if (item->isBlock() == 0)
			dict.insert
			(	QString	("%1%2")
					.arg(prefix)
					.arg(item->getName()),
				new QString(item->getValue(curQRow).getRawText())
			)	;
	)

	CITER
	(
		Framer,
		framer,
		framer->getResults
		(	QString	("%1%2").arg(prefix).arg(framer->getName()),
			dict
		)	;
	)

	CITER
	(
		FormBlock,
		block,
		block->getResults
		(	QString	("%1%2").arg(prefix).arg(block->getName()),
			dict
		)	;
	)
}

#if	! __KB_RUNTIME

/*  KBFormBlock								*/
/*  playerAdd	: Perform addition from a score				*/
/*  action	: const QString		: Action			*/
/*  args	: const QStringList &	: Arguemnts			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	; bool			: Success			*/

bool	KBFormBlock::playerAdd
	(	const QStringList	&args,
		KBError			&pError
	)
{
	if (args[1] == "KBHidden")
	{
		KBAttrDict aDict;
		aDict.addValue ("name", args[2]) ;
		aDict.addValue ("expr", args[3]) ;
		new KBHidden   (this, aDict,  0) ;
		return	true	;
	}

	setCtrlRect
	(	QRect
		(	args[2].toInt(), args[3].toInt(),
			args[4].toInt(), args[5].toInt()
	)	)	;

	if (args[1] == "KBFormBlock.null" )
	{
		newNullBlock ()	;
		return	true	;
	}
	if (args[1] == "KBFormBlock.table")
	{
		newTableBlock()	;
		return	true	;
	}
	if (args[1] == "KBFormBlock.query")
	{
		newQueryBlock()	;
		return	true	;
	}
	if (args[1] == "KBContainer")
	{
		newContainer ()	;
		return	true	;
	}

	extern	 NodeSpec  *findFormNodeSpec (const QString &) ;
	NodeSpec *nSpec	  = findFormNodeSpec (args[1]) ;

	if (nSpec == 0)
	{
		pError	= KBError
			  (	KBError::Error,
				"Unknown node type in form block",
				args[1],
				__ERRLOCN
			  )	;
		return	false	;
	}

	newNode ((int)nSpec) ;
	return	true	;
}

#endif

NEWNODENAMED	(FormBlock,   (cchar *)0, KF_FORM,   FormBlock	 )
NEWNODENAMED	(FormBlock,   (cchar *)0, KF_FORM,   FormSubBlock)
