/***************************************************************************
    file	         : kb_framer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qframe.h>
#include	<qpopupmenu.h>
#include	<qpainter.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_reportblock.h"
#include	"kb_rowmark.h"

#include	"kb_form.h"
#include	"kb_report.h"
#include	"kb_component.h"

#ifndef 	_WIN32
#include 	"kb_framer.moc"
#else
#include 	"kb_framer.h"
#endif

#include	"kb_tabber.h"
#include	"kb_nodereg.h"
#include	"kb_report.h"
#include	"kb_layout.h"
#include	"kb_options.h"
#include	"kb_qrybase.h"
#include	"kb_writer.h"

#if		! __KB_RUNTIME
#include	"kb_framerdlg.h"
#include	"kb_formcopier.h"
#include	"kb_popupmenu.h"
#endif


/*  KBFramer								*/
/*  KBFramer	: Constructor for framer node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBFramer	:					*/

KBFramer::KBFramer
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		cchar			*element,
		bool			*
	)
	:
	KBObject 	(parent, element,		aList),
	KBNavigator	(this,   getFormBlock(),	children),
	bgcolor	 	(this,   "bgcolor",		aList),
	title		(this,   "title",		aList, KF_FORM),
	frame		(this,   "frame",		aList, KF_FORM),
	showbar		(this,   "showbar",	  	aList, KF_FORM),
	tabOrd		(this,   "taborder",	  	aList, KF_FORM)
{
	frmDisp	= 0 ;
	query	= 0 ;
	qryLvl	= 0 ;
	numRows	= 0 ;
	blkInfo	= 0 ;

/**/	attribs.remove (&showbar) ;
}

/*  KBFramer								*/
/*  KBFramer	: Consructor for framer node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  frame	: KBFramer *	: Extant framer				*/
/*  (returns)	: KBFramer	:					*/

KBFramer::KBFramer
	(	KBNode	  *parent,
		KBFramer  *framer
	)
	:
	KBObject 	(parent, 			framer),
	KBNavigator	(this,	parent == 0 ?
				0 :
				parent->isFormBlock(),	children),
	bgcolor	 	(this,	"bgcolor",		framer),
	title		(this,   "title",		framer, KF_FORM),
	frame		(this,  "frame",		framer, KF_FORM),
	showbar		(this,  "showbar",	  	framer, KF_FORM),
	tabOrd		(this,   "taborder",	  	framer, KF_FORM)
{
	frmDisp	= 0 ;
	query	= 0 ;
	qryLvl	= 0 ;
	numRows	= 0 ;
	blkInfo	= 0 ;

/**/	attribs.remove (&showbar) ;
}

/*  KBFramer								*/
/*  ~KBFramer	: Destructor for framer node				*/
/*  (returns)	:		:					*/

KBFramer::~KBFramer ()
{
	DELOBJ	(frmDisp) ;
}

/*  KBFramer								*/
/*  remChild	: Remove a child node					*/
/*  child	: KBNode *	: Child in question			*/
/*  (returns)	: void		:					*/

void	KBFramer::remChild
	(	KBNode	*child
	)
{
	/* Intercept this call since, if the is an item, then we must	*/
	/* notify our query, and we also need to check for various	*/
	/* specific pointers.						*/
	if ((query != 0) && (child->isItem () != 0))
		query->remItem (qryLvl, child->isItem()) ;

	KBObject::remChild (child) ;
}

/*  KBFramer								*/
/*  framerSetup	: Set up prior to execution				*/
/*  _query	: KBQryBase *	: Associated query			*/
/*  _qryLvl	: uint		: Level in query			*/
/*  _blkInfo	: KBBlockInfo *	: Block information			*/
/*  (returns)	: bool		: Success				*/

bool	KBFramer::framerSetup
	(	KBQryBase	*_query,
		uint		_qryLvl,
		KBBlockInfo	*_blkInfo
	)
{
	query	= _query  ;
	qryLvl	= _qryLvl ;
	blkInfo	= _blkInfo;

	/* Scan to see if there is a rowmark, so that row marks can be	*/
	/* placed in containers as well as blocks ...			*/
	CITER
	(	RowMark,
		r,
		_blkInfo->rowmark = r ;
	)

	if (showbar.getBoolValue())
		blkInfo->scroll = frmDisp ;

	fixGridLayout () ;

	/* Finally, recurse down to all nested blocks and framers.	*/
	/* This process will traverse the entire tree of blocks and	*/
	/* header, footers, etc.					*/
	CITER
	(	Block,
		b,
		if (!b->blockSetup())
		{	setError (b->lastError ()) ;
			return false ;
		}
	)
	CITER
	(	Framer,
		f,
		if (!f->framerSetup (query, qryLvl, _blkInfo))
		{	setError (f->lastError ()) ;
			return false ;
		}
	)

	return	true	;
}

/*  KBFramer								*/
/*  addAllItems	: Add all items to the query				*/
/*  (returns)	: bool		: Any item fetches from database	*/

bool	KBFramer::addAllItems ()
{
	bool	fetch	= false	;

	CITER
	(	Item,
		i,
		if (query->addItem (qryLvl, i)) fetch = true ;
	)

	/* We recurse down into nested framers. Note that items in	*/
	/* framers are at the same query level as the block in which	*/
	/* they are embedded.						*/
	CITER
	(
		Framer,
		f,
		if ( f->addAllItems ()) fetch = true  ;
	)

	/* Also recurse down into nested blocks ...			*/
	CITER
	(
		Block,
		b,
		if (!b->addAllItems ()) fetch = false ;
	)

	return	fetch	;
}

/*  KBFramer								*/
/*  replicate	: Replicate this framer					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New framer node			*/

KBNode	*KBFramer::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBFramer (_parent, this)) ;
}

#if	! __KB_RUNTIME

/*  KBFramer								*/
/*  newCtrlRect	: Get rectangle for new control				*/
/*  (returns)	: QRect		: Rectangle				*/

QRect	KBFramer::newCtrlRect ()
{
	return	newRect == QRect() ?
		getLayout()->newCtrlRect (this, bState, QRect (10, 10, 300, 200)) :
		newRect	;
}

/*  KBFramer								*/
/*  setCtrlRect	: set rectangle for new control				*/
/*  rect	: QRect		: Rectangle				*/
/*  (returns)	: void		:					*/

void	KBFramer::setCtrlRect
	(	QRect		rect
	)
{
	newRect	= rect	;
}


/*  KBFramer								*/
/*  playerAdd	: Perform addition from a score				*/
/*  action	: const QString		: Action			*/
/*  args	: const QStringList &	: Arguemnts			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	; bool			: Success			*/

bool	KBFramer::playerAdd
	(	const QStringList	&args,
		KBError			&pError
	)
{
	setCtrlRect
	(	QRect
		(	args[2].toInt(), args[3].toInt(),
			args[4].toInt(), args[5].toInt()
	)	)	;

	if (args[1] == "KBFormBlock.table")
	{
		newTableBlock()	;
		return	true	;
	}
	if (args[1] == "KBFormBlock.query")
	{
		newQueryBlock()	;
		return	true	;
	}
	if (args[1] == "KBContainer")
	{
		newContainer ()	;
		return	true	;
	}

	extern	 NodeSpec  *findFormNodeSpec (const QString &) ;
	NodeSpec *nSpec	  = findFormNodeSpec (args[1]) ;

	if (nSpec == 0)
	{
		pError	= KBError
			  (	KBError::Error,
				"Unknown node type in framer",
				args[1],
				__ERRLOCN
			  )	;
		return	false	;
	}

	newNode ((int)nSpec) ;
	return	true	;
}

#endif

/*  KBFramer								*/
/*  newNode	: Add a new node					*/
/*  id		: int		: Actually NodeSpec pointer for node	*/
/*  (returns)	: KBNode *	: The new node				*/

KBNode	*KBFramer::newNode
	(	int	id
	)
{
#if	! __KB_RUNTIME
	NodeSpec	*spec	= (NodeSpec *)id ;
	QRect		cRect	= newCtrlRect () ;
	KBAttrDict	aDict	(0) ;
	bool		ok	;
	KBNode		*node	;

	aDict.addValue ("x", 	    cRect.x     ()) ;
	aDict.addValue ("y", 	    cRect.y     ()) ;
	aDict.addValue ("w", 	    cRect.width ()) ;
	aDict.addValue ("h", 	    cRect.height()) ;

	aDict.addValue ("taborder", m_tabList.count () + 1) ;

	aDict.addValue ("rowcount", 1) ;
	aDict.addValue ("dx",	    0) ;
	aDict.addValue ("dy",	    0) ;

	node	= spec->nodeFunc (this, aDict, &ok) ;

	if (!ok) return 0 ;

	if (node->isObject())
	{
		node->isObject()->buildDisplay (frmDisp) ;
		getBlock ()->buildCtrls (0, 0, 0) ;
	}

	getLayout()->setChanged() ;

	node->showAs  (KB::ShowAsDesign) ;

	fixTabOrder   () ;
	fixGridLayout () ;

	if (node->isObject())
		getLayout()->addSizer (node->isObject()->getSizer(), true) ;

	return	node	 ;
#else
	return	0 ;
#endif
}

/*  KBFramer								*/
/*  docPropDlg	: Show document property dialog				*/
/*  (returns)	: void		:					*/

void	KBFramer::docPropDlg ()
{
#if	! __KB_RUNTIME
	getRoot()->isObject()->propertyDlg () ;
#endif
}

/*  KBFramer								*/
/*  blockPropDlg: Show block property dialog				*/
/*  (returns)	: void		:					*/

void	KBFramer::blockPropDlg ()
{
#if	! __KB_RUNTIME
	getBlock()->blockPropDlg () ;
#endif
}

/*  KBFramer								*/
/*  framerPropDlg: Show framer property dialog				*/
/*  (returns)	 : void		:					*/

void	KBFramer::framerPropDlg ()
{
#if	! __KB_RUNTIME
	propertyDlg () ;
#endif
}

#if	! __KB_RUNTIME

/*  KBFramer								*/
/*  makeNewPopup: Make a new-thingy popup menu for a framer		*/
/*  cancel	: bool		: Show cancel item			*/
/*  _rect	: QRect		: New object area			*/
/*  (returns)	: void		:					*/

KBPopupMenu
	*KBFramer::makeNewPopup
	(	bool	,
		QRect	_rect
	)
{
	newRect	= _rect	;

	/* The new-thing popup depends on whether the framer is		*/
	/* embedded in a form, a report or a container. Detect which of	*/
	/* these obtains, and call the corresponding root object to do	*/
	/* the business.						*/
	if (getRoot()->isForm     () != 0)
		return	getRoot()->isForm     ()->makeFramerPopup (this, &bState) ;

	if (getRoot()->isReport   () != 0)
		return	getRoot()->isReport   ()->makeFramerPopup (this, &bState) ;

	if (getRoot()->isComponent() != 0)
		return	getRoot()->isComponent()->makeFramerPopup (this, &bState) ;

	return	0 ;
}

/*  KBFramer								*/
/*  designPopup	: Handle design menu request				*/
/*  e		: QMouseEvent *	: Associated mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBFramer::designPopup
	(	QMouseEvent	*e,
		uint
	)
{
	KBPopupMenu popupMain	(&bState) ;
	KBPopupMenu *popupEdit	= new KBPopupMenu (&bState) ;
	KBPopupMenu *popupNew	= makeNewPopup (false, QRect()) ;

	KBNode	*dummy	;
	bool	noIns	= !KBFormCopier::self()->anyCopied(dummy) ;
	bool	noItem	= true	   ;
	CITER (Item, i, noItem = false ; break )

	QString	cText	;
	QString	sText	;

	if	(isHeader    () != 0)
	{	cText = TR("Header")     	;
		sText = TR("header")      	;
	}
	else if (isFooter    () != 0)
	{	cText = TR("Footer")		;
		sText = TR("footer")		;
	}
	else if (isTabberPage() != 0)
	{	cText = TR("Tabber page")	;
		sText = TR("tabber page")	;
	}
	else
	{	cText = TR("Container")		;
		sText = TR("container")		;
	}

	popupEdit->insertEntry (false,	QString(TR("C&ut %1"  )).arg(sText),  this, SLOT(cutObj   	())) ;
	popupEdit->insertEntry (false,	QString(TR("&Copy %1" )).arg(sText),  this, SLOT(copyObj  	())) ;
	popupEdit->insertEntry (noIns,  TR("&Paste objects"),       	      this, SLOT(pasteObjects 	())) ;
	popupEdit->insertEntry (noIns,  TR("Paste &here"),	   	      this, SLOT(pasteHere	())) ;
 	popupEdit->insertEntry (false,  TR("Paste component"),		      this, SLOT(pasteComponent	())) ;
 	popupEdit->insertEntry (false,  TR("Link component"),		      this, SLOT(linkComponent	())) ;
	popupEdit->insertEntry (false,	QString(TR("Delete %1")).arg(sText),  this, SLOT(deleteObj	())) ;
 
	popupMain .insertItem  (TR("Cancel")) ;
	popupMain .insertItem  (TR("&Edit"), popupEdit) ;
	popupMain .insertItem  (TR("&New"),  popupNew ) ;

	/* If the owning document is a form then and a menu option to	*/
	/* allow tab order setting.					*/
	if (getRoot()->isForm())
		popupMain .insertEntry
		(	noItem,
			TR("Set tab order"),
			this, SLOT(newTabOrder())
		)	;

	popupMain .insertItem  (TR("Save as component"),this, SLOT(saveAsComponent())) ;

	/* Add a menu option for the properties of this object itself.	*/
	popupMain .insertItem
	(	QString(TR("%1 properties")).arg(cText),
		this,
		SLOT(propertyDlg ())
	)	;

	/* If there is an owning block then provide access to that	*/
	/* blocks properties.						*/
	popupMain .insertItem
	(	TR("Block &properties"),
		this,
		SLOT(blockPropDlg())
	)	;

	/* Lastly, add a menu item to access the property dialog of the	*/
	/* dicument itself.						*/
	popupMain .insertItem
	(	TR("&Document properties"),
		this,
		SLOT(docPropDlg())
	)	;

	insertAt	= e->pos ()	 ;
	newRect		= QRect  ()	 ;
	popupMain .exec	(QCursor::pos()) ;
}

#endif

/*  KBFramer								*/
/*  getPosition	: Get associated control position			*/
/*  (returns)	: QRect		:					*/

QRect	KBFramer::getPosition ()
{
	QRect	pRect	= frmDisp->getDisplayWidget()->geometry() ;
	getDisplay()->cvtViewToCtrl (pRect) ;
	return	pRect	;
}

/*  KBFramer								*/
/*  setPalette	: Set palette						*/
/*  (returns)	: void		:					*/

void	KBFramer::setPalette ()
{
//	fprintf
//	(	stderr,
//		"KBFramer::setPalette: this=%p frmDisp=%p\n",
//		(void *)this,
//		(void *)frmDisp
//	)	;

	frmDisp->setPalette  (getPalette (false)) ;
	KBObject::setPalette () ;
}

/*  KBFramer								*/
/*  setFont	: Set font						*/
/*  (returns)	: void		:					*/

void	KBFramer::setFont ()
{
	frmDisp->setFont (getFont (false)) ;
}


/*  KBFramer								*/
/*  buildDisplay: Build display for this node				*/
/*  display	: KBDisplay *	: Parent display			*/
/*  (returns)	: void		:					*/

void	KBFramer::buildDisplay
	(	KBDisplay	*display
	)
{
	QRect	r	= geometry () ;

	frmDisp	= new KBDisplay (display, this, showbar.getBoolValue()) ;
	frmDisp->resize (r.width(), r.height()) ;

	KBObject::buildDisplay (display) ;

	CITER
	(	Object,
		o,
		o->buildDisplay (frmDisp)
	) ;
}

/*  KBFramer								*/
/*  buildCtrls	: Build controls for this node				*/
/*  _numRows	: uint		: Number of rows in parent		*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBFramer::buildCtrls
	(	uint		_numRows,
		int		dx,
		int		dy
	)
{
	numRows	= _numRows ;
	KBObject::buildCtrls (_numRows, dx, dy) ;

	if (showbar.getBoolValue())
		blkInfo->scroll = frmDisp ;

	QRect	r = geometry () ;
	frmDisp->move     (r.x    (), r.y     ()) ;
	frmDisp->resize   (r.width(), r.height()) ;

	frmDisp->setTitle (title.getValue()) ;

	setPalette () ;
	setFont	   () ;

	QString	fs	= frame.getValue() ;
	int	coff	= fs.find (',')	   ;

	if (coff >= 0)
		frmDisp->setFrame
		(	fs.left(coff    ).toInt(),
			fs.mid (coff + 1).toInt()
		)	;
	else	frmDisp->setFrame (0, 0) ;

	/* Now build the controls for the embedded objects given the	*/
	/* number of rows to be shown.					*/
	CITER
	(	Object,
		obj,
		obj->buildCtrls (numRows, dx, dy) ;
	) ;

	/* Framer is now properly set up, so show the displays for each	*/
	/* nested block. We are still hidden ...			*/
	CITER
	(	Block,
		b,
		b->getContainer()->show() ;
	)

	/* ... and now we show ourselves.				*/
	frmDisp->show () ;
}

/*  KBFramer								*/
/*  move	: Move the framer in its parent				*/
/*  x		: int		: New X position			*/
/*  y		: int		: New Y position			*/
/*  (returns)	: void		:					*/

void	KBFramer::move
	(	int	x,
		int	y
	)
{
	KBObject::move (x, y) ;
	if (frmDisp != 0)
		frmDisp ->move (x, y) ;
}

/*  KBFramer								*/
/*  resize	: Resize the framer in its parent			*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBFramer::resize
	(	int	_w,
		int	_h
	)
{
	if (KBObject::resize (_w, _h))
	{
		if (frmDisp != 0)
			frmDisp ->resize (_w, _h) ;

		CITER
		(	Object,
			o,
			o->setGeometry (o->geometry())
		)

		if (showingData())
		{
			KBFormBlock *fBlock = getFormBlock   () ;
			if (fBlock != 0) fBlock->changeSizes () ;

			fixGridLayout () ;
		}

		return	true	;
	}

	return	false	;
}

/*  KBFramer								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBFramer::showAs
	(	KB::ShowAs	mode
	)
{
	frmDisp->showAs (mode) ;

#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
		setSizer (new KBSizer (this, getDisplay(), frmDisp->getDisplayWidget())) ;

	if ((mode == KB::ShowAsData  ) && (getSizer() != 0))
		setSizer (0) ;
#endif

	if ((mode == KB::ShowAsData  ))
	{
		fixTabOrder   () ;
		fixGridLayout () ;
	}

	/* Clear all items. This is mainly intended when switching into	*/
	/* design mode, to clear field contents.			*/
	CITER
	(	Item,
		i, 
		i->clearBelow (1) ;
	)

	/* Pass the request on down to the base class, which will in	*/
	/* turn recurse down to any children.				*/
	KBObject::showAs (mode) ;

	QRect	r = geometry () ;
	move    (r.x    (),  r.y     ()) ;
	resize  (r.width(),  r.height()) ;


	/* Update the display widget, so that we correctly add or	*/
	/* remove the grid and such like.				*/
	frmDisp->getDisplayWidget()->update() ;
}

/*  KBFramer								*/
/*  writeData	 : Display framer contents				*/
/*  prior	 : bool		: Write prior value			*/
/*  (returns)	 : bool		: Success				*/

bool	KBFramer::writeData
	(	bool		prior
	)
{
	QRect	 rect    (QPoint(0, 0), geometry().size()) ;
	KBWriter *writer = getReport()->getWriter() ;
	int	 extra	 ;

	new KBWriterBG (writer, rect, bgcolor.getValue()) ;

	CITER
	(	Object,
		o,
		if (!o->write (writer, QPoint(0,0), true, extra, prior))
			return false ;
	)

	return	true ;
}

/*  KBFramer								*/
/*  height	: Get header or footer height				*/
/*  (returns)	: int		: Height				*/

int	KBFramer::height ()
{
	return	geometry().height() ;
}

/*  KBFramer								*/
/*  write	: Write block 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  offset	: QPoint	: Offset in writer			*/
/*  first	: bool		: First value flag			*/
/*  extra	: int &		: Return extra space			*/
/*  prior	: bool		: Write prior value			*/
/*  (returns)	: bool		: Success				*/

bool	KBFramer::write
	(	KBWriter	*writer,
		QPoint		offset,
		bool		first,
		int		&extra,
		bool		prior
	)
{
	QString	bgcolor	;
	bgcolor.sprintf	("0x%06x", frmDisp->getDisplayWidget()->backgroundColor().rgb() & 0x00ffffff) ;

	new KBWriterBG  (writer, geometry(offset), bgcolor) ;
#if	! __KB_RUNTIME
	if (showingDesign())
		new KBWriterBox (writer, geometry(offset)) ;
#endif

	QPoint	s = writer->setOffset (false, QPoint (geometry().topLeft())) ;
	KBNode::write (writer, offset, first, extra, prior) ;
	writer->setOffset (true, s)  ;
	return	true	;
}

/*  KBFramer								*/
/*  newTabOrder	: Invoke tab order dialog				*/
/*  (returns)	: void		:					*/

void	KBFramer::newTabOrder ()
{
#if	! __KB_RUNTIME
	if (KBNavigator::newTabOrder()) getLayout()->setChanged() ;
#endif
}

/*  KBFramer								*/
/*  newNullBlock: Add a new menu block					*/
/*  (returns)	: void		:					*/

void	KBFramer::newNullBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  	;
	QRect	cRect	= newCtrlRect () ;
	KBBlock	*b	= new KBFormBlock (this, cRect, KBBlock::BTNull, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (frmDisp) ;
	b->showAs   (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFramer								*/
/*  newTableBlock: Add a new table block				*/
/*  (returns)	 : void		:					*/

void	KBFramer::newTableBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  	;
	QRect	cRect	= newCtrlRect () ;
	KBBlock	*b	= new KBFormBlock (this, cRect, KBBlock::BTTable, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (frmDisp) ;
	b->showAs    (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFramer								*/
/*  newQueryBlock: Add a new query block				*/
/*  (returns)	 : void		:					*/

void	KBFramer::newQueryBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  ;
	QRect	cRect	= newCtrlRect () ;
	KBBlock	*b	= new KBFormBlock (this, cRect, KBBlock::BTQuery, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (frmDisp) ;
	b->showAs    (KB::ShowAsDesign)	;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;

#endif
}

/*  KBFramer								*/
/*  newSQLBlock	: Add a new SQL block					*/
/*  (returns)	: void		:					*/

void	KBFramer::newSQLBlock ()
{
#if	! __KB_RUNTIME
	bool	ok  ;
	QRect	cRect	= newCtrlRect () ;
	KBBlock	*b	= new KBFormBlock (this, cRect, KBBlock::BTSQL, ok) ;

	if (!ok)
	{
		delete	b ;
		return	;
	}

	b->buildDisplay (frmDisp) ;
	b->showAs   (KB::ShowAsDesign) ;
	b->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFramer								*/
/*  newContainer : Add a new container					*/
/*  (returns)	 : void		:					*/

void	KBFramer::newContainer ()
{
#if	! __KB_RUNTIME
	QRect	   cRect = newCtrlRect () ;
	KBAttrDict cDict ;

	cDict.addValue ("x", cRect.x     ()) ;
	cDict.addValue ("y", cRect.y	 ()) ;
	cDict.addValue ("w", cRect.width ()) ;
	cDict.addValue ("h", cRect.height()) ;


	bool	 ok	;
	KBFramer *c	= new KBContainer (this, cDict, "KBContainer", &ok) ;
	if (!ok) return ;

	c->buildDisplay (frmDisp) ;
	c->showAs   (KB::ShowAsDesign) ;
	c->getContainer()->show() ;
	getLayout()->setChanged() ;
#endif
}

/*  KBFramer								*/
/*  rowsInBlock	: Calculate number of rows that can be displayed	*/
/*  dx		: int		: X-delta				*/
/*  dy		: int		: Y-delta				*/
/*  (returns)	: uint		: Number of rows			*/

uint	KBFramer::rowsInFrame
	(	int		dx,
		int		dy
	)
{
	if (frmDisp != 0)
	{
		QSize	s	= frmDisp->effectiveSize() ;
		uint	fw	= s.width  () ;
		uint	fh	= s.height () ;

		uint	nr	= 999	;

		CITER
		(	Item,
			i,

			uint _nr = i->calcNumRows (fw, fh, dx, dy) ;
			if (_nr < nr) nr = _nr ;
		)

		CITER
		(	Framer,
			f,

			uint _nr = f->rowsInFrame (dx, dy) ;
			if (_nr < nr) nr = _nr ;
		)

//		fprintf	(stderr, "KBFramer::rowsInFrame => %d\n", nr) ;
		if (nr <=   0) nr = 1 ;
		return	nr ;
	}

	return	999	;
}

/*  KBFramer								*/
/*  hideBelow	: Hide all controls below specified row			*/
/*  qRow	: uint		: Query row from which to hide		*/
/*  (returns)	: void		:					*/

void	KBFramer::hideBelow
	(	uint	qRow
	)
{
	CITER
	(	Item,
		i,
		i->hideBelow (qRow)
	)
}

/*  KBFramer								*/
/*  nRows	: nRows		: Number of rows to extend to		*/
/*  dx		: int		: X-delta				*/
/*  dy		: int		: Y-delta				*/
/*  (returns)	: void		:					*/

void	KBFramer::extendCtrls
	(	uint	nRows,
		int	dx,
		int	dy
	)
{
	CITER
	(	Item,
		i,
		i->extendCtrls (nRows, dx, dy)
	)
}

/*  KBFramer								*/
/*  clearFields	: Clear values in fields in row				*/
/*  qrow	: uint		: Query row				*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBFramer::clearFields
	(	uint	qrow,
		bool	query
	)
{
	CITER
	(	Item,
		i,
		i->clearValue  (qrow, query)
	)	;
	CITER
	(	Framer,
		f,
		f->clearFields (qrow, query)
	)	;
}

/*  KBFramer								*/
/*  changed	: See of any item has changed				*/
/*  curQRow	: uint		: Row to check				*/
/*  (returns)	: bool		: True if changed			*/

bool	KBFramer::changed
	(	uint	curQRow
	)
{
	CITER
	(	Item,
		i,
		if (i->isUpdateVal () && i->changed(curQRow))
		{
			fprintf
			(	stderr,
				"KBFramer::changed: [%s]\n",
				(cchar *)i->getName()
			)	;
			return	true ;
		}
	)

	CITER
	(	Framer,
		f,
		if (f->changed(curQRow)) return true ;
	)

	return	false	;
}

/*  KBFramer								*/
/*  getNumRows	: Get number of rows in query				*/
/*  (returns)	: uint		: Number of rows			*/

uint	KBFramer::getNumRows ()
{
	return	query == 0 ? 0 : query->getNumRows (qryLvl) ;
}

/*  KBFramer								*/
/*  getCurQRow	: Get current query row					*/
/*  (returns)	: uint		: Query row number			*/

uint	KBFramer::getCurQRow ()
{
	return	getBlock()->getCurQRow() ;
}


/*  KBFramer								*/
/*  getRowValue	: Get value from query					*/
/*  name	: const QString & : Query column name			*/
/*  qrow	: uint		  : Query row				*/
/*  (returns)	: KBValue	  : Value				*/

KBValue	KBFramer::getRowValue
	(	const QString	&name,
		uint		qrow
	)
{
	if (qrow <= getNumRows())
		CITER
		(	Item,
			i,
			if (i->getName() == name)
				return	query->getField (qryLvl, qrow, i->getQueryIdx()) ;
		)

	return	KBValue() ;
}

/*  KBFramer								*/
/*  setRowValue	: Set value						*/
/*  name	: const QString & : Query column name			*/
/*  qrow	: uint		  : Query row				*/
/*  value	: const KBValye & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBFramer::setRowValue
	(	const QString	&name,
		uint		qrow,
		const KBValue	&value
	)
{
	if (qrow <= getNumRows())
		CITER
		(	Item,
			i,
			if (i->getName() == name)
			{	query->setField (qryLvl, qrow, i->getQueryIdx(), value) ;
				return	;
			}
		)
}

/*  KBFramer								*/
/*  setEnabled	: Set control enabled/disabled				*/
/*  enabled	: bool		: Enabled/disabled			*/
/*  (returns)	: void		:					*/

void	KBFramer::setEnabled
	(	bool	enabled
	)
{
	frmDisp->getDisplayWidget()->setEnabled (enabled) ;
}

/*  KBFramer								*/
/*  setVisible	: Set framer visibilty					*/
/*  (returns)	: void		  :					*/

void	KBFramer::setVisible
	(	bool		visible
	)
{
	if (visible)
		frmDisp->getDisplayWidget()->show() ;
	else	frmDisp->getDisplayWidget()->hide() ;
}

/*  KBFramer								*/
/*  isEnabled	: Get control enabled/disabled				*/
/*  (returns)	: bool		: Enabled/disabled			*/

bool	KBFramer::isEnabled ()
{
	return	frmDisp->getDisplayWidget()->isEnabled () ;
}

/*  KBFramer								*/
/*  isVisible	: Get control visibility				*/
/*  (returns)	: bool		: Visibility				*/

bool	KBFramer::isVisible ()
{
	return	frmDisp->getDisplayWidget()->isVisible () ;
}

/*  KBFramer								*/
/*  showData	: Show data in framer					*/
/*  (returns)	: bool		: Success				*/

bool	KBFramer::showData ()
{
	CITER
	(	FormBlock,
		b,
		if (!b->requery () || !b->showData ())
		{	setError (b->lastError()) ;
			return   false ;
		}
	) ;
	CITER
	(	Framer,
		f,
		if (!f->showData ())
		{	setError (f->lastError()) ;
			return   false ;
		}
	)

	return	true	;
}

/*  KBFramer								*/
/*  pasteObjects: Paste in cut or copied objects			*/
/*  (returns)	: void		:					*/

void	KBFramer::pasteObjects ()
{
#if	! __KB_RUNTIME
	insertObjects (frmDisp) ;
#endif
}

/*  KBFramer								*/
/*  pasteHere	: Paste in cut or copied objects at specified position	*/
/*  (returns)	: void		:					*/

void	KBFramer::pasteHere ()
{
#if	! __KB_RUNTIME
	insertHere
	(	KBFormCopier::self()->getCopied (objType()),
		frmDisp,
		insertAt
	)	;
#endif
}

/*  KBFramer								*/
/*  pasteComponent							*/
/*		: Paste component object				*/
/*  (returns)	: void		:					*/

void	KBFramer::pasteComponent ()
{
#if	! __KB_RUNTIME
	insertComponent
	(	frmDisp,
		insertAt,
		newRect,
		true
	)	;
#endif
}

/*  KBFramer								*/
/*  linkComponent							*/
/*		: Link component object					*/
/*  (returns)	: void		:					*/

void	KBFramer::linkComponent ()
{
#if	! __KB_RUNTIME
	insertComponent
	(	frmDisp,
		insertAt,
		newRect,
		false
	)	;
#endif
}


/*  KBFramer								*/
/*  setRowMarked: Row marking operation					*/
/*  qrow1	: uint		: First row				*/
/*  qrow2	: uint		: Upper limit				*/
/*  (returns)	: void		:					*/

void	KBFramer::setRowMarked
	(	uint		qrow1,
		uint		qrow2
	)
{
	for (uint qrow = qrow1 ; qrow < qrow2 ; qrow += 1)
	{
		bool	marked	= query->getRowMarked (qryLvl, qrow) ;

		CITER
		(	Item,
			i,
			i->setMarked    (qrow, marked)
		)
	}

	CITER
	(	Framer,
		f,
		f->setRowMarked (qrow1, qrow2)
	)
}

/*  KBFramer								*/
/*  doAction	: Propogate action down to nested blocks		*/
/*  action	: KB::Action	: Action in question			*/
/*  (returns)	: bool		: Success				*/

bool	KBFramer::doAction
	(	KB::Action	action
	)
{
	/* NOTE: Calls to this method only make sense for actions like	*/
	/*	 save....						*/
	CITER
	(	FormBlock,
		b,
		if (!b->doAction (action))
		{	setError (b->lastError()) ;
			return   false ;
		}
	)
	CITER
	(	Framer,
		f,
		if (!f->doAction (action))
		{	setError (f->lastError()) ;
			return   false ;
		}
	)

	return	true	;
}

/*  KBFramer								*/
/*  setQryLevel	: Pass query level information into sub-blocks		*/
/*  _qryLvl	: uint		: Query level				*/
/*  _query	: KBQryBase *	: Query					*/
/*  (returns)	: void		:					*/

void	KBFramer::setQryLevel
	(	uint		_qryLvl,
		KBQryBase	*_query
	)
{
	/* Scan for framers and pass down the query into them in case	*/
	/* they contain sub-blocks ....					*/
	CITER
	(	Framer,
		f,
		f->setQryLevel (_qryLvl, _query) ;
	)

	/* ... and then scan for any directly nested sub-blocks.	*/
	CITER
	(	Block,
		b,
		if (b->getBlkType() == KBBlock::BTSubBlock)
			b->setQryLevel (_qryLvl + 1, _query) ;
	)
}

/*  KBFramer								*/
/*  anyChildBlock: See if there are any child blocks.			*/
/*  (returns)	 : bool		: True if child blocks exist		*/

bool	KBFramer::anyChildBlock	()
{
	/* Scan through all child objects. Descend into any framers,	*/
	/* and return if we find a block _other_ than null blocks.	*/
	CITER
	(	Object,
		o,

		if ((o->isFramer() != 0) && o->isFramer()->anyChildBlock())
			return	true	;

		if ((o->isBlock () != 0) && (o->isBlock()->getBlkType() != KBBlock::BTNull))
			return	true	;
	)

	return	false	;
}

void	KBFramer::getResults
	(	const QString	&path,
		QDict<QString>	&dict
	)
{
	QString	prefix	= QString("%1%2").arg(path).arg(path.isEmpty() ? "" : ".") ;
	uint	qrow	= getBlock()->getCurQRow() ;

	CITER
	(
		Item,
		item,

		if (item->isBlock() == 0)
			dict.insert
			(	QString	("%1%3")
					.arg(prefix)
					.arg(item->getName()),
				new QString(item->getValue(qrow).getRawText())
			)	;
	)

	CITER
	(
		Framer,
		framer,
		framer->getResults
		(	QString	("%1%2%3").arg(prefix).arg(framer->getName()),
			dict
		)	;
	)

	CITER
	(
		FormBlock,
		block,
		block->getResults
		(	QString	("%1%2%3").arg(prefix).arg(block->getName()),
			dict
		)	;
	)
}

/*  KBFramer								*/
/*  setTabOrder	: Return tab order value				*/
/*  order	: int		: Tab order				*/
/*  (returns)	: void		:					*/

void	KBFramer::setTabOrder
	(	int	order
	)
{
	tabOrd.setValue (order) ;
}

/*  KBFramer								*/
/*  getTabOrder	: Return tab order value				*/
/*  (returns)	: int		: Tab order				*/

int	KBFramer::getTabOrder ()
{
	return	tabOrd.getIntValue () ;
}

/*  ------------------------------------------------------------------  */

/*  KBHeader								*/
/*  KBHeader	: Constructor for block header node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBFramer	:					*/

KBHeader::KBHeader
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		cchar			*element,
		bool			*ok
	)
	:
	KBFramer (parent, aList, element, ok)
{
	int	h = geometry().height() ;

	KBObject::move	 (0, 0) ;
	KBObject::resize (0, h) ;
	xmode.setValue   (KBObject::FMStretch) ;
	ymode.setValue   (KBObject::FMFixed  ) ;

	attribs.remove (getAttr("x")) ;
	attribs.remove (getAttr("y")) ;
	attribs.remove (getAttr("w")) ;
	attribs.remove (&xmode  ) ;
	attribs.remove (&ymode  ) ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::framerPropDlg (this, attribs, 0))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBHeader								*/
/*  KBHeader	: Consructor for header node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  frame	: KBFramer *	: Extant framer				*/
/*  (returns)	: KBFramer	:					*/

KBHeader::KBHeader
	(	KBNode	  *parent,
		KBHeader  *header
	)
	:
	KBFramer  (parent, header)
{
}

/*  KBHeader								*/
/*  ~KBHeader	: Destructor for framer node				*/
/*  (returns)	:		:					*/

KBHeader::~KBHeader ()
{
}

/*  KBHeader								*/
/*  replicate	: Replicate this header					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New framer node			*/

KBNode	*KBHeader::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBHeader (_parent, this)) ;
}


/*  KBHeader								*/
/*  buildDisplay: Build display for this node				*/
/*  display	: KBDisplay *	: Parent display			*/
/*  (returns)	: void		:					*/

void	KBHeader::buildDisplay
	(	KBDisplay	*display
	)
{
	KBFramer::buildDisplay (display) ;

	frmDisp->setTagLabel
	(	QString(TR("Header: %1")).arg(getBlock()->getQueryComment())
	)	;
}

/*  KBHeader								*/
/*  resize	: Resize the header in its parent			*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBHeader::resize
	(	int	,
		int	_h
	)
{
	return	KBFramer::resize
		(	getParent()->isObject()->geometry().width(),
			_h
		)	;
}

/*  KBHeader								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBHeader::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
	{
		static	QCursor	cSizeVer  (SizeVerCursor) ;

		KBSizerInfoSet	infoSet	;
		KBSizer::defaultInfoSet (infoSet) ;

		infoSet.tl.proxy  = getParent()->isObject() ;
		infoSet.tr.proxy  = getParent()->isObject() ;
		infoSet.bl.flags  = SZF_Y	;
		infoSet.bl.cursor = &cSizeVer	;
		infoSet.br.flags  = SZF_Y	;
		infoSet.br.cursor = &cSizeVer	;


		setSizer
		(	new KBSizer
			(	this,
				getDisplay(),
				frmDisp->getDisplayWidget(),
				&infoSet
		)	)	;
	}
#endif
	KBFramer::showAs (mode) ;
}


/*  ------------------------------------------------------------------  */

/*  KBFooter								*/
/*  KBFooter	: Constructor for block footer node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBFramer	:					*/

KBFooter::KBFooter
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		cchar			*element,
		bool			*ok
	)
	:
	KBFramer (parent, aList, element, ok)
{
	int	h = geometry().height() ;

	KBObject::move	 (0, h) ;
	KBObject::resize (0, h) ;
	xmode.setValue   (KBObject::FMStretch) ;
	ymode.setValue   (KBObject::FMFloat  ) ;

	attribs.remove (getAttr("x")) ;
	attribs.remove (getAttr("y")) ;
	attribs.remove (getAttr("w")) ;
	attribs.remove (&xmode  ) ;
	attribs.remove (&ymode  ) ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::framerPropDlg (this, attribs, 0))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBFooter								*/
/*  KBFooter	: Consructor for footer node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  frame	: KBFramer *	: Extant framer				*/
/*  (returns)	: KBFramer	:					*/

KBFooter::KBFooter
	(	KBNode	  *parent,
		KBFooter  *footer
	)
	:
	KBFramer  (parent, footer)
{
}

/*  KBFooter								*/
/*  ~KBFooter	: Destructor for footer node				*/
/*  (returns)	:		:					*/

KBFooter::~KBFooter ()
{
}

/*  KBFooter								*/
/*  replicate	: Replicate this footer					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New framer node			*/

KBNode	*KBFooter::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBFooter (_parent, this)) ;
}

/*  KBFooter								*/
/*  buildDisplay: Build display for this node				*/
/*  display	: KBDisplay *	: Parent display			*/
/*  (returns)	: void		:					*/

void	KBFooter::buildDisplay
	(	KBDisplay	*display
	)
{
	KBFramer::buildDisplay (display) ;

	frmDisp->setTagLabel
	(	QString(TR("Footer: %1")).arg(getBlock()->getQueryComment())
	)	;
}

/*  KBFooter								*/
/*  resize	: Resize the footer in its parent			*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBFooter::resize
	(	int	,
		int	_h
	)
{
	QRect	pr = getParent()->isObject()->geometry() ;
	KBFramer::move   (0, pr.height() - _h) ;
	return	KBFramer::resize (pr.width (),  _h) ;
}

/*  KBFooter								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBFooter::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
	{
		static	QCursor	cSizeVer  (SizeVerCursor) ;

		KBSizerInfoSet	infoSet	;
		KBSizer::defaultInfoSet (infoSet) ;

		infoSet.bl.proxy  = getParent()->isObject() ;
		infoSet.br.proxy  = getParent()->isObject() ;
		infoSet.tl.flags  = SZF_Y	;
		infoSet.tl.cursor = &cSizeVer	;
		infoSet.tr.flags  = SZF_Y	;
		infoSet.tr.cursor = &cSizeVer	;

		setSizer
		(	new KBSizer
			(	this,
				getDisplay(),
				frmDisp->getDisplayWidget(),
				&infoSet
		)	)	;
	}
#endif
	KBFramer::showAs (mode) ;
}

/*  ------------------------------------------------------------------  */

/*  KBContainer								*/
/*  KBContainer	: Constructor for container node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBFramer	:					*/

KBContainer::KBContainer
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		cchar			*element,
		bool			*ok
	)
	:
	KBFramer (parent, aList, element, ok)
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::framerPropDlg (this, attribs, 0))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBContainer								*/
/*  KBContainer	: Consructor for container node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  container	: KBContainer *	: Extant framer				*/
/*  (returns)	: KBContainer	:					*/

KBContainer::KBContainer
	(	KBNode	     *parent,
		KBContainer  *container
	)
	:
	KBFramer  (parent, container)
{
}

/*  KBContainer								*/
/*  ~KBContainer: Destructor for container node				*/
/*  (returns)	:		:					*/

KBContainer::~KBContainer ()
{
}

/*  KBContainer								*/
/*  replicate	: Replicate this container				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New framer node			*/

KBNode	*KBContainer::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBContainer (_parent, this)) ;
}

/*  KBContainer								*/
/*  resize	: Resize the footer in its parent			*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBContainer::resize
	(	int	_w,
		int	_h
	)
{
	if (KBFramer::resize (_w, _h))
	{
		if ((frmDisp != 0) && (getBlock() != 0))
			getBlock()->buildCtrls (0, 0, 0) ;
		return	true	;
	}

	return	false	;
}

/*  KBContainer								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBContainer::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
	{
		setSizer
		(	new KBSizer
			(	this,
				getDisplay(),
				frmDisp->getDisplayWidget()
		)	)	;
	}
#endif
	KBFramer::showAs (mode) ;
}

/*  ------------------------------------------------------------------  */

/*  KBTabberPage							*/
/*  KBTabberPage: Constructor for tabber page node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  element	: cchar *	: Element name				*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBFramer	:					*/

KBTabberPage::KBTabberPage
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		cchar			*element,
		bool			*ok
	)
	:
	KBFramer (parent, aList, element, ok),
	tabText	 (this,   "tabtext", aList, KF_FORM)
{
	xmode.setValue (KBObject::FMStretch) ;
	ymode.setValue (KBObject::FMStretch) ;
	attribs.remove (getAttr("x")) ;
	attribs.remove (getAttr("y")) ;
	attribs.remove (getAttr("w")) ;
	attribs.remove (getAttr("h")) ;
	attribs.remove (&xmode)   ;
	attribs.remove (&ymode)   ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::framerPropDlg (this, attribs, 0))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBTabberPage							*/
/*  KBTabberPage: Consructor for tabber page node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  tabberpage	: KBTabberPage *: Extant page				*/
/*  (returns)	: KBTabberPage	:					*/

KBTabberPage::KBTabberPage
	(	KBNode	  	*parent,
		KBTabberPage 	*page
	)
	:
	KBFramer  (parent, page),
	tabText	  (this,  "tabtext", page, KF_FORM)
{
	attribs.remove (getAttr("x")) ;
	attribs.remove (getAttr("y")) ;
	attribs.remove (getAttr("w")) ;
	attribs.remove (getAttr("h")) ;
	attribs.remove (&xmode)   ;
	attribs.remove (&ymode)   ;
}

/*  KBTabberPage							*/
/*  ~KBTabberPage: Destructor for tabber page node			*/
/*  (returns)	:		:					*/

KBTabberPage::~KBTabberPage ()
{
}

/*  KBTabberPage							*/
/*  replicate	: Replicate this tabber page				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New framer node			*/

KBNode	*KBTabberPage::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBTabberPage (_parent, this)) ;
}


/*  KBTabberPage								*/
/*  resize	: Resize the tabber page in its parent			*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  (returns)	: bool		: Size changed				*/

bool	KBTabberPage::resize
	(	int	,
		int	
	)
{
	QRect	pr = getParent()->isObject()->geometry() ;

	extern	int	tabBarHeight () ;
	int	tbh   = tabBarHeight () ;

	KBFramer::move (0, tbh) ;
	return	KBFramer::resize (pr.width(), pr.height() - tbh) ;
}

/*  KBtabberPage							*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBTabberPage::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (getSizer() == 0))
	{
		static	QCursor	cSizeVer  (SizeVerCursor) ;
		extern	QCursor	cNoCursor ;

		KBSizerInfoSet	infoSet	;
		KBSizer::defaultInfoSet (infoSet) ;

		infoSet.bl.proxy  = getParent()->isObject() ;
		infoSet.br.proxy  = getParent()->isObject() ;
		infoSet.tl.flags  = 0		;
		infoSet.tl.cursor = &cNoCursor	;
		infoSet.tr.flags  = 0		;
		infoSet.tr.cursor = &cNoCursor	;

		setSizer
		(	new KBSizer
			(	this,
				getDisplay(),
				frmDisp->getDisplayWidget(),
				&infoSet
		)	)	;
	}
#endif
	KBFramer::showAs (mode) ;
}

/*  KBtabberPage							*/
/*  propertyDlg	: Show tabber page property dialog			*/
/*  iniattr	: cchar *	: Initial attribute			*/ 
/*  (returns)	: bool		: Success				*/

bool	KBTabberPage::propertyDlg ()
{
	if (!KBFramer::propertyDlg ()) return false ;

	getParent()->isTabber()->setTabText (this, tabText.getValue()) ;
	return	true	;
}

void	KBTabberPage::setOffset
	(	int	offset
	)
{
	KBObject::move (0, offset) ;
}

void	KBTabberPage::setEnabled
	(	bool	enabled
	)
{
	if (getParent()->isTabber() != 0)
		getParent()->isTabber()->setPageEnabled (this, enabled) ;

	if (frmDisp != 0)
		frmDisp->getDisplayWidget()->setEnabled (enabled) ;
}

void	KBTabberPage::setCurrent ()
{
	if (getParent()->isTabber() != 0)
		getParent()->isTabber()->setCurrentPage (this) ;
}



#if	! __KB_RUNTIME

void	KBFramer::updateProps ()
{
	setPalette () ;
	setFont	   () ;

	if (getBlock() != 0)
		getBlock ()->buildCtrls(0, 0, 0) ;

	getLayout()->setChanged() ;
	getLayout()->addSizer  (getSizer(), false) ;
}

/*  KBFramer								*/
/*  propertyDlg	: Show framer property dialog				*/
/*  iniattr	: cchar *	: Initial attribute			*/ 
/*  (returns)	: bool		: Success				*/

bool	KBFramer::propertyDlg ()
{
	if (!::framerPropDlg (this, attribs, 0)) return false ;

	updateProps() ;
	return	true  ;
}
#endif


NEWNODENAMED(Header,     (cchar *)0, KF_REPORT, BlockHeader)
NEWNODENAMED(Footer,     (cchar *)0, KF_REPORT, BlockFooter)
NEWNODENAMED(Container,  (cchar *)0, KF_FORM,   Container  )
NEWNODENAMED(TabberPage, (cchar *)0, KF_FORM,   TabberPage )
